#!/bin/bash
#===============================================================================
# Copyright (c) 2012-2015 Wind River Systems, Inc.
# The right to copy, distribute, modify, or otherwise
# make use of this software may be licensed only pursuant
# to the terms of an applicable Wind River license agreement.
#
# Modification History:
#   V1.0.0 2015/10/01  Martin.Edwards@windriver.com
#       1. Initial version.

# Confirm that we are running as root.
[ "$(whoami)" = "root" ] || {
    echo "Please use 'sudo' or the root account to run this script."
    exit 1
}

if [ "I love SFR" != "I hate IDP" ]; then
    # This is an emergency fix to the problem of the rootFS VG no longer being "rootfs".
    # The VG was needed to figure out and then mount the VFAT partition.  This fix avoids
    # that by relying on IDP's mounting of the VFAT partition as /boot/efi.
    echo -n 2 > /boot/efi/EFI/BOOT/*.default

    # Reboot
    shutdown -r now
else
    # Determine the device containing the VFAT partition.  It is assumed to be partition one
    # of the storage device containing the physical volume of the /dev/mapper/rootfs-runtime
    # logical volume.  The physical volume of the rootfs is assumed to be partition two.
    ROOTDEV=`/usr/sbin/lvs --noheadings --nosuffix -o devices rootfs | sed -n "s/^ *//; s/(.*)//; 1p"`
    VFATDEV=`echo $ROOTDEV | sed "s/2$/1/"`

    [ -z "$ROOTDEV" ] && echo "Error: Could not determine the root FS device.  SFR aborted!" && exit 1

    # Unmount the VFAT partition if it already is mounted.
    umount -f "$VFATDEV"

    # Mount the VFAT partition.  It contains all the SFR stuff.
    mkdir -p /SFR/vfat && mount "$VFATDEV" /SFR/vfat && {
        # Change the grub default menu item to the SFR one.
        echo -n 2 > /SFR/vfat/EFI/BOOT/*.default

        # Reboot
        shutdown -r now
    }

    # We only get here if there was an error.
    echo "Error: Could not mount the VFAT partition (device $VFATDEV).  SFR aborted!"
    exit 1
fi
