#!/bin/bash

# find the mount point of /mnt and the size of the LV
ROOTDEV=`df / | tail -1 | awk '{ print $1 }'`
LV_INFO=`sudo lvdisplay ${ROOTDEV} -c 2> /dev/null`

# exit if the mount point is not a LVM volume
if [ -z $LV_INFO ]; then
    echo "${ROOTDEV} not a LVM volume"
    exit -1
fi

# in order to mount the snapshot, scan volume group and mknodes in /dev/mapper/
sudo vgscan --mknodes --ignorelockingfailure

# find the size of the LVM volume
IFS=':' read -a INFO <<< ${LV_INFO}
LV_NAME=$(basename ${INFO[0]})
VG_NAME=${INFO[1]}
LV_SIZE=`sudo lvs ${ROOTDEV} -o LV_SIZE --noheadings --units G`
SNAPSHOT_VOL=/dev/${VG_NAME}/${LV_NAME}_snapshot
echo "Found rootfs mount point at ${ROOTDEV}"

# copy kernel image to grub boot partition
PV_INFO=`sudo pvdisplay -c 2> /dev/null`
IFS=':' read -a INFO <<< ${PV_INFO}
PV_NAME=${INFO[0]}
PV_VG_NAME=${INFO[1]}
if [ ${PV_VG_NAME} == ${VG_NAME} ]; then
    DEV_DIR=$(dirname ${PV_NAME})
    DEV_NODE=`echo $(basename ${PV_NAME}) | sed 's/[0-9]*//g'`
    echo "Found boot partition in $DEV_DIR/${DEV_NODE}1 "
    # mount snapshot directory
	echo "Mount ${SNAPSHOT_VOL}"
    temp_snapshot_dir="$(sudo mktemp -d -p ./)"
    sudo mount ${SNAPSHOT_VOL} $temp_snapshot_dir
    # mount the boot directory
	echo "Mount $DEV_DIR/${DEV_NODE}1"
    temp_dir="$(sudo mktemp -d -p ./)"
    sudo mount $DEV_DIR/${DEV_NODE}1 $temp_dir
    # copy bzImage 
    echo "Copy kernel image to boot partition in $DEV_DIR/${DEV_NODE}1 "
    sudo cp ${temp_snapshot_dir}/boot/bzImage ${temp_dir}
    # mount both directory
    sudo umount $temp_snapshot_dir
    sudo umount $temp_dir
    rm -rf $temp_snapshot_dir
    rm -rf $temp_dir
else
    echo "Failed to find volume group ${VG_NAME} in ${PV_NAME}"
fi

# rollback to the original volume, the snapshot will be gone after the merge
echo "Roll back to ${SNAPSHOT_VOL}"
sudo lvconvert --merge ${SNAPSHOT_VOL}


