#!/bin/bash

# find the mount point of / and the size of the LV
ROOTDEV=`df / | tail -1 | awk '{ print $1 }'`
LV_INFO=`sudo lvdisplay ${ROOTDEV} -c 2> /dev/null`

# exit if the mount point is not a LVM volume
if [ -z $LV_INFO ]; then
	echo "${ROOTDEV} not a LVM volume"
	exit 0
fi

# find the size of the LVM volume
IFS=':' read -a INFO <<< ${LV_INFO}
LV_NAME=$(basename ${INFO[0]})
VG_NAME=${INFO[1]}
LV_SIZE=`sudo lvs ${ROOTDEV} -o LV_SIZE --noheadings --units G`
SNAPSHOT_VOL=/dev/${VG_NAME}/${LV_NAME}_snapshot
echo "Found rootfs mount point at ${ROOTDEV}"

# refresh status
sudo lvchange --refresh ${ROOTDEV} --noudevsync --monitor n 
sudo lvchange --refresh ${ROOTDEV}_snapshot --noudevsync --monitor n 

# delete the previous snapshot so that we have enough space 
echo "Removing previous ${SNAPSHOT_VOL}"
sudo lvremove --noudevsync -f ${SNAPSHOT_VOL} &> /dev/null

# take a snapshot of the current running rootfs
echo "Create new ${SNAPSHOT_VOL} with volume size ${LV_SIZE}"
sudo lvcreate --noudevsync --monitor n -s -n ${SNAPSHOT_VOL} -L ${LV_SIZE}G ${ROOTDEV}

# display all logical volume
sudo lvdisplay

