/* $Id: AeOSLocal.h,v 1.10.2.1 2009/12/01 18:07:58 hfeng Exp $ */

/*
 * modification history
 * --------------------
 * 4Feb15, hfc add linux OSAL layer from axeda and add support for ipc.
 */

#ifndef _AE_OS_LOCAL_H_
#define _AE_OS_LOCAL_H_

#define _GNU_SOURCE
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <errno.h>

#include <unistd.h>
#include <ctype.h>
#include <fcntl.h>
#include <stdarg.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/times.h>
#include <sys/stat.h>
#include <sys/socket.h>
#include <net/if.h>
#include <sys/ioctl.h>
#include <netdb.h>
#include <netinet/in.h>
#include <netinet/tcp.h>
#include <arpa/inet.h>
#include <dirent.h>
#include <wra.h>
#include <mqueue.h>

#if defined(sun)
#include <sys/filio.h>
#endif

#if defined(HAVE_PTHREADS)
#include <pthread.h>

typedef pthread_mutex_t AeMutex;

#if !defined(PTHREAD_MUTEX_RECURSIVE) && defined(PTHREAD_MUTEX_RECURSIVE_NP)
#define PTHREAD_MUTEX_RECURSIVE PTHREAD_MUTEX_RECURSIVE_NP
#endif

#else

typedef struct _AeMutex AeMutex;
struct _AeMutex
{
    int dummy;
};
#endif /* defined(HAVE_PTHREADS) */

/* buffer size for sockets. change the value as you need */
#define AE_BUFFER_CHUNK 4096

typedef int  AeSocket;
typedef int  AeSocketFD;
typedef fd_set AeFDArray;
typedef int  AeFileHandle;
typedef DIR* AeDirHandle;

#if defined(_LP64) || defined(__LP64__)
#define AE_INT32_FORMAT_MODIFIER ""
#else
#define AE_INT32_FORMAT_MODIFIER "l"
#endif

#if defined(_LP64) || defined(__LP64__)
typedef long AeInt64;
typedef unsigned long AeUInt64;
#define AE_INT64_FORMAT_MODIFIER "l"
#define AeStrToInt64 strtol
#elif (defined __GNUC__ || (defined __STDC_VERSION__ && __STDC_VERSION__ >= 199901L))
typedef long long AeInt64;
typedef unsigned long long AeUInt64;
#define AE_INT64_FORMAT_MODIFIER "ll"
#define AeStrToInt64 strtoll
#endif

#define AeStrToTime(s, e, r) ((time_t) strtol(s, e, r))
#define AE_TIME_FORMAT_MODIFIER "l"

#define AeSocketGetFD(x)    *(x)
#define AeFDZero            FD_ZERO
#define AeFDSet             FD_SET
#define AeFDIsSet           FD_ISSET
#define AeFileInvalidHandle	-1

void *AeAlloc(int size);
void AeFree(void* memptr);
void *AeCalloc(int BlockCount,int BlockSize);
void *AeRealloc(void* memptr,int NewSize);
void wra_reboot(int flag);
int AeMutexTimeLock(AeMutex *pMutex, wra_timestamp *tm);

#define PATH_CHAR	'/'
#define PATH_STR	"/"
#ifndef FALSE
#define FALSE		(0)
#endif

#ifndef TRUE
#define TRUE		(1)
#endif

#define OK		0
#define ERROR		(-1)

#define wra_static_inline    		      static inline

#define WRA_TASK_ID                           pthread_t
#define WRA_TASK_ID_ERROR                     (int)(-1)
#define WRA_MSG_Q_ID                          mqd_t
#define WRA_MSG_Q_ID_ERROR                    (mqd_t)-1
#define WRA_MSG_Q_ID_NULL                     WRA_MSG_Q_ID_ERROR /* 0 is a valid mqid in posix*/

#define WRA_BOOT_CLEAR                         0

typedef struct wra_tcb_st {
	char *name;
	int task_prio;
	int option;
	size_t stack_size;
	long args[10];
	/* add other options to satisfy pthread 
	 * bellow */
}wra_tcb;

#define wra_init_tcb(tcp_ptr)                      \
    do{                                            \
        int i;                                     \
        tcp_ptr->name = NULL;                      \
        tcp_ptr->task_prio = 0;                    \
        tcp_ptr->option = 0;                       \
        tcp_ptr->stack_size = 0;                   \
        for(i = 0; i < 9 ; i++)                    \
        tcp_ptr->args[i] = 0;                      \
       }while((0))

typedef struct wra_mq_attr_st {
	char *name;
	long max_msg;
	long msg_size;
	int flags;
	int permision;
	/* add other options to satisfy other msgq 
	 * bellow */
}wra_mq_attr;

#define wra_init_mq_attr(mq_atr)                      \
    do{                                               \
        mq_atr->name = NULL;                          \
        mq_atr->max_msg = 0;                          \
        mq_atr->msg_size = 0;                         \
        mq_atr->flags = 0;                            \
        mq_atr->permision = 0;                        \
       }while((0))

/* provide compatibility with [broken] uc-libc for uClinux */
#if defined(m68k) && defined(__pic__) && defined(__linux__) && !defined(__UCLIBC__)
#define __UC_LIBC__

extern int snprintf(char *str, size_t size, const char *format, ...);
extern int vsnprintf(char *str, size_t size, const char *format, va_list ap);
extern int vsprintf(char *str, const char *format, va_list ap);
extern int sscanf(const char *str, const char *format, ...);

extern void abort(void);

extern int gethostname(char *name, size_t len);

#endif /* defined(m68k) && defined(__pic__) && defined(__linux__) && !defined(__UCLIBC__) */
#endif
