/*
 ******************************************************************************
 *               Wind River IoT WR Agent Types 
 *
 * Copyright (c) 1988-2001, 2003-2014 Wind River Systems, Inc.
 *
 * The right to copy, distribute, modify or otherwise make use
 * of this software may be licensed only pursuant to the terms
 * of an applicable Wind River license agreement.
 *
 ******************************************************************************
*/

/*
 ****************************************************************************
 *                      DESCRIPTION
 ****************************************************************************
 */

/*!
 * @file wra_types.h
 *
 * @author dwb 
 * @date 2014/10/24
 *
 */


#ifndef WRA_TYPES_H
#define WRA_TYPES_H

#include <assert.h>
#include <stdint.h>
#if defined(__GNUC__)
/*Supporting <stdbool.h> in C++ is a GCC extension. not supported by diab */
#include <stdbool.h>
#else
typedef int bool;
#endif

/*! Telemetry Types */

/*! Alarm telemetry */
#define WRA_TM_DATATM  "data-tm"
/*! Data telemetry */
#define WRA_TM_ALARMTM "alarm-tm"
/*! Event telemetry */
#define WRA_TM_EVENTTM "event-tm"

#define WRA_TM_ATTR_NAME      "name"
#define WRA_TM_ATTR_DESC      "description"
#define WRA_TM_ATTR_SEVERITY  "severity"
#define WRA_TM_ATTR_PRIORITY  "priority"
#define WRA_TM_ATTR_DATA      "data"
#define WRA_TM_ATTR_DATATYPE  "datatype"
#define WRA_TM_ATTR_ACTIVE    "active"
#define WRA_TM_ATTR_ACK       "ack"
#define WRA_TM_ATTR_CONDITION "condition"
#define WRA_TM_ATTR_DATATM    "aux-data-tm"

#define WRA_TRUE 1
#define WRA_FALSE 0

enum {
  WRA_TM_DATATYPE_DOUBLE,
  WRA_TM_DATATYPE_BOOL,
  WRA_TM_DATATYPE_STRING
};

enum {
  WRA_TM_PRIO_LOW,
  WRA_TM_PRIO_MEDIUM,
  WRA_TM_PRIO_HIGH
};

/*! Success */
#define WRA_SUCCESS 0
/*! Null */
#define WRA_NULL NULL
/*! Failure */
#define WRA_ERR_FAILED -1000
/*! No memory */
#define WRA_ERR_NO_MEMORY -1010 

/*! Invalid Parameter */
#define WRA_ERR_BAD_PARAM -1011

/*! Not Initialized */
#define WRA_ERR_NOT_INIT -1012

/*! Already Exists */
#define WRA_ERR_EXISTS -1013

/*! Full storage */
#define WRA_ERR_FULL -1014

/*! Try again */
#define WRA_ERR_EAGAIN -1015
/*! Timeout */
#define WRA_ERR_ETIMEDOUT -1016

#define wra_assert(s) assert(s)

#endif  /* WRA_TYPES_H */

#ifdef __CYGWIN__
#define __sighandler_t sighandler_t
#define pthread_mutex_timedlock(m,t) pthread_mutex_lock(m)
#endif
