/**
 * @section Copyright (c) 2014 Wind River Systems, Inc.
 *
 * The right to copy, distribute or otherwise make use of this software
 * may be licensed only pursuant to the terms of an applicable Wind River
 * license agreement.
 *
 * @file wra_utils.c
 * @date Feb 12, 2015
 * @author hfc
 *
 * @section WindRiver Agent for Edge Management System
 *
 * @brief this is the header file of userspace wra specific osal layer for Linux.
 *
 * Details:
 */

#ifndef __WRA_UTILS_LINUX_H
#define __WRA_UTILS_LINUX_H
#define _GNU_SOURCE
#include <fcntl.h> /* For O_* constants */
#include <unistd.h>
#include <sys/types.h>
#include <mqueue.h>
#include <stdio.h>
#include <stdlib.h>
#include <pthread.h>
#include <stdarg.h>
#include <signal.h>
#include <sys/utsname.h>
#include <sys/syslog.h>
#include <wra.h>
#include <wra_h.h>
#include <wra_types.h>
#include <AeTypes.h>
#include <AeOSLocal.h>
#ifdef __cplusplus
extern "C" {
#endif

#define WRA_OSAL_DELAY 1
#define CHANNEL_LOCATION "/var/wra/sock"
#define WRA_OTA_ENGINE    "/usr/bin/wra-ota"

typedef void *(*FUNCPTRVR)(void *);
typedef FUNCPTRVR FUNCPTR;

/* <<< For Logging facility */

/* Supported log level */
#define WRALogNone     0  /* for log level set only to disable all */
#define WRALogError    1
#define WRALogWarning  2
#define WRALogInfo     3
#define WRALogDebug    4
#define WRALogTrace    5  /*reserved only for compatibility*/
#define WRALogLevelNum 6

/* Default log level is info, and also output to stderr
 * this can be changed by wragent configure file later */
#define LOG_OPT_DEFAULT  LOG_CONS|LOG_PID|LOG_PERROR
#define LOG_LEVEL_DEFAULT WRALogInfo
#define LOG_IDENT_DEFAULT "wragent"

int  wra_log_open(void);
void wra_log_close(void);
void wra_vlog(unsigned int level, FILE *fs, char *format, va_list *args);
void wra_log(unsigned int level, char *format, ...);
void wra_setlog_fs(FILE *fs);
int  wra_setlog_level(unsigned int level);
FILE* wra_getlog_fs(void);
unsigned int wra_getlog_level();

#define WRALog        wra_log
#define WRALogEx(l, c, f, ...)      wra_log((l), (f), ##__VA_ARGS__)

/* For Logging facility >>>*/

int wra_mq_create(WRA_MSG_Q_ID *mqid, wra_mq_attr *attr);
int wra_mq_close(WRA_MSG_Q_ID mqid);
int wra_mq_unlink(const char *name);
int wra_msg_receive(WRA_MSG_Q_ID mid,char *buf,size_t size,unsigned *prio,wra_timestamp *time_out);
int wra_msg_send(WRA_MSG_Q_ID mid,char *buf,size_t size,unsigned prio,wra_timestamp *time_out);

int wra_task_create(WRA_TASK_ID *tid, wra_tcb *tcb,FUNCPTR fn);
char *wra_get_q_name(char *buf,size_t len,int type,int rand);
int wra_osinfo_get(char *buf, size_t buf_size);
void wra_get_cur_time(AeTimeValue *pTime);
uint64_t wra_get_processid();
wra_status wra_sem_create(AeMutex *psem);
wra_status wra_sem_delete(AeMutex *psem);
wra_status wra_sem_take(AeMutex *psem,wra_timestamp *time_out);
wra_status wra_sem_give(AeMutex *psem);

char *wra_get_channel_name(char *buf,size_t len,char *location,int rand, const char* cookie);
wra_status  wra_create_channel(char *name, int *fd, int flags, int mode, int file_exists);
int wra_channel_read(char *buf, size_t msg_len, wra_timestamp *tmo, int channel, uint32_t flags);
int wra_channel_write(int fd, char *buf, size_t len);
int wra_file_copy(const char *dst_path, const char *src_path);
int wra_channel_close(int fd );
int wra_unlink_channel(char *path);
void wra_encode_abs_file_path(char *buf, const char *path, size_t plen , const char *file, size_t flen);
void wra_setup_signals(void *handler);
int wra_stat(const char *path, int flag);
wra_status wra_ota_init(void);
wra_status wra_ota_finish(void);
#ifdef __cplusplus
}
#endif

#endif /*__WRA_UTILS_LINUX_H*/
