--[[
LuCI - Lua Configuration Interface

Copyright 2008 Steven Barth <steven@midlink.org>

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

$Id$
]]--
local util = require("luci.util")
local sys = require("luci.sys")
local fs = require "nixio.fs"
local math = require "math"

m = SimpleForm("bluetooth", translate("Bluetooth"))
m.reset = false
m.submit = false
m.anonymous = true

daemon = m:section(SimpleSection,"")
daemon.anonymous = true

local enabled = false
if sys.init.enabled("bluetooth") then
    enabled = true
end

local pid_bluetoothd=sys.call("/usr/bin/pgrep bluetoothd > /dev/null 2>&1")
daemon_status = daemon:option(DummyValue, "status", translate("Bluetooth Daemon Status"))
if pid_bluetoothd == 0 then
      daemon_status.value = "Running"
else
      daemon_status.value = "Stopped"
end


dbtn = daemon:option(Button, "enable", translate(" "))
function dbtn.render(self, section, scope)
    if enabled then
        self.inputtitle = translate("Disable")
        self.inputstyle = "apply"
    else
            self.inputtitle = translate("Enable")
        self.inputstyle = "apply"
    end
    Button.render(self, section, scope)
end

function dbtn.write(self, section, value)
    if not enabled then
        sys.init.enable("bluetooth")
        sys.init.start("bluetooth")
    else
        sys.init.stop("bluetooth")
        sys.init.disable("bluetooth")
    end

    luci.http.redirect(luci.dispatcher.build_url("admin", "network", "bluetooth"))
end

bt_dev = util.trim(util.exec("hciconfig | sed -n '1p' | awk '{print $1}' | sed 's/://g'"))
dev_status = sys.exec("hciconfig " .. bt_dev .. " |grep 'UP RUNNING'")
--[[
if dev_status:find("UP RUNNING") then
	iname = util.exec("hciconfig "..bt_dev.." name | grep Name: | awk '{print $2}' | sed \"s/\'//g\"")
	ipageto = sys.exec("hciconfig "..bt_dev.." pageto |grep 'Page timeout:'|awk '{print $3}' | sed \"s/\'//g\"")
	iscantype = "noscan"
	p_scan = sys.exec("hciconfig  | grep 'PSCAN'")
	i_scan = sys.exec("hciconfig  | grep 'ISCAN'")
	pi_scan = sys.exec("hciconfig | grep 'PSCAN ISCAN'")
	if i_scan:find("ISCAN") then
		iscantype = "iscan"
	end
	if p_scan:find("PSCAN") then
		iscantype = "pscan"
	end
	if pi_scan:find("PSCAN ISCAN") then
		iscantype = "piscan"
	end
end
]]--

sc = m:section(SimpleSection,"")
sc.anonymous = true

status = sc:option(ListValue, "status", translate("Bluetooth Device Status"))
status:value("DOWN", translate("DOWN"))
status:value("UP", translate("UP"))
if dev_status:find("UP RUNNING") then
	status.default = "UP"
        --[[
	name = sc:option(Value, "name", translate("Bluetooth Device Name"))
	name.datatype = "hostname"
	name.default = iname

	pageto = sc:option(Value, "pageto", translate("Page Timeout"))
	pageto.datatype = "uinteger"
	pageto.default = ipageto

	scantype = sc:option(ListValue, "scantype", translate("Scan Type"))
	scantype:value("piscan", translate("piscan"))
	scantype:value("pscan", translate("pscan"))
	scantype:value("iscan", translate("iscan"))
	scantype:value("noscan", translate("noscan"))
	scantype.default = iscantype
	]]--
else
        status.default = "DOWN"
end

ap = sc:option(Button, "Apply", translate(" "))
ap.inputtitle = translate("Apply Config")
ap.inputstyle = "apply"

function ap.render(self, section, scope)
    Button.render(self, section, scope)
end

function valid_name(val)
  if val and (#val < 254) and (
    val:match("^[a-zA-Z_]+$") or
    (val:match("^[a-zA-Z0-9_][a-zA-Z0-9_%-%.]*[a-zA-Z0-9]$") and
    val:match("[^0-9%.]"))
    ) then
      return true
    end
    return false
end

function valid_page_timeout(val)
    local n = tonumber(val)
    if n ~= nil and math.floor(n) == n and n >= 0 then
        return true
    end
    return false
end

function ap.write(self, section, value)
	local dev = util.trim(util.exec("hciconfig | sed -n '1p' | awk '{print $1}' | sed 's/://g'"))
	local status_c = util.exec("hciconfig  " .. dev .. " | grep 'UP RUNNING'")
	local status_v = status:formvalue(section)
	if status_c:find("UP RUNNING") then
		--[[
		if status_v == "UP" then
			local name_v = name:formvalue(section)
			local pageto_v = pageto:formvalue(section)
			local scantype_v = scantype:formvalue(section)

			if valid_name(name_v) then
				util.exec("hciconfig " .. dev .. " name " .. name_v)
			end

			if valid_page_timeout(pageto_v) then
				util.exec("hciconfig " .. dev .. " pageto " .. pageto_v)
			end

			if scantype_v ~= nil then
				util.exec("hciconfig " .. dev .. " " .. scantype_v)
			end
		else
	                util.exec("hciconfig " .. dev .. " down")
		end
		]]--
		if status_v ~= "UP" then
			util.exec("hciconfig " .. dev .. " down")
		end
	else
		if status_v == "UP" then
			util.exec("hciconfig " .. bt_dev .. " up")
		end
	end

	luci.http.redirect(luci.dispatcher.build_url("admin", "network", "bluetooth"))
end

if dev_status:find("UP RUNNING") then
	y = m:section(SimpleSection, translate("Scan Bluetooth Devices Around"))
	p = y:option(Button, "scan", translate("Scan Devices"))
	p.inputtitle = translate("Scan")
	p.inputstyle = "reload"

	local scanfile = "/tmp/.luci-btscan"
	local devices = {}
	local ds = util.exec("cat "..scanfile.." 2>/dev/null && rm -f "..scanfile)
	for i,v in ipairs(util.split(ds)) do
		if not v:match("^Scanning") then
		local a,d = v:match("%s+(%S+)%s+(%S+)")
		devices[i] = {
			['Address']   = a,
			['Device']    = d
		}
		end
	end
	function p.write(self, section, value)
		util.exec("hcitool scan >"..scanfile)
		luci.http.redirect(luci.dispatcher.build_url("admin", "network", "bluetooth"))
	end

	t = m:section(Table, devices, "")
	a = t:option(DummyValue, "Device", translate("Device"))
	b = t:option(DummyValue, "Address", translate("Address"))
end

c = m:section(SimpleSection, translate("hciconfig"))
c.template = "admin_network/bluetooth_dev_info"

return m
