--[[
LuCI - Lua Configuration Interface

Copyright 2008 Steven Barth <steven@midlink.org>

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

	http://www.apache.org/licenses/LICENSE-2.0

$Id$
]]--

local util = require("luci.util")

f = SimpleForm("tweaks", translate("Networking Tweaks"))
f.reset  = false
f.readinput = false

local cfgs = {
  "ip_conntrack_max",
  "ip_conntrack_generic_timeout",
  "ip_conntrack_icmp_timeout",
  "ip_conntrack_tcp_timeout_established",
  "ip_conntrack_udp_timeout",
  "ip_conntrack_udp_timeout_stream"
}

local titles = {
  "Maximum Connections",
  "Generic Timeout",
  "ICMP Timeout",
  "TCP Established Timeout",
  "UDP Timeout",
  "UDP Stream Timeout"
}

local descs = {
	"The maximum number of simultaneous connections your router can track.<br/>"
	.."A larger number means more RAM use and higher CPU utilization if that many connections actually end up used. <br/>" 
	.."It is usually best to leave this at its default value.",
	"",
	"",
	"The number of seconds that a established connection can be idle before it is forcibly closed.<br/>"
	.."Sometimes connections are not properly closed and can fill up your conntrack table if these values are too high.<br/>"
	.."If they are too low, then connections can be disconnected simply because they are idle.",
	"",
	""
}

for i,v in ipairs(cfgs) do
  n = f:field(Value, v, translate(titles[i]), translate(descs[i]))
  n.optional = false
  n.rmempty = false

  function n.cfgvalue(self, section)
    return util.exec("sysctl -n net.ipv4.netfilter."..v)
  end

  function n.write(self, section, value)
  	util.exec("sysctl -q -w net.ipv4.netfilter."..v.."="..value)
  end

 end

return f
