--[[
LuCI - Lua Configuration Interface

Copyright 2009 Jo-Philipp Wich <xm@subsignal.org>

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

	http://www.apache.org/licenses/LICENSE-2.0

$Id$
]]--

local fs   = require "nixio.fs"
local nw   = require "luci.model.network"
local fw   = require "luci.model.firewall"
local uci  = require "luci.model.uci".cursor()
local http = require "luci.http"

nw.init(uci)
local wdev = nw:get_wifidev(http.formvalue("device"))
local wnet = nw:get_wifinet(http.formvalue("device"))
local iw = luci.sys.wifi.getiwinfo(http.formvalue("device"))

if not iw or not wdev or not wnet then
	luci.http.redirect(luci.dispatcher.build_url("admin/network/wireless"))
	return
end

m = SimpleForm("network", translate("Join Network: Settings"))
m.cancel = translate("Back to scan results")
m.reset = false

function m.on_cancel()
	local dev = http.formvalue("device")
	http.redirect(luci.dispatcher.build_url(
		dev and "admin/network/wireless_join?device=" .. dev
			or "admin/network/wireless"
	))
end

m.hidden = {
	device      = http.formvalue("device"),
	join        = http.formvalue("join"),
	channel     = http.formvalue("channel"),
	mode        = http.formvalue("mode"),
	bssid       = http.formvalue("bssid"),
	wep         = http.formvalue("wep"),
	wpa_suites	= http.formvalue("wpa_suites"),
	wpa_version = http.formvalue("wpa_version")
}

if iw and iw.mbssid_support then
	replace = m:field(Flag, "replace", translate("Replace wireless configuration"),
		translate("An additional network will be created if you leave this unchecked."))

	function replace.cfgvalue() return "1" end
else
	replace = m:field(DummyValue, "replace", translate("Replace wireless configuration"))
	replace.default = translate("The hardware is not multi-SSID capable and the existing " ..
		"configuration will be replaced if you proceed.")

	function replace.formvalue() return "1" end
end

wdev:set("disabled", false)
wnet:set("ssid", m.hidden.join)
wnet:set("bssid", m.hidden.bssid)
if mode == "adhoc" or mode == "sta" then
        wnet:set("bssid", m.hidden.bssid)
end

if m.hidden.wep == "1" then
        wnet:set("encryption", "wep-open")
elseif (tonumber(m.hidden.wpa_version) or 0) > 0 then
        wnet:set("encryption", (tonumber(m.hidden.wpa_version) or 0) >= 2 and "psk2" or "psk")
else
        wnet:set("encryption", "none")
end
if mode == "adhoc" or mode == "sta" then
        wnet:set("bssid", m.hidden.bssid)
end
uci:save("wireless")
luci.http.redirect(luci.dispatcher.build_url("admin/network/wireless/" .. m.hidden.device))


return m
