--[[
LuCI - Lua Configuration Interface

Copyright 2008 Steven Barth <steven@midlink.org>
Copyright 2008-2011 Jo-Philipp Wich <xm@subsignal.org>

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

	http://www.apache.org/licenses/LICENSE-2.0

$Id$
]]--

local ipkgfile = "/etc/beecrypt.conf"

f = SimpleForm("smartconf", translate("SmartPM Configuration"))
f.submit = false
f.reset  = false
f.readinput = false

f:append(Template("admin_system/smart"))

local types = {
	['rpm-sys'] = "RPM Installed Packages",
	['rpm-md']  = "RPM MetaData"
}

local inits = {}

os.execute("echo start >> /tmp/smart.log 2>/dev/null");
local index = 0
local cmd = io.popen("env -i smart channel --show -y")
local name = ""
local type = ""
local url = ""
local disabled = false
if cmd then
	while true do
		local l = cmd:read("*l")
		if not l then
			break
		end
		local tmp = l:match("%[([^%]]+)%]")
		if tmp then
			name = tmp
		elseif name and name != "" then
			tmp = l:match("type = (.+)")
			if tmp then
				type = tmp
			else
				tmp = l:match("baseurl = (.+)")
				if tmp then
					url = tmp
				else
					tmp = l:match("disabled = (.+)")
					if tmp and tmp == "yes" then
						disabled = true
					else
						index = index + 1
						inits[index] = {
								index = tostring(index),
								name = name,
								type = types[type],
								url = url,
								disabled = disabled
							}
						type = ""
						url = ""
						name = ""
						disabled = false
					end
				end
			end
		end

		data = true
	end

	cmd:close()
end
inits[99] = { type = types['rpm-md']}

t = f:section(Table, inits)
i = t:option(DummyValue, "index", "")
n = t:option(Value, "name", translate("Name"))
p = t:option(ListValue, "type", translate("Type"))
u = t:option(Value, "url", translate("Base URL"))
e = t:option(Button, "disabled", translate("Enable/Disable"))
a = t:option(Button, "adddelete", "")

n.size = 10

n.render = function(self, section, scope)
	self.default = inits[section].name
	Value.render(self, section, scope)
end
n.cfgvalue = function(self, section)
	return inits[section].name
end
n.write = function(self, section) end

p.render = function(self, section, scope)
	for _, init in ipairs(inits) do
		self:value(init.type, types[init.type])
	end
	ListValue.render(self, section, scope)
end

p.write = function(self, section) end

u.size = 60
u.write = function(self, section) end

e.render = function(self, section, scope)
	if section == 99 or not inits[section].disabled then
		self.title = translate("Enabled")
		self.inputstyle = "save"
	else
		self.title = translate("Disabled")
		self.inputstyle = "reset"
	end

	Button.render(self, section, scope)
end

local function enable(name)
	return (os.execute("smart channel --enable "..name.." >/dev/null 2>&1") == 0)
end

local function disable(name)
	return (os.execute("smart channel --disable "..name.." >/dev/null 2>&1") == 0)
end

e.write = function(self, section)
	if not inits[section].disabled then
		inits[section].disabled = ture
		return disable(inits[section].name)
	else
		inits[section].disabled = false
		return enable(inits[section].name)
	end
end

a.render = function(self, section, scope)
	if section == 99 then
		self.title = translate("Add")
		self.inputstyle = "add"
	else
		self.title = translate("Delete")
		self.inputstyle = "delete"
	end

	Button.render(self, section, scope)
end

a.write = function(self, section) end
-- function f.handle(self, state, data)
-- 	return true
-- end

return f
