local util = require("luci.util")
local sys = require("luci.sys")
local fs   = require "nixio.fs"

local has_tpm = sys.call("ls /dev/tpm* > /dev/null 2>&1")
if has_tpm ~= 0 then
	m = SimpleForm("tpm", translate("TPM"))
	m.reset=false
	m.submit=false
	tpm_abnormal = m:section(SimpleSection, "", "")
	tpm_abnormal.template="admin_system/tpm_abnormal"
	return m
end

local has_user_password="no"

if sys.call("tpm_resetdalock -z 2>&1 | grep \"Authentication failed\" >/dev/null 2>&1") == 0 then
	has_user_password="yes"
end

if sys.call("tpm_resetdalock -z 2>&1 | grep \"dictionary attacks\" >/dev/null 2>&1") == 0 then
	has_user_password="yes"
end

if has_user_password=="yes" then
	m = SimpleForm("tpm", translate("TPM Password"))
	tpm_userpassword=m:field(Value,"tpm passwork", translate("Owner Password"), translate("Passwords have been set, please enter the password:"))
	--tpm_userpassword.template="admin_system/tpm_userpassword"
	return m
else
	m = SimpleForm("tpm", translate("TPM"),translate(""))
	m.reset=false
	m.submit=false
        tpm_normal=m:section(SimpleSection, translate("TPM"))
	tpm_normal.template="admin_system/tpm"
	return m
end

