--[[
LuCI - Lua Configuration Interface

Copyright 2011 Jo-Philipp Wich <xm@subsignal.org>

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

	http://www.apache.org/licenses/LICENSE-2.0

$Id$
]]--

local fs = require "nixio.fs"

local f = SimpleForm("firewall",
	translate("Firewall - Custom Rules"),
	translate("Custom rules allow you to execute arbritary iptables commands \
		which are not otherwise covered by the firewall framework. \
		The commands are executed after each firewall restart, right after \
		the default ruleset has been loaded."))

if fs.access("/tmp/fw_user.log") then
	local c = f:field(DummyValue, translate("fw_user_error"), translate("<strong>Error:</strong>"))
	c.value = fs.readfile("/tmp/fw_user.log")
end

local o = f:field(Value, "_custom")

o.template = "cbi/tvalue"
o.rows = 20

function o.cfgvalue(self, section)
	return fs.readfile("/etc/firewall.user")
end

function f.handle(self, state, data)
	if state == FORM_VALID then
		if fs.access("/tmp/fw_user.log") then
			luci.util.exec("rm -f /tmp/fw_user.log")
		end

		if data._custom then
			if data._custom:sub(-1) != "\n" then
				data._custom = data._custom .. "\n"
			end
			fs.writefile("/etc/firewall.user", data._custom:gsub("\r\n?", "\n"))

			for line in io.lines("/etc/firewall.user") do
				rule = line .. " 2>&1 | tee >> /tmp/fw_user.log"
				luci.util.exec(rule)
			end

			if luci.util.exec("cat /tmp/fw_user.log") == "" then
				luci.util.exec("rm -f /tmp/fw_user.log")
				luci.sys.init.restart("firewall")
			end

			luci.http.redirect(luci.dispatcher.build_url("admin", "network", "firewall", "custom"))
		end
	end
	return true
end

--[[
function o.write(self, section, value)
	value = value:gsub("\r\n?", "\n")
	fs.writefile("/etc/firewall.user", value)
end
--]]

return f
