require("luci.tools.webadmin")
local sys = require("luci.sys")
local fs = require("nixio.fs")

m = Map("multiwan", translate("Multi-WAN"),
	translate("Multi-WAN mini version which allows for the use of multiple uplinks and failover."))

function m:multiwan_add_networks(field)
        uci.cursor():foreach("multiwan", "interface",
                function (section)
			field:value(section[".name"])
                end
        )
end

s = m:section(NamedSection, "config", "multiwan", "")

e = s:option(Flag, "enabled", translate("Enable"))
e.rmempty = false

function e.cfgvalue(self, section)
	local v = "0"
	if sys.init.enabled("multiwan") then
		v = "1"
	end
	return v
end

function e.write(self, section, value)
	if value == "0" then
		sys.init.stop("multiwan")
		sys.init.disable("multiwan")
	else
		sys.init.enable("multiwan")
		sys.init.start("multiwan")
	end
end

pIface = s:option(ListValue, "priority", translate("Priority Interface"))
m:multiwan_add_networks(pIface)
pIface.default="wan"
pIface.rmempty = false
--pIface:depends("enabled", "1")

mstatus = s:option(Value, "", translate("Status"))
mstatus.readonly = true

function mstatus.cfgvalue(self, section)
	if fs.access("/var/run/multiwan.pid") then
		return "Running"
	else
		return "Stopped"
	end
end


s = m:section(TypedSection, "interface", translate("WAN Interfaces"),
	translate("Health Monitor detects and corrects network changes and failed connections."))
s.addremove = true
s.split = true

function s.create(self, name)
	local uci = require("luci.model.uci").cursor()
	local nw = require("luci.model.network").init()
	local nets = nw:get_networks() or {}

	self.invalid_cts = true
	self.invalid_str = "Invalid interface name, see details in Network Interfaces page."
	if nets and name and name != "loopback" then
		for _, net in ipairs(nets) do
			if net and name == net:name() then
				self.invalid_cts = false
				break
			end
		end
	end

	if not self.invalid_cts then
		uci:section("multiwan", "interface", name, {})
		uci:save("multiwan")
		luci.http.redirect(luci.dispatcher.build_url("admin/network/multiwan"))
	end
end


interval = s:option(Value, "health_interval", translate("Health Monitor Interval"))
interval.default = "3"
interval.optional = false
interval.rmempty = false
interval.datatype = "uinteger"

failover_to = s:option(ListValue, "failover_to", translate("Failover Traffic Destination"))
failover_to:value("none", translate("None"))
m:multiwan_add_networks(failover_to)
failover_to.defualt = "wan"
failover_to.optional = false
failover_to.rmempty = false

return m
