--[[
LuCI - Autogenerated Zoneinfo Module

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

	http://www.apache.org/licenses/LICENSE-2.0

]]--

local nixio = require "nixio"
local io = require "io"

local table, ipairs, string, print = table, ipairs, string, print

module "luci.sys.zoneinfo.tzdata"

TZ = {}

local count = 0
if nixio.fs.access("/usr/share/zoneinfo/zone.tab") then
	for l in io.lines("/usr/share/zoneinfo/zone.tab") do
		if not l:find('^#') then
			local d, s, e = l:match('^([^%s]+)%s+([^%s]+)%s+([^%s]+)')
			if nixio.fs.access("/usr/share/zoneinfo/"..e) then
				count = count + 1
				TZ[count] = { e, "/usr/share/zoneinfo/"..e }
			end
		end
	end
end
