#!/usr/bin/env python
# -*- coding: utf-8 -*-

# Copyright (c) 2016, Intel Corporation. All rights reserved.
# This file is licensed under the GPLv2 license.
# For the full content of this license, see the LICENSE.txt
# file at the top level of this source tree.

import cherrypy
import json
import subprocess
from manage_auth import require
from tools import sysinfo_ops


@require()
class OSControls(object):
    exposed = True

    def GET(self, **kwargs):
        data_collect = sysinfo_ops.DataCollect()
        device_info = data_collect.getDataSet()
        return json.dumps(device_info)

    def POST(self):
        response = subprocess.check_output(['sudo', '-u', 'wra', '/usr/bin/dh-rfs'])
        return json.dumps(response)

    def PUT(self):
        response = subprocess.check_output(['sudo', 'shutdown', '-r', 'now'])
        return json.dumps(response)
