# -*- coding: utf-8 -*-

# Copyright (c) 2016, Intel Corporation. All rights reserved.
# This file is licensed under the GPLv2 license.
# For the full content of this license, see the LICENSE.txt
# file at the top level of this source tree.

import urllib2
from platform import platform, release
from copy import copy
import json
import manage_repo
import manage_config
import os
import cherrypy
from manage_auth import require
from tools import logging_helper, sysinfo_ops, rcpl, network_ops, shell_ops, rcpl


class OS_UPDATER(object):
    def __init__(self, m_current_rcpl, m_arch):
        self.__log_helper = logging_helper.logging_helper.Logger()
        self.__error = None
        self.__available_rcpls = dict()
        self.__handler = None
        self.__rcplindex_fname = str("NOT SET")
        self.__current_rcpl = int(m_current_rcpl)
        self.__highest_rcpl = int(m_current_rcpl)
        self.__higher_version = bool(False)
        self.__arch = m_arch
        self.__platform = platform()
        self.__release = release()
        self.__index_file_loc = str("NOT SET")
        self.__with_cli_interface = rcpl.sw_management.smart_cli.REPO_HANDLER()
        self.__disable_repo = {}
        self.__clean_repo = {}
        self.__enable_repo = {}
        self.__repoUrls = []
        self.__result = {'status': 'failure'}
        self.__pro_repo = {}

    def getIndex(self):
        config = manage_config.read_config_file()
        self.__index_file_loc = config.get('BaseRepo', sysinfo_ops.arch)
        index_file = urllib2.urlopen(self.__index_file_loc)
        download_dir = "downloads"
        if not os.path.exists(download_dir):
            os.makedirs(download_dir)
        self.__rcplindex_fname = 'downloads/rcplindex.xml'
        self.__log_helper.logger.debug(' rcplindex')
        with open(self.__rcplindex_fname, 'wb') as index_out:
            index_out.write(index_file.read())

    def processInfo(self):
        try:
            self.__handler = rcpl.file_io.handler.RCPLINDEX_READER(self.__rcplindex_fname, False, False, None)
            self.__handler.load_index()
            self.__available_rcpls = self.__handler.getData()
        except Exception as err:
            self.__error = err
            self.__log_helper.logger.error(str(self.__error))

    def findNext(self):
        for version, data in self.__available_rcpls.iteritems():
            if int(version) > self.__current_rcpl and data["arch"] == self.__arch and version > self.__highest_rcpl:
                self.__higher_version = True
                self.__highest_rcpl = version
        return copy(self.__higher_version), copy(self.__highest_rcpl)

    def getCurrent(self):
        self.__repoUrls = []
        rcpl_file_locs = self.__available_rcpls[str(self.__current_rcpl)]["files"]
        for file_loc in rcpl_file_locs:
            rcpl_file = urllib2.urlopen(file_loc)
            for url in rcpl_file:
                url = url.strip('\r\n')
                self.__repoUrls.append(url)
            self.__log_helper.logger.debug(str(self.__repoUrls))


    def updateCurrent(self, action):
        repo_list = manage_repo.list_repos()
        if action == 'add':
            self.__pro_repo = self.__with_cli_interface.add(self.__repoUrls)
        else:
            self.__pro_repo = self.__with_cli_interface.action(repo_list, action, 'WR')
        return self.__pro_repo

    def osUpdate(self):
        repo_list = manage_repo.list_repos()

        self.__disable_repo = self.__with_cli_interface.action(repo_list, 'disable', 'not_WR')
        if self.__disable_repo['returncode'] == 1:
            self.__enable_repo = self.__with_cli_interface.action(repo_list, 'enable', 'not_WR')
            self.__result['message'] = "Error disabling existing repositories prior to update. Error: " + self.__disable_repo['cmd_output']
            return self.__result

        self.__clean_repo = self.__with_cli_interface.action(repo_list, 'remove', 'WR')
        if self.__clean_repo['returncode']:
            self.__result['message'] = "Error removing old repositories. Error: " + self.__clean_repo['cmd_output']
            return self.__result

        self.__repoUrls = []
        rcpl_file_locs = self.__available_rcpls[str(self.__highest_rcpl)]["files"]
        for file_loc in rcpl_file_locs:
            rcpl_file = urllib2.urlopen(file_loc)
            for url in rcpl_file:
                url = url.strip('\r\n')
                self.__repoUrls.append(url)
            self.__log_helper.logger.debug(str(self.__repoUrls))

        add_output = self.__with_cli_interface.add(self.__repoUrls)
        if add_output['status'] == 'failure':
            repo_list = manage_repo.list_repos()
            self.__enable_repo = self.__with_cli_interface.action(repo_list, 'enable', 'not_WR')
            self.__clean_repo = self.__with_cli_interface.action(repo_list, 'remove', 'WR')
            self.__result['message'] = "Error adding update repositories."
            self.__log_helper.logger.debug(str(self.__result))
            return self.__result

        cmd_output = shell_ops.run_cmd_chk("smart upgrade -y")
        if cmd_output['returncode']:
            repo_list = manage_repo.list_repos()
            self.__result['message'] = "Error during upgrade process. Error: " + cmd_output['cmd_output']
            self.__enable_repo = self.__with_cli_interface.action(repo_list, 'enable', 'not_WR')
            self.__clean_repo = self.__with_cli_interface.action(repo_list, 'remove', 'WR')
            self.__log_helper.logger.debug(str(self.__result))
            return self.__result

        try:
            repo_list = manage_repo.list_repos()
            self.__enable_repo = self.__with_cli_interface.action(repo_list, 'enable', 'not_WR')
            self.__with_cli_interface.action(repo_list, 'remove', 'WR')
            manage_repo.configure_default_repo()
        except Exception as err:
            self.__error = err
            self.__log_helper.logger.error(str(self.__error))
        self.__result['status'] = 'success'
        return self.__result


@require()
class OSUpdate(object):
    exposed = True

    def __init__(self):
        self.__network_checker = network_ops.NetworkCheck()

    def GET(self, **kwargs):
        result = {'update': False}
        net_test = self.__network_checker.test_network_connection()[0]
        if net_test['https_conn'] == 'False':
            return json.dumps(result)
        updater = OS_UPDATER(sysinfo_ops.rcpl_version, sysinfo_ops.arch)
        updater.getIndex()
        updater.processInfo()
        update, update_to_version = updater.findNext()
        result['update'] = update
        return json.dumps(result)

    def POST(self):
        # Increased timeout value (12 hours) quark
        cherrypy.response.timeout = 43200
        net_test = self.__network_checker.test_network_connection()[0]
        if net_test['https_conn'] == 'False':
            return json.dumps(net_test)
        updater = OS_UPDATER(sysinfo_ops.rcpl_version, sysinfo_ops.arch)
        updater.getIndex()
        updater.processInfo()
        updater.findNext()
        result = updater.osUpdate()
        return json.dumps(result)

