# Copyright (c) 2016, Intel Corporation. All rights reserved.
# This file is licensed under the GPLv2 license.
# For the full content of this license, see the LICENSE.txt
# file at the top level of this source tree.

from manage_auth import require
from server import shutdown_http_server
import subprocess
import json
import cherrypy
from tools import logging_helper
import manage_config


class SECURITY_AUTOMATION(object):
    def __init__(self):
        self.__log_helper = logging_helper.logging_helper.Logger()

    def CreateHardenImage(self, usb_device, admin_passwd, mec_passwd):
        returncode = 0
        error = ""
        try:
                # Special double quote & escape handling for single quote in the password
                admin_passwd = admin_passwd.replace("'","\'\"'\"\'")
                mec_passwd = mec_passwd.replace("'","\'\"'\"\'")
                # Single quote to preserve special charaters
                result = subprocess.check_output("deploytool -C -F -y -v 0 -Y -d "+ usb_device + " --lockdown" + " -p 'root:" + admin_passwd + "' -p 'gwuser:" + admin_passwd + "' -p 'wra:" + admin_passwd + "' --mec-passwd='" + mec_passwd +"'", shell=True) 
                self.__log_helper.logger.info(str(result))
        except subprocess.CalledProcessError as scriptreturncode:
                # ERR_FAIL=1                       Normal failure
                # ERR_IS_RUNNING=2                  Another deploytool process is running.
                # ERR_NOT_ROOT=3                    Need to run as root but it is not.'
                # ERR_NO_ENOUGH_SIZE=4            # No enough space left to save image file.
                # ERR_DEVICE_TOO_SMALL=5          # Device or image file size is too small.
                # ERR_COMMAND_CHECK=6             # Required command is not found.
                # ERR_PART_TYPES=7                # Not supported partition layout or format.
                # ERR_PART_READY=8                # Partition node is not ready in the system.
                # ERR_INVALID_FILE=9              # File does not exist or is invalid.
                # ERR_BLOCK_DEVICE=10             # Device is not a block device.
                # ERR_NO_GRUBFILE=11              # Cannot find the grub.conf file.
                # ERR_UPDATE_GRUB=12              # Fail to modify the grub.conf file.
                # ERR_NO_CAPFILE=13               # Fail to find the cap file for capsule update.
                # ERR_EXTRACT_TARBALL=14          # Fail to extract the rootfs tarball.
                # ERR_COPY_FILE=15                # Fail to copy file.
                # ERR_CREATE_PART=16              # Fail to create partition in the device.
                # ERR_FORMAT_FS=17                # Fail to format the file system.
                # ERR_PARAMETER=32                # Invalid or conflicting command line parameter.
                # ERR_SYSCALL=128                 # Error when call system functions.
  
                self.__log_helper.logger.error('return code = ' + str(scriptreturncode.returncode) + 'value = ' + str(scriptreturncode.output))
                returncode = scriptreturncode.returncode 
                if returncode == 2:
                    error = "Can't start two instance of SAVE IMAGE. (Error code " + str(scriptreturncode.returncode) + ")"
                elif returncode == 5 or returncode == 4:    
                    error = "USB flash drive does not have sufficient space. Insert a different drive and try again. (Error code " + str(scriptreturncode.returncode) + ")"
                elif returncode == 6:  
                    error = "Critical system commands are missing which prevents saving an OS image. Restore development gateway to a factory OS and try again. (Error code " + str(scriptreturncode.returncode) + ")"
                elif returncode == 7: 
                    error = "Unable to use this USB flash drive. Insert a different drive and try again.  (Error code " + str(scriptreturncode.returncode) + ")"
                elif returncode == 16:
                    error = "Unable to use this USB flash drive. Insert a different drive and try again.  (Error code " + str(scriptreturncode.returncode) + ") (Failed to create partition on device)"
                elif returncode == 17:
                    error = "Unable to use this USB flash drive. Insert a different drive and try again.  (Error code " + str(scriptreturncode.returncode) + ") (Failed to format the file system)"
                elif returncode == 9 or returncode == 11 or returncode == 12 or returncode == 13:
                    error = "Critical system files are missing which prevents saving an OS image. Restore development gateway to a factory OS and try again  (Error code " + str(scriptreturncode.returncode) + ")"
                else:
                    error = "Unexpected error occurred. Try again. (Error code " + str(scriptreturncode.returncode) + ")"
               
        if returncode == 0:
                response = ({
                    'status': "success"
                })
 
        else:
                response = ({
                    'status': "failure",
                    'error': error
                 })                      
        return json.dumps(response)                

    def Summary(self):
        # TODO - Specifiy exact user names instead of administrative function. There is discussion happening on root,wra and gwuser
        response = ({
                        'status': 'success',
                        'summary': 'Enter passwords for administrative functions and McAfee Embedded Control (MEC) whitelisting.  These will be configured into your deployed gateways.  \
                                   We recommend separate passwords be used.  Good passwords should contain: at least 8 characters, upper case, lower case, numerals and special characters'

                             })             
        return json.dumps(response)  


@require() 
class SecurtiyAutomation(object):
    exposed = True

    def PUT(self, **kwargs):
        manage_config.configure_nginx_https(kwargs['enable'])
        manage_config.add_secure_http_to_config_file(kwargs['enable'])
        shutdown_http_server()
        response = ({
            'status': "success"
        })
        return json.dumps(response)

    def GET(self, **kwargs):
        sa = SECURITY_AUTOMATION()        
        if kwargs['request'] == "summary":
            return sa.Summary()
   
    def POST(self, **kwargs):
        # Increased timeout value (12 hours) quark
        cherrypy.response.timeout = 43200
        sa = SECURITY_AUTOMATION()
        return sa.CreateHardenImage(kwargs['usb_device'], kwargs['admin_password'], kwargs['mec_password'])
