# Copyright (c) 2016, Intel Corporation. All rights reserved.
# This file is licensed under the GPLv2 license.
# For the full content of this license, see the LICENSE.txt
# file at the top level of this source tree.

from manage_auth import require
from tools import shell_ops
import json


class DEVHUB_UPDATE(object):

    def __init__(self):
        self.__response = {'status': None}
        self.__script = '/tmp/update-iot-dev-hub.sh'
        self.__process = '#!/bin/bash\nsystemctl stop iot-dev-hub\nsmart upgrade -y iot-developer-hub\nsystemctl restart iot-dev-hub\nsystemctl start iot-dev-hub\n exit 0\n'
    def update(self):
        dh_upgrade = open(self.__script, 'w+')
        dh_upgrade.write(self.__process)
        dh_upgrade.close()
        try:
            shell_ops.run_command('chmod 700 /tmp/update-iot-dev-hub.sh')
            shell_ops.run_command('systemctl --no-block start iot-dev-hub-update')
            self.__response['status'] = "success"
        except:
            self.__response['status'] = "failure"
        return self.__response


@require()
class SelfUpgrade(object):
    exposed = True

    def PUT(self):
        devhub = DEVHUB_UPDATE()
        return json.dumps(devhub.update())
