#!/usr/bin/env python

# Copyright (c) 2016, Intel Corporation. All rights reserved.
# This file is licensed under the GPLv2 license.
# For the full content of this license, see the LICENSE.txt
# file at the top level of this source tree.

import cherrypy
import os
from manage_auth import require
import subprocess 
import json
from tools import logging_helper

#@require() 
class Service_control(object):
    exposed = True

    def __init__(self):
        self.__log_helper = logging_helper.logging_helper.Logger()

    def GET(self, **kwargs):
        # The syntax is [ip]/api/sc?service=node-red-experience.service

        # Turn kwargs into (k,v) keypairs
        services = []

        # Note: we only support query for 1 service at a time.
        # for k in kwargs:
        #    self.__log_helper.logger.error(str(k))
        #    v = kwargs[k]
        #    self.__log_helper.logger.error(str(v))
        #    services += [(k, v)]

        if 'service' in kwargs:
            services += [('service', kwargs['service'])]

        # run systemctl on each service
        report = {}
        option = ['list-units','list-unit-files','--no-legend']
        for k,v in services:
            if k.find('service') != -1:
                report[v] = {'LOAD':'na','ACTIVE':'na','State':'disabled',
                             'SUB':'Not Running'}                        
                try:             
                    r = subprocess.check_output(['systemctl',option[0],option[2],v])
                    self.__log_helper.logger.debug(str(r))
                    if v in r:
                        r = r.split()
                        if r[3] == 'dead' or r[3] == 'exited' or r[3] == 'abandoned':
                            service_state = 'Not Running'
                        else:
                            # Othere process states are waiting, running, listening, mounted, active, plugged 
                            service_state = 'Running'
                        report[v] = {'LOAD':'loaded','ACTIVE':r[2],'SUB':service_state}
                except subprocess.CalledProcessError as scriptreturncode:
                    self.__log_helper.logger.error('return code = ' + str(scriptreturncode.returncode) + ' value = ' + str(scriptreturncode.output))
                   
              
                try:                 
                    r = subprocess.check_output(['systemctl',option[1],option[2],v])
                    self.__log_helper.logger.debug(str(r))
                    if v in r:
                        r = r.split()
                        # service state static means you can't disable service
                        if r[1] == 'enabled' or r[1] == 'static':
                            serice_auto_run = 'enabled'
                        else:
                            # othere service state are disabled and mask. mask state means you can't start service
                            serice_auto_run = 'disabled'  
                        report[v]['State'] = serice_auto_run
                except subprocess.CalledProcessError as scriptreturncode:
                    self.__log_helper.logger.error('return code = ' + str(scriptreturncode.returncode) + ' value = ' + str(scriptreturncode.output))

        return json.dumps(report)

    def POST(self, **kwargs):

        #Turn kwargs into (k,v) keypairs
        services = {}
        for k in kwargs:
            v = kwargs[k]
            services[k] = v

        response = {'status': "fail"}

        #only one pair of service/action is processed
        try:
            v = services['services']
            a = services['action']
            r = subprocess.call(['systemctl',a,v])
            if r == 0:
                response['status'] = "success"
        except:
            pass
        
        return json.dumps(response)
        

