# This file was automatically generated by SWIG (http://www.swig.org).
# Version 3.0.6
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.




"""
Python interface to libmraa
"""


from sys import version_info
if version_info >= (2, 6, 0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('_mraa', [dirname(__file__)])
        except ImportError:
            import _mraa
            return _mraa
        if fp is not None:
            try:
                _mod = imp.load_module('_mraa', fp, pathname, description)
            finally:
                fp.close()
            return _mod
    _mraa = swig_import_helper()
    del swig_import_helper
else:
    import _mraa
del version_info
try:
    _swig_property = property
except NameError:
    pass  # Python < 2.2 doesn't have 'property'.


def _swig_setattr_nondynamic(self, class_type, name, value, static=1):
    if (name == "thisown"):
        return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name, None)
    if method:
        return method(self, value)
    if (not static):
        if _newclass:
            object.__setattr__(self, name, value)
        else:
            self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)


def _swig_setattr(self, class_type, name, value):
    return _swig_setattr_nondynamic(self, class_type, name, value, 0)


def _swig_getattr_nondynamic(self, class_type, name, static=1):
    if (name == "thisown"):
        return self.this.own()
    method = class_type.__swig_getmethods__.get(name, None)
    if method:
        return method(self)
    if (not static):
        return object.__getattr__(self, name)
    else:
        raise AttributeError(name)

def _swig_getattr(self, class_type, name):
    return _swig_getattr_nondynamic(self, class_type, name, 0)


def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)

try:
    _object = object
    _newclass = 1
except AttributeError:
    class _object:
        pass
    _newclass = 0


class uint8Array(_object):
    """Proxy of C++ uint8Array class"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, uint8Array, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, uint8Array, name)
    __repr__ = _swig_repr

    def __init__(self, nelements):
        """
        __init__(uint8Array self, size_t nelements) -> uint8Array

        Parameters:
            nelements: size_t

        """
        this = _mraa.new_uint8Array(nelements)
        try:
            self.this.append(this)
        except:
            self.this = this
    __swig_destroy__ = _mraa.delete_uint8Array
    __del__ = lambda self: None

    def __getitem__(self, index):
        """
        __getitem__(uint8Array self, size_t index) -> uint8_t

        Parameters:
            index: size_t

        """
        return _mraa.uint8Array___getitem__(self, index)


    def __setitem__(self, index, value):
        """
        __setitem__(uint8Array self, size_t index, uint8_t value)

        Parameters:
            index: size_t
            value: uint8_t

        """
        return _mraa.uint8Array___setitem__(self, index, value)


    def cast(self):
        """
        cast(uint8Array self) -> uint8_t *

        Parameters:
            self: uint8Array *

        """
        return _mraa.uint8Array_cast(self)


    def frompointer(t):
        """
        frompointer(uint8_t * t) -> uint8Array

        Parameters:
            t: uint8_t *

        """
        return _mraa.uint8Array_frompointer(t)

    if _newclass:
        frompointer = staticmethod(frompointer)
    __swig_getmethods__["frompointer"] = lambda x: frompointer
uint8Array_swigregister = _mraa.uint8Array_swigregister
uint8Array_swigregister(uint8Array)

def uint8Array_frompointer(t):
    """
    uint8Array_frompointer(uint8_t * t) -> uint8Array

    Parameters:
        t: uint8_t *

    """
    return _mraa.uint8Array_frompointer(t)


_mraa.INTEL_GALILEO_GEN1_swigconstant(_mraa)
INTEL_GALILEO_GEN1 = _mraa.INTEL_GALILEO_GEN1

_mraa.INTEL_GALILEO_GEN2_swigconstant(_mraa)
INTEL_GALILEO_GEN2 = _mraa.INTEL_GALILEO_GEN2

_mraa.INTEL_EDISON_FAB_C_swigconstant(_mraa)
INTEL_EDISON_FAB_C = _mraa.INTEL_EDISON_FAB_C

_mraa.INTEL_DE3815_swigconstant(_mraa)
INTEL_DE3815 = _mraa.INTEL_DE3815

_mraa.INTEL_MINNOWBOARD_MAX_swigconstant(_mraa)
INTEL_MINNOWBOARD_MAX = _mraa.INTEL_MINNOWBOARD_MAX

_mraa.RASPBERRY_PI_swigconstant(_mraa)
RASPBERRY_PI = _mraa.RASPBERRY_PI

_mraa.BEAGLEBONE_swigconstant(_mraa)
BEAGLEBONE = _mraa.BEAGLEBONE

_mraa.BANANA_swigconstant(_mraa)
BANANA = _mraa.BANANA

_mraa.INTEL_NUC5_swigconstant(_mraa)
INTEL_NUC5 = _mraa.INTEL_NUC5

_mraa.A96BOARDS_swigconstant(_mraa)
A96BOARDS = _mraa.A96BOARDS

_mraa.INTEL_SOFIA_3GR_swigconstant(_mraa)
INTEL_SOFIA_3GR = _mraa.INTEL_SOFIA_3GR

_mraa.INTEL_CHERRYHILLS_swigconstant(_mraa)
INTEL_CHERRYHILLS = _mraa.INTEL_CHERRYHILLS

_mraa.INTEL_UP_swigconstant(_mraa)
INTEL_UP = _mraa.INTEL_UP

_mraa.INTEL_GT_TUCHUCK_swigconstant(_mraa)
INTEL_GT_TUCHUCK = _mraa.INTEL_GT_TUCHUCK

_mraa.FTDI_FT4222_swigconstant(_mraa)
FTDI_FT4222 = _mraa.FTDI_FT4222

_mraa.GENERIC_FIRMATA_swigconstant(_mraa)
GENERIC_FIRMATA = _mraa.GENERIC_FIRMATA

_mraa.NULL_PLATFORM_swigconstant(_mraa)
NULL_PLATFORM = _mraa.NULL_PLATFORM

_mraa.UNKNOWN_PLATFORM_swigconstant(_mraa)
UNKNOWN_PLATFORM = _mraa.UNKNOWN_PLATFORM

_mraa.INTEL_EDISON_MINIBOARD_J17_1_swigconstant(_mraa)
INTEL_EDISON_MINIBOARD_J17_1 = _mraa.INTEL_EDISON_MINIBOARD_J17_1

_mraa.INTEL_EDISON_MINIBOARD_J17_5_swigconstant(_mraa)
INTEL_EDISON_MINIBOARD_J17_5 = _mraa.INTEL_EDISON_MINIBOARD_J17_5

_mraa.INTEL_EDISON_MINIBOARD_J17_7_swigconstant(_mraa)
INTEL_EDISON_MINIBOARD_J17_7 = _mraa.INTEL_EDISON_MINIBOARD_J17_7

_mraa.INTEL_EDISON_MINIBOARD_J17_8_swigconstant(_mraa)
INTEL_EDISON_MINIBOARD_J17_8 = _mraa.INTEL_EDISON_MINIBOARD_J17_8

_mraa.INTEL_EDISON_MINIBOARD_J17_9_swigconstant(_mraa)
INTEL_EDISON_MINIBOARD_J17_9 = _mraa.INTEL_EDISON_MINIBOARD_J17_9

_mraa.INTEL_EDISON_MINIBOARD_J17_10_swigconstant(_mraa)
INTEL_EDISON_MINIBOARD_J17_10 = _mraa.INTEL_EDISON_MINIBOARD_J17_10

_mraa.INTEL_EDISON_MINIBOARD_J17_11_swigconstant(_mraa)
INTEL_EDISON_MINIBOARD_J17_11 = _mraa.INTEL_EDISON_MINIBOARD_J17_11

_mraa.INTEL_EDISON_MINIBOARD_J17_12_swigconstant(_mraa)
INTEL_EDISON_MINIBOARD_J17_12 = _mraa.INTEL_EDISON_MINIBOARD_J17_12

_mraa.INTEL_EDISON_MINIBOARD_J17_14_swigconstant(_mraa)
INTEL_EDISON_MINIBOARD_J17_14 = _mraa.INTEL_EDISON_MINIBOARD_J17_14

_mraa.INTEL_EDISON_MINIBOARD_J18_1_swigconstant(_mraa)
INTEL_EDISON_MINIBOARD_J18_1 = _mraa.INTEL_EDISON_MINIBOARD_J18_1

_mraa.INTEL_EDISON_MINIBOARD_J18_2_swigconstant(_mraa)
INTEL_EDISON_MINIBOARD_J18_2 = _mraa.INTEL_EDISON_MINIBOARD_J18_2

_mraa.INTEL_EDISON_MINIBOARD_J18_6_swigconstant(_mraa)
INTEL_EDISON_MINIBOARD_J18_6 = _mraa.INTEL_EDISON_MINIBOARD_J18_6

_mraa.INTEL_EDISON_MINIBOARD_J18_7_swigconstant(_mraa)
INTEL_EDISON_MINIBOARD_J18_7 = _mraa.INTEL_EDISON_MINIBOARD_J18_7

_mraa.INTEL_EDISON_MINIBOARD_J18_8_swigconstant(_mraa)
INTEL_EDISON_MINIBOARD_J18_8 = _mraa.INTEL_EDISON_MINIBOARD_J18_8

_mraa.INTEL_EDISON_MINIBOARD_J18_10_swigconstant(_mraa)
INTEL_EDISON_MINIBOARD_J18_10 = _mraa.INTEL_EDISON_MINIBOARD_J18_10

_mraa.INTEL_EDISON_MINIBOARD_J18_11_swigconstant(_mraa)
INTEL_EDISON_MINIBOARD_J18_11 = _mraa.INTEL_EDISON_MINIBOARD_J18_11

_mraa.INTEL_EDISON_MINIBOARD_J18_12_swigconstant(_mraa)
INTEL_EDISON_MINIBOARD_J18_12 = _mraa.INTEL_EDISON_MINIBOARD_J18_12

_mraa.INTEL_EDISON_MINIBOARD_J18_13_swigconstant(_mraa)
INTEL_EDISON_MINIBOARD_J18_13 = _mraa.INTEL_EDISON_MINIBOARD_J18_13

_mraa.INTEL_EDISON_MINIBOARD_J19_4_swigconstant(_mraa)
INTEL_EDISON_MINIBOARD_J19_4 = _mraa.INTEL_EDISON_MINIBOARD_J19_4

_mraa.INTEL_EDISON_MINIBOARD_J19_5_swigconstant(_mraa)
INTEL_EDISON_MINIBOARD_J19_5 = _mraa.INTEL_EDISON_MINIBOARD_J19_5

_mraa.INTEL_EDISON_MINIBOARD_J19_6_swigconstant(_mraa)
INTEL_EDISON_MINIBOARD_J19_6 = _mraa.INTEL_EDISON_MINIBOARD_J19_6

_mraa.INTEL_EDISON_MINIBOARD_J19_8_swigconstant(_mraa)
INTEL_EDISON_MINIBOARD_J19_8 = _mraa.INTEL_EDISON_MINIBOARD_J19_8

_mraa.INTEL_EDISON_MINIBOARD_J19_9_swigconstant(_mraa)
INTEL_EDISON_MINIBOARD_J19_9 = _mraa.INTEL_EDISON_MINIBOARD_J19_9

_mraa.INTEL_EDISON_MINIBOARD_J19_10_swigconstant(_mraa)
INTEL_EDISON_MINIBOARD_J19_10 = _mraa.INTEL_EDISON_MINIBOARD_J19_10

_mraa.INTEL_EDISON_MINIBOARD_J19_11_swigconstant(_mraa)
INTEL_EDISON_MINIBOARD_J19_11 = _mraa.INTEL_EDISON_MINIBOARD_J19_11

_mraa.INTEL_EDISON_MINIBOARD_J19_12_swigconstant(_mraa)
INTEL_EDISON_MINIBOARD_J19_12 = _mraa.INTEL_EDISON_MINIBOARD_J19_12

_mraa.INTEL_EDISON_MINIBOARD_J19_13_swigconstant(_mraa)
INTEL_EDISON_MINIBOARD_J19_13 = _mraa.INTEL_EDISON_MINIBOARD_J19_13

_mraa.INTEL_EDISON_MINIBOARD_J19_14_swigconstant(_mraa)
INTEL_EDISON_MINIBOARD_J19_14 = _mraa.INTEL_EDISON_MINIBOARD_J19_14

_mraa.INTEL_EDISON_MINIBOARD_J20_3_swigconstant(_mraa)
INTEL_EDISON_MINIBOARD_J20_3 = _mraa.INTEL_EDISON_MINIBOARD_J20_3

_mraa.INTEL_EDISON_MINIBOARD_J20_4_swigconstant(_mraa)
INTEL_EDISON_MINIBOARD_J20_4 = _mraa.INTEL_EDISON_MINIBOARD_J20_4

_mraa.INTEL_EDISON_MINIBOARD_J20_5_swigconstant(_mraa)
INTEL_EDISON_MINIBOARD_J20_5 = _mraa.INTEL_EDISON_MINIBOARD_J20_5

_mraa.INTEL_EDISON_MINIBOARD_J20_6_swigconstant(_mraa)
INTEL_EDISON_MINIBOARD_J20_6 = _mraa.INTEL_EDISON_MINIBOARD_J20_6

_mraa.INTEL_EDISON_MINIBOARD_J20_7_swigconstant(_mraa)
INTEL_EDISON_MINIBOARD_J20_7 = _mraa.INTEL_EDISON_MINIBOARD_J20_7

_mraa.INTEL_EDISON_MINIBOARD_J20_8_swigconstant(_mraa)
INTEL_EDISON_MINIBOARD_J20_8 = _mraa.INTEL_EDISON_MINIBOARD_J20_8

_mraa.INTEL_EDISON_MINIBOARD_J20_9_swigconstant(_mraa)
INTEL_EDISON_MINIBOARD_J20_9 = _mraa.INTEL_EDISON_MINIBOARD_J20_9

_mraa.INTEL_EDISON_MINIBOARD_J20_10_swigconstant(_mraa)
INTEL_EDISON_MINIBOARD_J20_10 = _mraa.INTEL_EDISON_MINIBOARD_J20_10

_mraa.INTEL_EDISON_MINIBOARD_J20_11_swigconstant(_mraa)
INTEL_EDISON_MINIBOARD_J20_11 = _mraa.INTEL_EDISON_MINIBOARD_J20_11

_mraa.INTEL_EDISON_MINIBOARD_J20_12_swigconstant(_mraa)
INTEL_EDISON_MINIBOARD_J20_12 = _mraa.INTEL_EDISON_MINIBOARD_J20_12

_mraa.INTEL_EDISON_MINIBOARD_J20_13_swigconstant(_mraa)
INTEL_EDISON_MINIBOARD_J20_13 = _mraa.INTEL_EDISON_MINIBOARD_J20_13

_mraa.INTEL_EDISON_MINIBOARD_J20_14_swigconstant(_mraa)
INTEL_EDISON_MINIBOARD_J20_14 = _mraa.INTEL_EDISON_MINIBOARD_J20_14

_mraa.INTEL_EDISON_GP182_swigconstant(_mraa)
INTEL_EDISON_GP182 = _mraa.INTEL_EDISON_GP182

_mraa.INTEL_EDISON_GP135_swigconstant(_mraa)
INTEL_EDISON_GP135 = _mraa.INTEL_EDISON_GP135

_mraa.INTEL_EDISON_GP27_swigconstant(_mraa)
INTEL_EDISON_GP27 = _mraa.INTEL_EDISON_GP27

_mraa.INTEL_EDISON_GP20_swigconstant(_mraa)
INTEL_EDISON_GP20 = _mraa.INTEL_EDISON_GP20

_mraa.INTEL_EDISON_GP28_swigconstant(_mraa)
INTEL_EDISON_GP28 = _mraa.INTEL_EDISON_GP28

_mraa.INTEL_EDISON_GP111_swigconstant(_mraa)
INTEL_EDISON_GP111 = _mraa.INTEL_EDISON_GP111

_mraa.INTEL_EDISON_GP109_swigconstant(_mraa)
INTEL_EDISON_GP109 = _mraa.INTEL_EDISON_GP109

_mraa.INTEL_EDISON_GP115_swigconstant(_mraa)
INTEL_EDISON_GP115 = _mraa.INTEL_EDISON_GP115

_mraa.INTEL_EDISON_GP128_swigconstant(_mraa)
INTEL_EDISON_GP128 = _mraa.INTEL_EDISON_GP128

_mraa.INTEL_EDISON_GP13_swigconstant(_mraa)
INTEL_EDISON_GP13 = _mraa.INTEL_EDISON_GP13

_mraa.INTEL_EDISON_GP165_swigconstant(_mraa)
INTEL_EDISON_GP165 = _mraa.INTEL_EDISON_GP165

_mraa.INTEL_EDISON_GP19_swigconstant(_mraa)
INTEL_EDISON_GP19 = _mraa.INTEL_EDISON_GP19

_mraa.INTEL_EDISON_GP12_swigconstant(_mraa)
INTEL_EDISON_GP12 = _mraa.INTEL_EDISON_GP12

_mraa.INTEL_EDISON_GP183_swigconstant(_mraa)
INTEL_EDISON_GP183 = _mraa.INTEL_EDISON_GP183

_mraa.INTEL_EDISON_GP110_swigconstant(_mraa)
INTEL_EDISON_GP110 = _mraa.INTEL_EDISON_GP110

_mraa.INTEL_EDISON_GP114_swigconstant(_mraa)
INTEL_EDISON_GP114 = _mraa.INTEL_EDISON_GP114

_mraa.INTEL_EDISON_GP129_swigconstant(_mraa)
INTEL_EDISON_GP129 = _mraa.INTEL_EDISON_GP129

_mraa.INTEL_EDISON_GP130_swigconstant(_mraa)
INTEL_EDISON_GP130 = _mraa.INTEL_EDISON_GP130

_mraa.INTEL_EDISON_GP44_swigconstant(_mraa)
INTEL_EDISON_GP44 = _mraa.INTEL_EDISON_GP44

_mraa.INTEL_EDISON_GP46_swigconstant(_mraa)
INTEL_EDISON_GP46 = _mraa.INTEL_EDISON_GP46

_mraa.INTEL_EDISON_GP48_swigconstant(_mraa)
INTEL_EDISON_GP48 = _mraa.INTEL_EDISON_GP48

_mraa.INTEL_EDISON_GP131_swigconstant(_mraa)
INTEL_EDISON_GP131 = _mraa.INTEL_EDISON_GP131

_mraa.INTEL_EDISON_GP14_swigconstant(_mraa)
INTEL_EDISON_GP14 = _mraa.INTEL_EDISON_GP14

_mraa.INTEL_EDISON_GP40_swigconstant(_mraa)
INTEL_EDISON_GP40 = _mraa.INTEL_EDISON_GP40

_mraa.INTEL_EDISON_GP43_swigconstant(_mraa)
INTEL_EDISON_GP43 = _mraa.INTEL_EDISON_GP43

_mraa.INTEL_EDISON_GP77_swigconstant(_mraa)
INTEL_EDISON_GP77 = _mraa.INTEL_EDISON_GP77

_mraa.INTEL_EDISON_GP82_swigconstant(_mraa)
INTEL_EDISON_GP82 = _mraa.INTEL_EDISON_GP82

_mraa.INTEL_EDISON_GP83_swigconstant(_mraa)
INTEL_EDISON_GP83 = _mraa.INTEL_EDISON_GP83

_mraa.INTEL_EDISON_GP134_swigconstant(_mraa)
INTEL_EDISON_GP134 = _mraa.INTEL_EDISON_GP134

_mraa.INTEL_EDISON_GP45_swigconstant(_mraa)
INTEL_EDISON_GP45 = _mraa.INTEL_EDISON_GP45

_mraa.INTEL_EDISON_GP47_swigconstant(_mraa)
INTEL_EDISON_GP47 = _mraa.INTEL_EDISON_GP47

_mraa.INTEL_EDISON_GP49_swigconstant(_mraa)
INTEL_EDISON_GP49 = _mraa.INTEL_EDISON_GP49

_mraa.INTEL_EDISON_GP15_swigconstant(_mraa)
INTEL_EDISON_GP15 = _mraa.INTEL_EDISON_GP15

_mraa.INTEL_EDISON_GP84_swigconstant(_mraa)
INTEL_EDISON_GP84 = _mraa.INTEL_EDISON_GP84

_mraa.INTEL_EDISON_GP42_swigconstant(_mraa)
INTEL_EDISON_GP42 = _mraa.INTEL_EDISON_GP42

_mraa.INTEL_EDISON_GP41_swigconstant(_mraa)
INTEL_EDISON_GP41 = _mraa.INTEL_EDISON_GP41

_mraa.INTEL_EDISON_GP78_swigconstant(_mraa)
INTEL_EDISON_GP78 = _mraa.INTEL_EDISON_GP78

_mraa.INTEL_EDISON_GP79_swigconstant(_mraa)
INTEL_EDISON_GP79 = _mraa.INTEL_EDISON_GP79

_mraa.INTEL_EDISON_GP80_swigconstant(_mraa)
INTEL_EDISON_GP80 = _mraa.INTEL_EDISON_GP80

_mraa.INTEL_EDISON_GP81_swigconstant(_mraa)
INTEL_EDISON_GP81 = _mraa.INTEL_EDISON_GP81

_mraa.RASPBERRY_WIRING_PIN8_swigconstant(_mraa)
RASPBERRY_WIRING_PIN8 = _mraa.RASPBERRY_WIRING_PIN8

_mraa.RASPBERRY_WIRING_PIN9_swigconstant(_mraa)
RASPBERRY_WIRING_PIN9 = _mraa.RASPBERRY_WIRING_PIN9

_mraa.RASPBERRY_WIRING_PIN7_swigconstant(_mraa)
RASPBERRY_WIRING_PIN7 = _mraa.RASPBERRY_WIRING_PIN7

_mraa.RASPBERRY_WIRING_PIN15_swigconstant(_mraa)
RASPBERRY_WIRING_PIN15 = _mraa.RASPBERRY_WIRING_PIN15

_mraa.RASPBERRY_WIRING_PIN16_swigconstant(_mraa)
RASPBERRY_WIRING_PIN16 = _mraa.RASPBERRY_WIRING_PIN16

_mraa.RASPBERRY_WIRING_PIN0_swigconstant(_mraa)
RASPBERRY_WIRING_PIN0 = _mraa.RASPBERRY_WIRING_PIN0

_mraa.RASPBERRY_WIRING_PIN1_swigconstant(_mraa)
RASPBERRY_WIRING_PIN1 = _mraa.RASPBERRY_WIRING_PIN1

_mraa.RASPBERRY_WIRING_PIN2_swigconstant(_mraa)
RASPBERRY_WIRING_PIN2 = _mraa.RASPBERRY_WIRING_PIN2

_mraa.RASPBERRY_WIRING_PIN3_swigconstant(_mraa)
RASPBERRY_WIRING_PIN3 = _mraa.RASPBERRY_WIRING_PIN3

_mraa.RASPBERRY_WIRING_PIN4_swigconstant(_mraa)
RASPBERRY_WIRING_PIN4 = _mraa.RASPBERRY_WIRING_PIN4

_mraa.RASPBERRY_WIRING_PIN5_swigconstant(_mraa)
RASPBERRY_WIRING_PIN5 = _mraa.RASPBERRY_WIRING_PIN5

_mraa.RASPBERRY_WIRING_PIN12_swigconstant(_mraa)
RASPBERRY_WIRING_PIN12 = _mraa.RASPBERRY_WIRING_PIN12

_mraa.RASPBERRY_WIRING_PIN13_swigconstant(_mraa)
RASPBERRY_WIRING_PIN13 = _mraa.RASPBERRY_WIRING_PIN13

_mraa.RASPBERRY_WIRING_PIN6_swigconstant(_mraa)
RASPBERRY_WIRING_PIN6 = _mraa.RASPBERRY_WIRING_PIN6

_mraa.RASPBERRY_WIRING_PIN14_swigconstant(_mraa)
RASPBERRY_WIRING_PIN14 = _mraa.RASPBERRY_WIRING_PIN14

_mraa.RASPBERRY_WIRING_PIN10_swigconstant(_mraa)
RASPBERRY_WIRING_PIN10 = _mraa.RASPBERRY_WIRING_PIN10

_mraa.RASPBERRY_WIRING_PIN11_swigconstant(_mraa)
RASPBERRY_WIRING_PIN11 = _mraa.RASPBERRY_WIRING_PIN11

_mraa.RASPBERRY_WIRING_PIN17_swigconstant(_mraa)
RASPBERRY_WIRING_PIN17 = _mraa.RASPBERRY_WIRING_PIN17

_mraa.RASPBERRY_WIRING_PIN21_swigconstant(_mraa)
RASPBERRY_WIRING_PIN21 = _mraa.RASPBERRY_WIRING_PIN21

_mraa.RASPBERRY_WIRING_PIN18_swigconstant(_mraa)
RASPBERRY_WIRING_PIN18 = _mraa.RASPBERRY_WIRING_PIN18

_mraa.RASPBERRY_WIRING_PIN19_swigconstant(_mraa)
RASPBERRY_WIRING_PIN19 = _mraa.RASPBERRY_WIRING_PIN19

_mraa.RASPBERRY_WIRING_PIN22_swigconstant(_mraa)
RASPBERRY_WIRING_PIN22 = _mraa.RASPBERRY_WIRING_PIN22

_mraa.RASPBERRY_WIRING_PIN20_swigconstant(_mraa)
RASPBERRY_WIRING_PIN20 = _mraa.RASPBERRY_WIRING_PIN20

_mraa.RASPBERRY_WIRING_PIN26_swigconstant(_mraa)
RASPBERRY_WIRING_PIN26 = _mraa.RASPBERRY_WIRING_PIN26

_mraa.RASPBERRY_WIRING_PIN23_swigconstant(_mraa)
RASPBERRY_WIRING_PIN23 = _mraa.RASPBERRY_WIRING_PIN23

_mraa.RASPBERRY_WIRING_PIN24_swigconstant(_mraa)
RASPBERRY_WIRING_PIN24 = _mraa.RASPBERRY_WIRING_PIN24

_mraa.RASPBERRY_WIRING_PIN27_swigconstant(_mraa)
RASPBERRY_WIRING_PIN27 = _mraa.RASPBERRY_WIRING_PIN27

_mraa.RASPBERRY_WIRING_PIN25_swigconstant(_mraa)
RASPBERRY_WIRING_PIN25 = _mraa.RASPBERRY_WIRING_PIN25

_mraa.RASPBERRY_WIRING_PIN28_swigconstant(_mraa)
RASPBERRY_WIRING_PIN28 = _mraa.RASPBERRY_WIRING_PIN28

_mraa.RASPBERRY_WIRING_PIN29_swigconstant(_mraa)
RASPBERRY_WIRING_PIN29 = _mraa.RASPBERRY_WIRING_PIN29

_mraa.SUCCESS_swigconstant(_mraa)
SUCCESS = _mraa.SUCCESS

_mraa.ERROR_FEATURE_NOT_IMPLEMENTED_swigconstant(_mraa)
ERROR_FEATURE_NOT_IMPLEMENTED = _mraa.ERROR_FEATURE_NOT_IMPLEMENTED

_mraa.ERROR_FEATURE_NOT_SUPPORTED_swigconstant(_mraa)
ERROR_FEATURE_NOT_SUPPORTED = _mraa.ERROR_FEATURE_NOT_SUPPORTED

_mraa.ERROR_INVALID_VERBOSITY_LEVEL_swigconstant(_mraa)
ERROR_INVALID_VERBOSITY_LEVEL = _mraa.ERROR_INVALID_VERBOSITY_LEVEL

_mraa.ERROR_INVALID_PARAMETER_swigconstant(_mraa)
ERROR_INVALID_PARAMETER = _mraa.ERROR_INVALID_PARAMETER

_mraa.ERROR_INVALID_HANDLE_swigconstant(_mraa)
ERROR_INVALID_HANDLE = _mraa.ERROR_INVALID_HANDLE

_mraa.ERROR_NO_RESOURCES_swigconstant(_mraa)
ERROR_NO_RESOURCES = _mraa.ERROR_NO_RESOURCES

_mraa.ERROR_INVALID_RESOURCE_swigconstant(_mraa)
ERROR_INVALID_RESOURCE = _mraa.ERROR_INVALID_RESOURCE

_mraa.ERROR_INVALID_QUEUE_TYPE_swigconstant(_mraa)
ERROR_INVALID_QUEUE_TYPE = _mraa.ERROR_INVALID_QUEUE_TYPE

_mraa.ERROR_NO_DATA_AVAILABLE_swigconstant(_mraa)
ERROR_NO_DATA_AVAILABLE = _mraa.ERROR_NO_DATA_AVAILABLE

_mraa.ERROR_INVALID_PLATFORM_swigconstant(_mraa)
ERROR_INVALID_PLATFORM = _mraa.ERROR_INVALID_PLATFORM

_mraa.ERROR_PLATFORM_NOT_INITIALISED_swigconstant(_mraa)
ERROR_PLATFORM_NOT_INITIALISED = _mraa.ERROR_PLATFORM_NOT_INITIALISED

_mraa.ERROR_UART_OW_SHORTED_swigconstant(_mraa)
ERROR_UART_OW_SHORTED = _mraa.ERROR_UART_OW_SHORTED

_mraa.ERROR_UART_OW_NO_DEVICES_swigconstant(_mraa)
ERROR_UART_OW_NO_DEVICES = _mraa.ERROR_UART_OW_NO_DEVICES

_mraa.ERROR_UART_OW_DATA_ERROR_swigconstant(_mraa)
ERROR_UART_OW_DATA_ERROR = _mraa.ERROR_UART_OW_DATA_ERROR

_mraa.ERROR_UNSPECIFIED_swigconstant(_mraa)
ERROR_UNSPECIFIED = _mraa.ERROR_UNSPECIFIED

_mraa.PIN_VALID_swigconstant(_mraa)
PIN_VALID = _mraa.PIN_VALID

_mraa.PIN_GPIO_swigconstant(_mraa)
PIN_GPIO = _mraa.PIN_GPIO

_mraa.PIN_PWM_swigconstant(_mraa)
PIN_PWM = _mraa.PIN_PWM

_mraa.PIN_FAST_GPIO_swigconstant(_mraa)
PIN_FAST_GPIO = _mraa.PIN_FAST_GPIO

_mraa.PIN_SPI_swigconstant(_mraa)
PIN_SPI = _mraa.PIN_SPI

_mraa.PIN_I2C_swigconstant(_mraa)
PIN_I2C = _mraa.PIN_I2C

_mraa.PIN_AIO_swigconstant(_mraa)
PIN_AIO = _mraa.PIN_AIO

_mraa.PIN_UART_swigconstant(_mraa)
PIN_UART = _mraa.PIN_UART

_mraa.I2C_STD_swigconstant(_mraa)
I2C_STD = _mraa.I2C_STD

_mraa.I2C_FAST_swigconstant(_mraa)
I2C_FAST = _mraa.I2C_FAST

_mraa.I2C_HIGH_swigconstant(_mraa)
I2C_HIGH = _mraa.I2C_HIGH

_mraa.UART_PARITY_NONE_swigconstant(_mraa)
UART_PARITY_NONE = _mraa.UART_PARITY_NONE

_mraa.UART_PARITY_EVEN_swigconstant(_mraa)
UART_PARITY_EVEN = _mraa.UART_PARITY_EVEN

_mraa.UART_PARITY_ODD_swigconstant(_mraa)
UART_PARITY_ODD = _mraa.UART_PARITY_ODD

_mraa.UART_PARITY_MARK_swigconstant(_mraa)
UART_PARITY_MARK = _mraa.UART_PARITY_MARK

_mraa.UART_PARITY_SPACE_swigconstant(_mraa)
UART_PARITY_SPACE = _mraa.UART_PARITY_SPACE

def init():
    """init() -> mraa::Result"""
    return _mraa.init()

def getVersion():
    """getVersion() -> std::string"""
    return _mraa.getVersion()

def setPriority(priority):
    """
    setPriority(int const priority) -> int

    Parameters:
        priority: int const

    """
    return _mraa.setPriority(priority)

def getPlatformType():
    """getPlatformType() -> mraa::Platform"""
    return _mraa.getPlatformType()

def printError(result):
    """
    printError(mraa::Result result)

    Parameters:
        result: enum mraa::Result

    """
    return _mraa.printError(result)

def pinModeTest(pin, mode):
    """
    pinModeTest(int pin, mraa::Pinmodes mode) -> bool

    Parameters:
        pin: int
        mode: enum mraa::Pinmodes

    """
    return _mraa.pinModeTest(pin, mode)

def adcRawBits():
    """adcRawBits() -> unsigned int"""
    return _mraa.adcRawBits()

def adcSupportedBits():
    """adcSupportedBits() -> unsigned int"""
    return _mraa.adcSupportedBits()

def getPlatformName():
    """getPlatformName() -> std::string"""
    return _mraa.getPlatformName()

def getPlatformVersion(*args):
    """
    getPlatformVersion(int platform_offset) -> std::string

    Parameters:
        platform_offset: int

    getPlatformVersion() -> std::string
    """
    return _mraa.getPlatformVersion(*args)

def getPinCount():
    """getPinCount() -> unsigned int"""
    return _mraa.getPinCount()

def getI2cBusCount():
    """getI2cBusCount() -> int"""
    return _mraa.getI2cBusCount()

def getI2cBusId(i2c_bus):
    """
    getI2cBusId(int i2c_bus) -> int

    Parameters:
        i2c_bus: int

    """
    return _mraa.getI2cBusId(i2c_bus)

def getPinName(pin):
    """
    getPinName(int pin) -> std::string

    Parameters:
        pin: int

    """
    return _mraa.getPinName(pin)

def setLogLevel(level):
    """
    setLogLevel(int level) -> mraa::Result

    Parameters:
        level: int

    """
    return _mraa.setLogLevel(level)

def hasSubPlatform():
    """hasSubPlatform() -> bool"""
    return _mraa.hasSubPlatform()

def isSubPlatformId(pin_or_bus_id):
    """
    isSubPlatformId(int pin_or_bus_id) -> bool

    Parameters:
        pin_or_bus_id: int

    """
    return _mraa.isSubPlatformId(pin_or_bus_id)

def getSubPlatformId(pin_or_bus_index):
    """
    getSubPlatformId(int pin_or_bus_index) -> int

    Parameters:
        pin_or_bus_index: int

    """
    return _mraa.getSubPlatformId(pin_or_bus_index)

def getSubPlatformIndex(pin_or_bus_id):
    """
    getSubPlatformIndex(int pin_or_bus_id) -> int

    Parameters:
        pin_or_bus_id: int

    """
    return _mraa.getSubPlatformIndex(pin_or_bus_id)

def getDefaultI2cBus(*args):
    """
    getDefaultI2cBus(int platform_offset) -> int

    Parameters:
        platform_offset: int

    getDefaultI2cBus() -> int
    """
    return _mraa.getDefaultI2cBus(*args)

def addSubplatform(subplatformtype, uart_dev):
    """
    addSubplatform(mraa::Platform subplatformtype, std::string uart_dev) -> mraa::Result

    Parameters:
        subplatformtype: enum mraa::Platform
        uart_dev: std::string

    """
    return _mraa.addSubplatform(subplatformtype, uart_dev)

def removeSubplatform(subplatformtype):
    """
    removeSubplatform(mraa::Platform subplatformtype) -> mraa::Result

    Parameters:
        subplatformtype: enum mraa::Platform

    """
    return _mraa.removeSubplatform(subplatformtype)

def initJsonPlatform(path):
    """
    initJsonPlatform(std::string path) -> mraa::Result

    Parameters:
        path: std::string

    """
    return _mraa.initJsonPlatform(path)

def gpioFromDesc(desc):
    """
    gpioFromDesc(std::string desc) -> Gpio

    Parameters:
        desc: std::string

    """
    return _mraa.gpioFromDesc(desc)

def aioFromDesc(desc):
    """
    aioFromDesc(std::string desc) -> Aio

    Parameters:
        desc: std::string

    """
    return _mraa.aioFromDesc(desc)

def uartFromDesc(desc):
    """
    uartFromDesc(std::string desc) -> Uart

    Parameters:
        desc: std::string

    """
    return _mraa.uartFromDesc(desc)

def spiFromDesc(desc):
    """
    spiFromDesc(std::string desc) -> Spi

    Parameters:
        desc: std::string

    """
    return _mraa.spiFromDesc(desc)

def i2cFromDesc(desc):
    """
    i2cFromDesc(std::string desc) -> I2c

    Parameters:
        desc: std::string

    """
    return _mraa.i2cFromDesc(desc)

def pwmFromDesc(desc):
    """
    pwmFromDesc(std::string desc) -> Pwm

    Parameters:
        desc: std::string

    """
    return _mraa.pwmFromDesc(desc)

_mraa.MODE_STRONG_swigconstant(_mraa)
MODE_STRONG = _mraa.MODE_STRONG

_mraa.MODE_PULLUP_swigconstant(_mraa)
MODE_PULLUP = _mraa.MODE_PULLUP

_mraa.MODE_PULLDOWN_swigconstant(_mraa)
MODE_PULLDOWN = _mraa.MODE_PULLDOWN

_mraa.MODE_HIZ_swigconstant(_mraa)
MODE_HIZ = _mraa.MODE_HIZ

_mraa.DIR_OUT_swigconstant(_mraa)
DIR_OUT = _mraa.DIR_OUT

_mraa.DIR_IN_swigconstant(_mraa)
DIR_IN = _mraa.DIR_IN

_mraa.DIR_OUT_HIGH_swigconstant(_mraa)
DIR_OUT_HIGH = _mraa.DIR_OUT_HIGH

_mraa.DIR_OUT_LOW_swigconstant(_mraa)
DIR_OUT_LOW = _mraa.DIR_OUT_LOW

_mraa.EDGE_NONE_swigconstant(_mraa)
EDGE_NONE = _mraa.EDGE_NONE

_mraa.EDGE_BOTH_swigconstant(_mraa)
EDGE_BOTH = _mraa.EDGE_BOTH

_mraa.EDGE_RISING_swigconstant(_mraa)
EDGE_RISING = _mraa.EDGE_RISING

_mraa.EDGE_FALLING_swigconstant(_mraa)
EDGE_FALLING = _mraa.EDGE_FALLING
class Gpio(_object):
    """Proxy of C++ mraa::Gpio class"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Gpio, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Gpio, name)
    __repr__ = _swig_repr

    def __init__(self, pin, owner=True, raw=False):
        """
        __init__(mraa::Gpio self, int pin, bool owner=True, bool raw=False) -> Gpio

        Parameters:
            pin: int
            owner: bool
            raw: bool

        __init__(mraa::Gpio self, int pin, bool owner=True) -> Gpio

        Parameters:
            pin: int
            owner: bool

        __init__(mraa::Gpio self, int pin) -> Gpio

        Parameters:
            pin: int

        """
        this = _mraa.new_Gpio(pin, owner, raw)
        try:
            self.this.append(this)
        except:
            self.this = this
    __swig_destroy__ = _mraa.delete_Gpio
    __del__ = lambda self: None

    def edge(self, mode):
        """
        edge(Gpio self, mraa::Edge mode) -> mraa::Result

        Parameters:
            mode: enum mraa::Edge

        """
        return _mraa.Gpio_edge(self, mode)


    def isr(self, mode, pyfunc, args):
        """
        isr(Gpio self, mraa::Edge mode, PyObject * pyfunc, PyObject * args) -> mraa::Result

        Parameters:
            mode: enum mraa::Edge
            pyfunc: PyObject *
            args: PyObject *

        """
        return _mraa.Gpio_isr(self, mode, pyfunc, args)


    def isrExit(self):
        """
        isrExit(Gpio self) -> mraa::Result

        Parameters:
            self: mraa::Gpio *

        """
        return _mraa.Gpio_isrExit(self)


    def mode(self, mode):
        """
        mode(Gpio self, mraa::Mode mode) -> mraa::Result

        Parameters:
            mode: enum mraa::Mode

        """
        return _mraa.Gpio_mode(self, mode)


    def dir(self, dir):
        """
        dir(Gpio self, mraa::Dir dir) -> mraa::Result

        Parameters:
            dir: enum mraa::Dir

        """
        return _mraa.Gpio_dir(self, dir)


    def readDir(self):
        """
        readDir(Gpio self) -> mraa::Dir

        Parameters:
            self: mraa::Gpio *

        """
        return _mraa.Gpio_readDir(self)


    def read(self):
        """
        read(Gpio self) -> int

        Parameters:
            self: mraa::Gpio *

        """
        return _mraa.Gpio_read(self)


    def write(self, value):
        """
        write(Gpio self, int value) -> mraa::Result

        Parameters:
            value: int

        """
        return _mraa.Gpio_write(self, value)


    def useMmap(self, enable):
        """
        useMmap(Gpio self, bool enable) -> mraa::Result

        Parameters:
            enable: bool

        """
        return _mraa.Gpio_useMmap(self, enable)


    def getPin(self, raw=False):
        """
        getPin(Gpio self, bool raw=False) -> int

        Parameters:
            raw: bool

        getPin(Gpio self) -> int

        Parameters:
            self: mraa::Gpio *

        """
        return _mraa.Gpio_getPin(self, raw)

Gpio_swigregister = _mraa.Gpio_swigregister
Gpio_swigregister(Gpio)

class I2c(_object):
    """Proxy of C++ mraa::I2c class"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, I2c, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, I2c, name)
    __repr__ = _swig_repr

    def __init__(self, bus, raw=False):
        """
        __init__(mraa::I2c self, int bus, bool raw=False) -> I2c

        Parameters:
            bus: int
            raw: bool

        __init__(mraa::I2c self, int bus) -> I2c

        Parameters:
            bus: int

        """
        this = _mraa.new_I2c(bus, raw)
        try:
            self.this.append(this)
        except:
            self.this = this
    __swig_destroy__ = _mraa.delete_I2c
    __del__ = lambda self: None

    def frequency(self, mode):
        """
        frequency(I2c self, mraa::I2cMode mode) -> mraa::Result

        Parameters:
            mode: enum mraa::I2cMode

        """
        return _mraa.I2c_frequency(self, mode)


    def address(self, address):
        """
        address(I2c self, uint8_t address) -> mraa::Result

        Parameters:
            address: uint8_t

        """
        return _mraa.I2c_address(self, address)


    def readByte(self):
        """
        readByte(I2c self) -> uint8_t

        Parameters:
            self: mraa::I2c *

        """
        return _mraa.I2c_readByte(self)


    def read(self, data):
        """
        read(I2c self, uint8_t * data) -> int

        Parameters:
            data: uint8_t *

        """
        return _mraa.I2c_read(self, data)


    def readReg(self, reg):
        """
        readReg(I2c self, uint8_t reg) -> uint8_t

        Parameters:
            reg: uint8_t

        """
        return _mraa.I2c_readReg(self, reg)


    def readWordReg(self, reg):
        """
        readWordReg(I2c self, uint8_t reg) -> uint16_t

        Parameters:
            reg: uint8_t

        """
        return _mraa.I2c_readWordReg(self, reg)


    def readBytesReg(self, reg, data):
        """
        readBytesReg(I2c self, uint8_t reg, uint8_t * data) -> int

        Parameters:
            reg: uint8_t
            data: uint8_t *

        """
        return _mraa.I2c_readBytesReg(self, reg, data)


    def writeByte(self, data):
        """
        writeByte(I2c self, uint8_t data) -> mraa::Result

        Parameters:
            data: uint8_t

        """
        return _mraa.I2c_writeByte(self, data)


    def write(self, data):
        """
        write(I2c self, uint8_t const * data) -> mraa::Result

        Parameters:
            data: uint8_t const *

        """
        return _mraa.I2c_write(self, data)


    def writeReg(self, reg, data):
        """
        writeReg(I2c self, uint8_t reg, uint8_t data) -> mraa::Result

        Parameters:
            reg: uint8_t
            data: uint8_t

        """
        return _mraa.I2c_writeReg(self, reg, data)


    def writeWordReg(self, reg, data):
        """
        writeWordReg(I2c self, uint8_t reg, uint16_t data) -> mraa::Result

        Parameters:
            reg: uint8_t
            data: uint16_t

        """
        return _mraa.I2c_writeWordReg(self, reg, data)

I2c_swigregister = _mraa.I2c_swigregister
I2c_swigregister(I2c)

class Pwm(_object):
    """Proxy of C++ mraa::Pwm class"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Pwm, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Pwm, name)
    __repr__ = _swig_repr

    def __init__(self, pin, owner=True, chipid=-1):
        """
        __init__(mraa::Pwm self, int pin, bool owner=True, int chipid=-1) -> Pwm

        Parameters:
            pin: int
            owner: bool
            chipid: int

        __init__(mraa::Pwm self, int pin, bool owner=True) -> Pwm

        Parameters:
            pin: int
            owner: bool

        __init__(mraa::Pwm self, int pin) -> Pwm

        Parameters:
            pin: int

        """
        this = _mraa.new_Pwm(pin, owner, chipid)
        try:
            self.this.append(this)
        except:
            self.this = this
    __swig_destroy__ = _mraa.delete_Pwm
    __del__ = lambda self: None

    def write(self, percentage):
        """
        write(Pwm self, float percentage) -> mraa::Result

        Parameters:
            percentage: float

        """
        return _mraa.Pwm_write(self, percentage)


    def read(self):
        """
        read(Pwm self) -> float

        Parameters:
            self: mraa::Pwm *

        """
        return _mraa.Pwm_read(self)


    def period(self, period):
        """
        period(Pwm self, float period) -> mraa::Result

        Parameters:
            period: float

        """
        return _mraa.Pwm_period(self, period)


    def period_ms(self, ms):
        """
        period_ms(Pwm self, int ms) -> mraa::Result

        Parameters:
            ms: int

        """
        return _mraa.Pwm_period_ms(self, ms)


    def period_us(self, us):
        """
        period_us(Pwm self, int us) -> mraa::Result

        Parameters:
            us: int

        """
        return _mraa.Pwm_period_us(self, us)


    def pulsewidth(self, seconds):
        """
        pulsewidth(Pwm self, float seconds) -> mraa::Result

        Parameters:
            seconds: float

        """
        return _mraa.Pwm_pulsewidth(self, seconds)


    def pulsewidth_ms(self, ms):
        """
        pulsewidth_ms(Pwm self, int ms) -> mraa::Result

        Parameters:
            ms: int

        """
        return _mraa.Pwm_pulsewidth_ms(self, ms)


    def pulsewidth_us(self, us):
        """
        pulsewidth_us(Pwm self, int us) -> mraa::Result

        Parameters:
            us: int

        """
        return _mraa.Pwm_pulsewidth_us(self, us)


    def enable(self, enable):
        """
        enable(Pwm self, bool enable) -> mraa::Result

        Parameters:
            enable: bool

        """
        return _mraa.Pwm_enable(self, enable)


    def max_period(self):
        """
        max_period(Pwm self) -> int

        Parameters:
            self: mraa::Pwm *

        """
        return _mraa.Pwm_max_period(self)


    def min_period(self):
        """
        min_period(Pwm self) -> int

        Parameters:
            self: mraa::Pwm *

        """
        return _mraa.Pwm_min_period(self)

Pwm_swigregister = _mraa.Pwm_swigregister
Pwm_swigregister(Pwm)


_mraa.SPI_MODE0_swigconstant(_mraa)
SPI_MODE0 = _mraa.SPI_MODE0

_mraa.SPI_MODE1_swigconstant(_mraa)
SPI_MODE1 = _mraa.SPI_MODE1

_mraa.SPI_MODE2_swigconstant(_mraa)
SPI_MODE2 = _mraa.SPI_MODE2

_mraa.SPI_MODE3_swigconstant(_mraa)
SPI_MODE3 = _mraa.SPI_MODE3
class Spi(_object):
    """Proxy of C++ mraa::Spi class"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Spi, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Spi, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(mraa::Spi self, int bus) -> Spi

        Parameters:
            bus: int

        __init__(mraa::Spi self, int bus, int cs) -> Spi

        Parameters:
            bus: int
            cs: int

        """
        this = _mraa.new_Spi(*args)
        try:
            self.this.append(this)
        except:
            self.this = this
    __swig_destroy__ = _mraa.delete_Spi
    __del__ = lambda self: None

    def mode(self, mode):
        """
        mode(Spi self, mraa::Spi_Mode mode) -> mraa::Result

        Parameters:
            mode: enum mraa::Spi_Mode

        """
        return _mraa.Spi_mode(self, mode)


    def frequency(self, hz):
        """
        frequency(Spi self, int hz) -> mraa::Result

        Parameters:
            hz: int

        """
        return _mraa.Spi_frequency(self, hz)


    def writeByte(self, data):
        """
        writeByte(Spi self, uint8_t data) -> int

        Parameters:
            data: uint8_t

        """
        return _mraa.Spi_writeByte(self, data)


    def writeWord(self, data):
        """
        writeWord(Spi self, uint16_t data) -> int

        Parameters:
            data: uint16_t

        """
        return _mraa.Spi_writeWord(self, data)


    def write(self, txBuf):
        """
        write(Spi self, uint8_t * txBuf) -> uint8_t *

        Parameters:
            txBuf: uint8_t *

        """
        return _mraa.Spi_write(self, txBuf)


    def lsbmode(self, lsb):
        """
        lsbmode(Spi self, bool lsb) -> mraa::Result

        Parameters:
            lsb: bool

        """
        return _mraa.Spi_lsbmode(self, lsb)


    def bitPerWord(self, bits):
        """
        bitPerWord(Spi self, unsigned int bits) -> mraa::Result

        Parameters:
            bits: unsigned int

        """
        return _mraa.Spi_bitPerWord(self, bits)

Spi_swigregister = _mraa.Spi_swigregister
Spi_swigregister(Spi)

class Aio(_object):
    """Proxy of C++ mraa::Aio class"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Aio, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Aio, name)
    __repr__ = _swig_repr

    def __init__(self, pin):
        """
        __init__(mraa::Aio self, int pin) -> Aio

        Parameters:
            pin: int

        """
        this = _mraa.new_Aio(pin)
        try:
            self.this.append(this)
        except:
            self.this = this
    __swig_destroy__ = _mraa.delete_Aio
    __del__ = lambda self: None

    def read(self):
        """
        read(Aio self) -> unsigned int

        Parameters:
            self: mraa::Aio *

        """
        return _mraa.Aio_read(self)


    def readFloat(self):
        """
        readFloat(Aio self) -> float

        Parameters:
            self: mraa::Aio *

        """
        return _mraa.Aio_readFloat(self)


    def setBit(self, bits):
        """
        setBit(Aio self, int bits) -> mraa::Result

        Parameters:
            bits: int

        """
        return _mraa.Aio_setBit(self, bits)


    def getBit(self):
        """
        getBit(Aio self) -> int

        Parameters:
            self: mraa::Aio *

        """
        return _mraa.Aio_getBit(self)

Aio_swigregister = _mraa.Aio_swigregister
Aio_swigregister(Aio)

class Uart(_object):
    """Proxy of C++ mraa::Uart class"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Uart, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Uart, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(mraa::Uart self, int uart) -> Uart

        Parameters:
            uart: int

        __init__(mraa::Uart self, std::string path) -> Uart

        Parameters:
            path: std::string

        """
        this = _mraa.new_Uart(*args)
        try:
            self.this.append(this)
        except:
            self.this = this
    __swig_destroy__ = _mraa.delete_Uart
    __del__ = lambda self: None

    def getDevicePath(self):
        """
        getDevicePath(Uart self) -> std::string

        Parameters:
            self: mraa::Uart *

        """
        return _mraa.Uart_getDevicePath(self)


    def read(self, data):
        """
        read(Uart self, char * data) -> int

        Parameters:
            data: char *

        """
        return _mraa.Uart_read(self, data)


    def write(self, data):
        """
        write(Uart self, char const * data) -> int

        Parameters:
            data: char const *

        """
        return _mraa.Uart_write(self, data)


    def readStr(self, length):
        """
        readStr(Uart self, int length) -> std::string

        Parameters:
            length: int

        """
        return _mraa.Uart_readStr(self, length)


    def writeStr(self, data):
        """
        writeStr(Uart self, std::string data) -> int

        Parameters:
            data: std::string

        """
        return _mraa.Uart_writeStr(self, data)


    def dataAvailable(self, millis=0):
        """
        dataAvailable(Uart self, unsigned int millis=0) -> bool

        Parameters:
            millis: unsigned int

        dataAvailable(Uart self) -> bool

        Parameters:
            self: mraa::Uart *

        """
        return _mraa.Uart_dataAvailable(self, millis)


    def flush(self):
        """
        flush(Uart self) -> mraa::Result

        Parameters:
            self: mraa::Uart *

        """
        return _mraa.Uart_flush(self)


    def setBaudRate(self, baud):
        """
        setBaudRate(Uart self, unsigned int baud) -> mraa::Result

        Parameters:
            baud: unsigned int

        """
        return _mraa.Uart_setBaudRate(self, baud)


    def setMode(self, bytesize, parity, stopbits):
        """
        setMode(Uart self, int bytesize, mraa::UartParity parity, int stopbits) -> mraa::Result

        Parameters:
            bytesize: int
            parity: enum mraa::UartParity
            stopbits: int

        """
        return _mraa.Uart_setMode(self, bytesize, parity, stopbits)


    def setFlowcontrol(self, xonxoff, rtscts):
        """
        setFlowcontrol(Uart self, bool xonxoff, bool rtscts) -> mraa::Result

        Parameters:
            xonxoff: bool
            rtscts: bool

        """
        return _mraa.Uart_setFlowcontrol(self, xonxoff, rtscts)


    def setTimeout(self, read, write, interchar):
        """
        setTimeout(Uart self, int read, int write, int interchar) -> mraa::Result

        Parameters:
            read: int
            write: int
            interchar: int

        """
        return _mraa.Uart_setTimeout(self, read, write, interchar)


    def SetNonBlocking(self, nonblock):
        """
        SetNonBlocking(Uart self, bool nonblock) -> mraa::Result

        Parameters:
            nonblock: bool

        """
        return _mraa.Uart_SetNonBlocking(self, nonblock)

Uart_swigregister = _mraa.Uart_swigregister
Uart_swigregister(Uart)

# This file is compatible with both classic and new-style classes.


