/*
 * Author: Alexander Komarov <alexander.komarov@intel.com>
 * Copyright (c) 2014 Intel Corporation.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import mraa.Dir;
import mraa.Edge;
import mraa.Gpio;

public class Isr {
    static {
        try {
            System.loadLibrary("mraajava");
        } catch (UnsatisfiedLinkError e) {
            System.err.println(
                    "Native code library failed to load. See the chapter on Dynamic Linking Problems in the SWIG Java documentation for help.\n" +
                            e);
            System.exit(1);
        }
    }

    public static void main(String argv[]) throws InterruptedException {
        int pin = 6;
        if (argv.length == 1) {
            try {
                pin = Integer.parseInt(argv[0]);
            } catch (Exception e) {
            }
        }
        BufferedReader console = new BufferedReader(new InputStreamReader(System.in));
        Gpio gpio = null;
        try {
            gpio = new Gpio(pin);
        }  catch (Exception e) {
            System.out.println(e.getMessage());
            return;
        }
        System.out.println("Starting ISR for pin " + Integer.toString(pin) + ". Press ENTER to stop");
        Runnable callback = new JavaCallback(gpio);
        gpio.isr(Edge.EDGE_RISING, callback);
        try {
            String input = console.readLine();
        } catch (IOException e) {
        }
        gpio.isrExit();
    }

}

class JavaCallback implements Runnable {
    private Gpio gpio;

    public JavaCallback(Gpio gpio) {
        this.gpio = gpio;
    }

    @Override
    public void run() {
        String pin = Integer.toString(gpio.getPin(true));
        String level = Integer.toString(gpio.read());
        System.out.println("Pin " + pin + " = " + level);
    }
}
