#!/bin/bash

# -----------------------------------------------------------------------------
# Copyright (c) 2016 Intel Corporation
# All rights reserved. This program and the accompanying materials
# are made available under the terms of the Eclipse Public License v1.0
# which accompanies this distribution, and is available at
# http://www.eclipse.org/legal/epl-v10.html
# -----------------------------------------------------------------------------

result=""
for var in $@
do
  version="$(opkg list-installed | grep "${var} - .*" | sed "s/""${var}"" - //" | sed "s/-.*//")"
  if [ -z "$version" ]
  then
    result="${result}:Not installed"
  else
    result="${result}:${version}"
  fi
done

# Remove the extra `:`
result="$(echo ${result} | cut -c2-)"
echo ${result}
