#!/bin/bash

# -----------------------------------------------------------------------------
# Copyright (c) 2016 Intel Corporation
# All rights reserved. This program and the accompanying materials
# are made available under the terms of the Eclipse Public License v1.0
# which accompanies this distribution, and is available at
# http://www.eclipse.org/legal/epl-v10.html
# -----------------------------------------------------------------------------

# Display only local package version with the following format:
# OFFLINE:{local version of package 1}:...
function displayOfflineVersion {
  result=OFFLINE

  for var in "$@"
  do
    version="$(opkg list-installed | grep "${var} - .*" | sed "s/""${var}"" - //" | sed "s/-.*//")"
    if [ -z "$version" ]
    then
      result="${result}:NOT_INSTALLED"
    else
      result="${result}:${version}"
    fi
  done

  echo $result
}

# Display local and online package version with the following format:
# ONLINE:{local version of package 1} - {online version of package 1}:...
function displayOnlineVersion {
  result=ONLINE

  for var in "$@"
  do
    export upgradable="$(opkg list-upgradable | grep "${var} - .*" | sed "s/""${var}"" - //")"
    if [ -z "$upgradable" ]
    then
      version="$(opkg list-installed | grep "${var} - .*" | sed "s/""${var}"" - //" | sed "s/-.*//")"
      if [ -z "$version" ]
      then
        result="${result}:NOT_INSTALLED - NOT_INSTALLED"
      else
        result="${result}:$version - $version"
      fi
    else
      result="${result}:$upgradable"
    fi
  done

  echo $result
}

# Following lines correspond at an equivalent of "timeout 30 opkg update"
# Reason :
# `opkg update` never stop if it cannot download the file
# `timeout` is not installed on Yocto Edion

opkg update &
update_pid="$(echo $!)"

sleep 40 &
sleep_pid="$(echo $!)"

update_running="$(ps | grep "${update_pid}.*opkg update" | grep -v "grep")"
sleep_running="$(ps | grep "${sleep_pid}.*sleep 40" | grep -v "grep")"

while [ "$update_running" ] && [ "$sleep_running" ]
do
  sleep 1
  update_running="$(ps | grep "${update_pid}.*opkg update" | grep -v "grep")"
  sleep_running="$(ps | grep "${sleep_id}.*sleep 40" | grep -v "grep")"
done

if [ "$update_running" ]
then
  # `opkg update` did not work
  # Kill opkg in order to free the opkg lock
  kill -9 $update_pid 2>&1 1> /dev/null

  displayOfflineVersion $@
else
  # Check if `opkg update` run correctly
  wait $update_pid
  return_code="$(echo $?)"

  if (( return_code == 0 ))
  then
    # We catched latest online version
    displayOnlineVersion $@
  else
    # An error happened
    displayOfflineVersion $@
  fi
fi
