<?php
/*****************************************************************************
 *
 *                   INTEL CORPORATION PROPRIETARY INFORMATION
 *       This software is supplied under the terms of a license agreement or
 *       nondisclosure agreement with Intel Corporation and may not be copied
 *       or disclosed except in accordance with the terms of that agreement.
 *            Copyright (c) 2009 Intel Corporation. All Rights Reserved.
 *
 *****************************************************************************/

//Error log files backup
$errorFilePath=ini_get(error_log);
$size=filesize($errorFilePath);
	if(filesize($errorFilePath) > 26214400 )
			{
				$arrayVal=explode(".",$errorFilePath);
				$newName=$arrayVal[0]."_1.".$arrayVal[1];
					if(file_exists($newName))
						unlink($newName);
				rename($errorFilePath,$newName);
		}
/*
* check_valid_session
*
*/
		

function check_valid_session()
{
    try
    {
        session_start();
        if(isset($_SESSION["IASC_Session_ID"]))
        {

            if($_SESSION['HTTP_USER_AGENT'] == md5($_SERVER['HTTP_USER_AGENT']))
            {
                return 0;
	    }

		

	    error_log("\ncheck_valid_session : Invalid session\n", 0);
            return -51;
        }
        else
	{
	    error_log("\ncheck_valid_session : Invalid session\n", 0);		
            return -51;
        }
    }
    catch(Exception $e)
    {
        error_log("Caught exception: '{e->getMessage()}' in "
            . "{e->getFile()}({e->getLine()})\n"
             . "{e->getTraceAsString()}", 0);
        
        return -70;
    }
}

/*
 * ASC_Get
 *
 */
function ASC_Get($rStr)
{
	//error_log("\nCalling ASC_Get : \n", 0);
    try
    {    
        $sess=0;
        $sess=check_valid_session();
        if(($sess == -51) || ($sess ==  -31))
	{
  	    error_log("\nPHP sess Error is: \n" . $sess, 0);
            $test='<?xml version="1.0" encoding="UTF-8" standalone="no" ?><Response Operation="get"><Status>Error</Status><message>Invalid_Session</message></Response>';


            error_log($test, 0);
            return $test;
        }
        else if($sess == -70)
	{
	    error_log("\nPHP sess Error is: \n" . $sess, 0);
            $test='<?xml version="1.0" encoding="UTF-8" standalone="no" ?><Response Operation="get"><Status>Error</Status><message>Exception_occurred</message></Response>';
            error_log($test, 0);
            return $test;
        }
        //error_log("\nPHP Request is: \n" . $rStr, 0);

        $req= new Request($rStr);
        $rsp= new Response();

        if($req && $rsp)
        {
            $sess = $_SESSION["IASC_Session_ID"];
            $ret=Get($sess,$req,$rsp);

            /* not reqd as backend will return error 
             * xml in the $rsp->getResponse
             */
        if(($ret == -51) || ($ret ==  -31))		    
	{
		 error_log("\nPHP ret Error is: \n" . $ret, 0);
                $test='<?xml version="1.0" encoding="UTF-8" standalone="no" ?><Response Operation="get"><Status>Error</Status><message>Invalid_Session</message></Response>';
                error_log($test, 0);
                return $test;
            }
            else if($ret == -53)
	    {
		    error_log("\nPHP ret Error is: \n" . $ret, 0);
                $test='<?xml version="1.0" encoding="UTF-8" standalone="no" ?><Response Operation="get"><Status>Error</Status><message>Session_Time_Out</message></Response>';
                error_log($test, 0);
                return $test;
            }
            else if($ret == 255)
	    {
		    error_log("\nPHP ret Error is: \n" . $ret, 0);
                $test='<?xml version="1.0" encoding="UTF-8" standalone="no" ?><Response Operation="get"><Status>Error</Status><message>Exception_occurred</message></Response>';
                error_log($test, 0);
                return $test;
            }

            $test=$rsp->getResponse();

            //error_log("\nPHP Response is: \n" . $test . "\n\n", 0);
            return $test;
        }
        else
        {
            $test='<?xml version="1.0" encoding="UTF-8" standalone="no" ?><Response Operation="get"><Status>Error</Status><message>Exception_occurred</message></Response>';
            error_log($test, 0);
            return $test;

        }
    }
    catch(Exception $e)
    {
        $test='<?xml version="1.0" encoding="UTF-8" standalone="no" ?><Response Operation="get"><Status>Error</Status><message>Exception_occurred</message></Response>';
        error_log("Caught exception: '{e->getMessage()}' in "
            . "{e->getFile()}({e->getLine()})\n"
             . "{e->getTraceAsString()}", 0);
        
        return $test;
    }
}

/*
 * ASC_Set
 *
 */
function ASC_Set($rStr)
{
	//error_log("\nCalling ASC_Set : \n", 0);
    try
    {
        $sess=0;
	$sess=check_valid_session();
        if(($sess == -51) || ($sess ==  -31))	
        {
            $test='<?xml version="1.0" encoding="UTF-8" standalone="no" ?><Response Operation="set"><Status>Error</Status><message>Invalid_Session</message></Response>';
            error_log($test, 0);
            return $test;
        }
        else if($sess == -70)
        {
            $test='<?xml version="1.0" encoding="UTF-8" standalone="no" ?><Response Operation="set"><Status>Error</Status><message>Exception_occurred</message></Response>';
            error_log($test, 0);
            return $test;
        }

        $req= new Request($rStr);

        //error_log("\nPHP Request is: \n". $rStr. "\n\n", 0);

        $rsp= new Response();

        if($req && $rsp)
        {
            $sess=$_SESSION["IASC_Session_ID"];
            $ret=Set($sess,$req,$rsp);
        if(($ret == -51) || ($ret ==  -31))
            {
                $test='<?xml version="1.0" encoding="UTF-8" standalone="no" ?><Response Operation="set"><Status>Error</Status><message>Invalid_Session</message></Response>';
                error_log($test, 0);
                return $test;
            }
            else if($ret == -53)
            {
                $test='<?xml version="1.0" encoding="UTF-8" standalone="no" ?><Response Operation="set"><Status>Error</Status><message>Session_Time_Out</message></Response>';
                error_log($test, 0);
                return $test;
            }
            else if($ret == 255)
            {
                $test='<?xml version="1.0" encoding="UTF-8" standalone="no" ?><Response Operation="set"><Status>Error</Status><message>Exception_occurred</message></Response>';
                error_log($test, 0);
                return $test;
            }

            $test=$rsp->getResponse();
            //error_log("\nPHP Response is: \n". $test. "\n\n", 0);

            return  $test; //  "Test" ; //$test;
        }
        else
        {
            $test='<?xml version="1.0" encoding="UTF-8" standalone="no" ?><Response Operation="set"><Status>Error</Status><message>Exception_occurred</message></Response>';
            error_log($test, 0);
            return $test;
        }
    }
    catch(Exception $e)
    {
        $test='<?xml version="1.0" encoding="UTF-8" standalone="no" ?><Response Operation="set"><Status>Error</Status><message>Exception_occurred</message></Response>';
error_log("Caught exception: '{e->getMessage()}' in "
. "{e->getFile()}({e->getLine()})\n"
. "{e->getTraceAsString()}", 0);

return $test;
}
}

/*
* ASC_LogoffAsc
*
*/
function ASC_LogoffAsc()
{
try
{


$sess=0;
$sess=check_valid_session();
if(($sess == -51) || ($sess ==  -31))
{
error_log("\nPHP sess Error is: \n" . $sess, 0);
$test='<?xml version="1.0" encoding="UTF-8" standalone="no" ?><Response Operation="get">
  <Status>Error</Status>
  <message>Invalid_Session</message>
</Response>';


error_log($test, 0);
return $test;
}
else if($sess == -70)
{
error_log("\nPHP sess Error is: \n" . $sess, 0);
$test='<?xml version="1.0" encoding="UTF-8" standalone="no" ?><Response Operation="get">
  <Status>Error</Status>
  <message>Exception_occurred</message>
</Response>';
error_log($test, 0);
return $test;
}
$sess=$_SESSION["IASC_Session_ID"];
error_log("\nPHP Request logoff: \n", 0);
$ret=LogoffAsc($sess);
error_log("\logoff ret:" . $ret. "\n",   0);

session_unset ();
session_destroy ();
return $ret;
}
catch(Exception $e)
{
$test='<?xml version="1.0" encoding="UTF-8" standalone="no" ?><Response Operation="set"><Status>Error</Status><message>Exception_occurred</message></Response>';
        error_log("Caught exception: '{e->getMessage()}' in "
            . "{e->getFile()}({e->getLine()})\n"
             . "{e->getTraceAsString()}", 0);
        
        return $test;
    }
}

?>
