/******************************************************************************
 *
 *                   INTEL CORPORATION PROPRIETARY INFORMATION
 *       This software is supplied under the terms of a license agreement or
 *       nondisclosure agreement with Intel Corporation and may not be copied
 *       or disclosed except in accordance with the terms of that agreement.
 *
 *            Copyright (c) 2008-2009 Intel Corporation. All Rights Reserved.
 *
 *       All rights reserved.  No part of this program or publication may be
 *       reproduced, transmitted, transcribed, stored in a retrieval system,
 *       or translated into any language or computer language, in any form or
 *       by any means, electronic, mechanical, magnetic, optical, chemical,
 *       manual, or otherwise, without the prior written permission of Intel
 *       Corporation.
 *
 *
 *******************************************************************************/

#ifndef _CACHERIVER_CAPSULE_INT_FILE_H_
#define _CACHERIVER_CAPSULE_INT_FILE_H_

#include <os/include/cr_osal.h>
#include <modules/bmc/update/UpdateCallBackBase.h>

namespace Module
{
namespace FileParser
{
typedef enum BIOS_UPDATE_OPTIONS
{
    BIOS_UPDATE_START = 1,
    BIOS_UPDATE_SHOW_VERSION = (1 << 2),
    BIOS_UPDATE_DIRECT_UPDATE = (1 << 3),
    BIOS_UPDATE_NO_PLATFORM_CHECK = (1 << 4),
    BIOS_UPDATE_NO_DOWN_REVISION = (1 << 5),
    BIOS_UPDATE_RESTORE_DEFAULT = (1 << 6),
    BIOS_UPDATE_SIGNED = (1 << 7),
    BIOS_UPDATE_OEM_AREA = (1 << 8),
    ME_UPDATE_START = (1 << 9),
    UNLOCK_FLASH_DESCR = (1 << 10),
}BIOS_UPDATE_OPTIONS;

typedef enum BIOS_UPDATE_REGIONS
{
    REGION_FLASH_DESCRIPTOR = 1,
    REGION_BIOS = (1 << 1),
    REGION_MANAGEMENT_ENGINE = (1 << 2),
    REGION_GIGABIT_ETHERNET = (1 << 3),
    REGION_PLATFORM_DATA = (1 << 4),
    REGION_DEVICE_EXPANSION = (1 << 5),
    REGION_SECONDARY_BIOS = (1 << 6),
    REGION_UCODE_PATCH = (1 << 7),
    REGION_EMBEDDED_CONTROLLER = (1 << 8),
    REGION_INNOVATION_ENGINE = (1 << 10),
    REGION_10_GBE_REGION_1 = (1 << 11),
    REGION_10_GBE_REGION_2 = (1 << 12),
    REGION_UPDATE_ALL = 0xFFFFFFFF,
}BIOS_UPDATE_REGIONS;

typedef class CapsuleFileInt {
public:

    CapsuleFileInt(STRING fileName,
                   UINT32 bios_update_flags = BIOS_UPDATE_START, STRING PassThroughSwitches = "", UINT32 region_flags = REGION_UPDATE_ALL)
    {
        capsuleFileName = fileName;
        flags = bios_update_flags;
        ptrCallBackBase = NULL;
        UpdateSwitches = PassThroughSwitches;
        regionFlags = region_flags; // Defined is 0xFF, means want to update all of regions
    }

    STRING getCapsuleFileName(void)
    {
        return capsuleFileName;
    }
    UINT32 getBiosUpdateFlags(void)
    {
        return flags;
    }
    STRING getBiosUpdateSwitches(void)
    {
        return UpdateSwitches;
    }
    void setCallBackClass(Module::Update::UpdateCallBackBase* ptrCallBackBase)
    {
        this->ptrCallBackBase = ptrCallBackBase;
    }
    Module::Update::UpdateCallBackBase* getCallBackClass(void) const
    {
        return this->ptrCallBackBase;
    }
    UINT32 getUpdateRegionFlags(void)
    {
        return regionFlags;
    }

private:
    STRING capsuleFileName;
    UINT32 flags;
    UINT32 regionFlags;
    STRING UpdateSwitches;
    Module::Update::UpdateCallBackBase* ptrCallBackBase;
} CapsuleFileInt;
}    //end of namespace FileParser
} //end of namespace Module
#endif //_CACHERIVER_CAPSULE_INT_FILE_H_
