/******************************************************************************
 *
 *                   INTEL CORPORATION PROPRIETARY INFORMATION
 *       This software is supplied under the terms of a license agreement or
 *       nondisclosure agreement with Intel Corporation and may not be copied
 *       or disclosed except in accordance with the terms of that agreement.
 *
 *            Copyright (c) 2008-2009 Intel Corporation. All Rights Reserved.
 *
 *       All rights reserved.  No part of this program or publication may be
 *       reproduced, transmitted, transcribed, stored in a retrieval system,
 *       or translated into any language or computer language, in any form or
 *       by any means, electronic, mechanical, magnetic, optical, chemical,
 *       manual, or otherwise, without the prior written permission of Intel
 *       Corporation.
 *
 *
 *******************************************************************************/
#ifndef __CR_AUTO_PTR_H_
#define __CR_AUTO_PTR_H_

namespace osal_stl {
template<class T>
class cr_auto_ptr {
public:
    typedef T element_type;
    typedef element_type*   pointer;
    typedef element_type&   reference;

//Copy constructor
    cr_auto_ptr(const cr_auto_ptr& aPtr)
    {
        ptr = aPtr.ptr;

        if(aPtr.ptr != (pointer)0)
        {
            delete aPtr.ptr;
            aPtr.ptr = (pointer)0;
        }
    }

//Constructs an object of class auto_ptr<T>, initializing the held pointer to p,
//and acquiring ownership of that pointer. p must point to an object of class T,
//a class derived from T for which delete p is defined and accessible, or p must
//be a null pointer.
    cr_auto_ptr (pointer p = (pointer)0)
    {
        ptr = p;
    }


//Destructor
    ~cr_auto_ptr()
    {
        if(ptr != (pointer)0)
        {
            delete ptr;
            ptr = (pointer)0;
        }
    }

//Copies the argument a to *this. If a owned the underlying pointer,
//then *this becomes the new owner of that pointer. If *this already
//owned a pointer, that pointer is deleted first. The argument a is reset to zero.
    cr_auto_ptr& operator=(cr_auto_ptr& aPtr)
    {
        if(ptr != (pointer)0)
        {
            delete ptr;
        }

        ptr = aPtr.ptr;

        aPtr.ptr = (pointer)0;

        return *this;
    }

/*Returns the underlying pointer.*/
    inline pointer
    get() const
    {
        return ptr;
    }

/*Returns a reference to the object to which the underlying pointer points.*/
    inline reference
    operator*() const
    {
        return *ptr;
    }

/*Returns the underlying pointer.*/
    inline pointer
    operator->() const
    {
        return get();
    }

//Releases ownership of the underlying pointer and returns that pointer.
//The *this object is left holding a null pointer.
    inline pointer
    release(void)
    {
        pointer tmpPtr = ptr;

        ptr = (pointer)0;
        return tmpPtr;
    }

/*Sets the underlying pointer to p. If non-null, deletes the old underlying pointer.*/
    inline void
    reset(pointer p = 0)
    {
        if(ptr != (pointer)0)
        {
            delete ptr;
        }

        ptr = p;
    }

protected:

    pointer ptr;
};
} //end of namespace osal_stl
#endif //__CR_AUTO_PTR_H_