/******************************************************************************
 *
 *                   INTEL CORPORATION PROPRIETARY INFORMATION
 *       This software is supplied under the terms of a license agreement or
 *       nondisclosure agreement with Intel Corporation and may not be copied
 *       or disclosed except in accordance with the terms of that agreement.
 *
 *            Copyright (c) 2008-2009 Intel Corporation. All Rights Reserved.
 *
 *       All rights reserved.  No part of this program or publication may be
 *       reproduced, transmitted, transcribed, stored in a retrieval system,
 *       or translated into any language or computer language, in any form or
 *       by any means, electronic, mechanical, magnetic, optical, chemical,
 *       manual, or otherwise, without the prior written permission of Intel
 *       Corporation.
 *
 *
 *******************************************************************************/


#ifndef _CACHERIVER_SUPERCAPSULE_GENERATOR_H_
#define _CACHERIVER_SUPERCAPSULE_GENERATOR_H_

#include <os/include/cr_osal.h>


namespace Module
{
namespace FileParser
{
typedef enum _SUPER_CAP_OPTIONS
{
    ENCRYPT_FILE,
    DECRYPT_FILE,
    PATCH_SUPER_CAPSULE
}SUPER_CAP_OPTIONS;

typedef struct
{
    STRING input_file;
    STRING output_file;
    SUPER_CAP_OPTIONS options;
}SUPER_CAPSULE_UPDATE_OPTIONS;

class CLASSINDLL_CLASS_DECL SuperCapsuleGenerator
{
public:
    SuperCapsuleGenerator()
    {
    };
    ~SuperCapsuleGenerator()
    {
    };

    int CreateSuperCapsule(SUPER_CAPSULE_UPDATE_OPTIONS sup_options);
    STRING ExecuteGetQuery(STRING xQuery);
    int PatchSuperCapsule(STRING ifname, STRING &ofname);
    int DecryptIniFile(STRING iniFileName, STRING &outfile_name);
    int EncryptIniFile(STRING iniFileName, STRING &outfile_name);
private:
//utility functions
    STRING file_name;
    int Read_BIOSRegion(UINT8 *buff, UINT32 buff_size, UINT32 base_addr);
    void CalculateMD5Hash(char *buff, size_t buff_size, unsigned char *digest);
};
}
}
#endif