/******************************************************************************
 *
 *                   INTEL CORPORATION PROPRIETARY INFORMATION
 *       This software is supplied under the terms of a license agreement or
 *       nondisclosure agreement with Intel Corporation and may not be copied
 *       or disclosed except in accordance with the terms of that agreement.
 *
 *            Copyright (c) 2008-2009 Intel Corporation. All Rights Reserved.
 *
 *       All rights reserved.  No part of this program or publication may be
 *       reproduced, transmitted, transcribed, stored in a retrieval system,
 *       or translated into any language or computer language, in any form or
 *       by any means, electronic, mechanical, magnetic, optical, chemical,
 *       manual, or otherwise, without the prior written permission of Intel
 *       Corporation.
 *
 *
 *******************************************************************************/
#ifndef __CR_OSAL_LINUX_H_
#define __CR_OSAL_LINUX_H_

#ifdef CR_LINUX
#include <signal.h>
#include <termios.h>
#include <unistd.h>
#include <memory>
#include <assert.h>  // rajneesh

#include <os/include/linux/cr_osal_types.h>

#include <os/include/linux/cr_osal_string.h>

#include <os/include/linux/cr_osal_vector.h>

#include <os/include/linux/cr_osal_map.h>

#include <os/include/linux/cr_osal_hash_map.h>

#include <os/include/linux/cr_osal_list.h>

#include <os/include/linux/cr_osal_dll_types.h>

#include <stdio.h>

static inline void cr_osal_sleep(int nSeconds)
{
    sleep(nSeconds);
}

/* Used to save terminal settings */
extern termios g_savedTermIO;

static inline void enable_cntrl_c(void)
{
    struct sigaction sa = { 0 };

    sa.sa_handler = SIG_DFL;
    sigaction(SIGINT, &sa, NULL);
    sigaction(SIGQUIT, &sa, NULL);

    /* Restore the old settings back */
    tcsetattr(0, TCSANOW, &g_savedTermIO);
    setvbuf(stdout, NULL, _IOLBF, 0);
}

static inline void disable_cntrl_c(void)
{
    struct sigaction sa = { 0 };

    sa.sa_handler = SIG_IGN;
    sigaction(SIGINT, &sa, NULL);
    sigaction(SIGQUIT, &sa, NULL);

    /* Now set the terminal to ignore CNTRL-Z */
    termios newTermIO;

    /* Get the old terminal settings */
    tcgetattr(0, &g_savedTermIO);

    newTermIO = g_savedTermIO;

    /* Set the terminal to no echo and non-canonical input */
    /* This supresses cntrl-Z */
    newTermIO.c_lflag = 0;

    /* dont use the intercharacter timer */
    newTermIO.c_cc[VTIME] = 0;

    /* Return after one key press */
    newTermIO.c_cc[VMIN] = 1;

    tcsetattr(0, TCSANOW, &newTermIO);
    /* Set the stdout to Non-Buffered mode */
    setvbuf(stdout, NULL, _IONBF, 0);
}
#endif //#ifdef CR_LINUX
#endif //__CR_OSAL_LINUX_H_
