/******************************************************************************
 *
 *                   INTEL CORPORATION PROPRIETARY INFORMATION
 *       This software is supplied under the terms of a license agreement or
 *       nondisclosure agreement with Intel Corporation and may not be copied
 *       or disclosed except in accordance with the terms of that agreement.
 *
 *            Copyright (c) 2008-2009 Intel Corporation. All Rights Reserved.
 *
 *       All rights reserved.  No part of this program or publication may be
 *       reproduced, transmitted, transcribed, stored in a retrieval system,
 *       or translated into any language or computer language, in any form or
 *       by any means, electronic, mechanical, magnetic, optical, chemical,
 *       manual, or otherwise, without the prior written permission of Intel
 *       Corporation.
 *
 *
 *******************************************************************************/
#ifndef __CR_OSAL_WINDOWS_H_
#define __CR_OSAL_WINDOWS_H_

#ifdef CR_WINDOWS

#include <os/include/windows/cr_osal_types.h>

#include <os/include/windows/cr_osal_string.h>

#include <os/include/windows/cr_osal_vector.h>

#include <os/include/windows/cr_osal_map.h>

#include <os/include/windows/cr_osal_hash_map.h>

#include <os/include/windows/cr_osal_list.h>

#include <os/include/windows/cr_osal_dll_types.h>

static inline void cr_osal_sleep(int nSeconds)
{
    clock_t goal = nSeconds * CLOCKS_PER_SEC + clock();

    while(goal > clock())
        ;
}

static inline bool CtrlHandler(DWORD fwdCtrlType)
{
    switch(fwdCtrlType)
    {
    case CTRL_C_EVENT: //FALL THRU
    case CTRL_BREAK_EVENT:
        return true;

    default:
        return false;
    }
}

static inline void enable_cntrl_c(void)
{
    SetConsoleCtrlHandler((PHANDLER_ROUTINE)CtrlHandler, false);
}

static inline void disable_cntrl_c(void)
{
    SetConsoleCtrlHandler((PHANDLER_ROUTINE)CtrlHandler, true);
}
#endif //#ifdef CR_WINDOWS
#endif //ifndef __CR_OSAL_WINDOWS_H_
