@echo off 
cls
pushd "%~dp0%"

if exist fail.log Del fail.log /q
if exist pass.log Del pass.log /q
if exist version.txt Del version.txt /q

SET FW=25

rem *************************************************
rem Enable Controller
rem *************************************************
:Enable
echo Activating controller...
timeout 3
rem ControllerForcePower.exe 1
cd gpio_B11
call 1.bat
cd..
cls
rem *************************************************
rem Set Controller ID
rem *************************************************
rem timeout 3
rem FwUpdateCmd.exe enumcontrollers >controller.txt

find /i controller.txt "Error" 
if "%errorlevel%" == "0" goto Enable
echo Get controller information
timeout 3
set /p controller= <controller.txt


rem *************************************************
rem Check FW
rem *************************************************
echo Comparing controller firmware version
rem timeout 3
FwUpdateCmd.exe GetcurrentNvmVersion "%controller%" >version.txt

rem *************************************************
rem Disable Controller
rem *************************************************
rem timeout 1
rem ControllerForcePower.exe 0 
cd gpio_B11
call 0.bat
cd..
cls
find "%FW%" version.txt
if errorlevel 1 goto fail
goto end

:fail
echo check thunderbolt fw fail > fail.log
echo Update failed.
pause 
popd
exit 255

:End
echo check thunderbolt fw pass > pass.log
echo Update succeed.
pause 
popd
exit 0
