#ifndef __MVNC_H_INCLUDED__
#define __MVNC_H_INCLUDED__

#define MVNC_MAXNAMESIZE 28
typedef enum {
	MVNC_OK = 0,
	MVNC_BUSY = -1,
	MVNC_ERROR = -2,
	MVNC_OUT_OF_MEMORY = -3,
	MVNC_DEVICE_NOT_FOUND = -4,
	MVNC_INVALID_PARAMETERS = -5,
	MVNC_TIMEOUT = -6,
	MVNC_MVCMDNOTFOUND = -7,
	MVNC_NODATA = -8,
	MVNC_GONE = -9,
	MVNC_UNSUPPORTEDGRAPHFILE = -10
} mvncStatus;

enum GraphOptions {
	MVNC_ITERATIONS = 0,	// Number of iterations per inference, int, normally 1, for debugging
	MVNC_NETWORK_THROTTLE = 1,	// Measure temperature once per inference instead of once per layer, int
	MVNC_DONTBLOCK = 2,	// LoadTensor will return BUSY instead of blocking, GetResult will return NODATA, int
	MVNC_TIMETAKEN = 1000,	// Return time taken for inference (float *)
	MVNC_DEBUGINFO = 1001	// Return debug info, string
};

enum DeviceOptions {
	MVNC_LOGLEVEL = 0,	// Log level, int, 0 = nothing, 1 = errors, 2 = verbose
	MVNC_TEMP_LIM_LOWER = 1,	// Temperature for short sleep, float
	MVNC_TEMP_LIM_HIGHER = 2,	// Temperature for long sleep, float
	MVNC_BACKOFF_TIME_NORMAL = 3,	// Normal sleep in ms, int
	MVNC_BACKOFF_TIME_HIGH = 4,	// Short sleep in ms, int
	MVNC_BACKOFF_TIME_CRITICAL = 5,	// Long sleep in ms, int
	MVNC_TEMPERATURE_DEBUG = 6,	// Stop on critical temperature, int
	MVNC_THERMALSTATS = 1000,	// Return temperatures, float *
	MVNC_OPTIMISATIONLIST = 1001	// Return optimisations list, char *
};

mvncStatus mvncGetDeviceName(int index, char *name, unsigned int nameSize);
mvncStatus mvncOpenDevice(const char *name, void **deviceHandle);
mvncStatus mvncCloseDevice(void *deviceHandle);
mvncStatus mvncAllocateGraph(void *deviceHandle, void **graphHandle, const void *graphFile, unsigned int graphFileLength);
mvncStatus mvncDeallocateGraph(void *graphHandle);
mvncStatus mvncSetGraphOption(void *graphHandle, int option, const void *data, unsigned int datalength);
mvncStatus mvncGetGraphOption(void *graphHandle, int option, void **data, unsigned int *datalength);
mvncStatus mvncSetDeviceOption(void *deviceHandle, int option, const void *data, unsigned int datalength);
mvncStatus mvncGetDeviceOption(void *deviceHandle, int option, void **data, unsigned int *datalength);
mvncStatus mvncLoadTensor(void *graphHandle, const void *inputTensor, unsigned int inputTensorLength, void *userParam);
mvncStatus mvncGetResult(void *graphHandle, void **outputData, unsigned int *outputDataLength, void **userParam);

#endif
