import numpy

class AlexSmallNetwork:
  """ Class representing a graph
  """
  def __init__(self):
    self.network_dir = "/usr/share/mvnc/networks/alex-small/"
    #Load preprocessing data
    with open(self.network_dir + '/stat.txt', 'r') as f:
        self.mean = f.readline().split()
        self.std = f.readline().split()
        for i in range(3):
                self.mean[i] = 255 * float(self.mean[i])
                self.std[i] = 1 / (255 * float(self.std[i]))
    #Load categories
    self.categories = []
    with open(self.network_dir + '/categories.txt', 'r') as f:
        for line in f:
                cat = line.split(',')[0].split('\n')[0]
                if cat != 'classes':
                        self.categories.append(cat)
        f.close()
        print('Number of categories:', len(self.categories))


  def rawinputformat(self):
    """ returns a tuple of (width, height, format)
    describing the input format before preprocessing
    """
    return (224, 224,"RGB")

  def get_graph_binary(self):
    """ returns the graph binary
    """
    with open(self.network_dir + "blob", mode='rb') as file:
      blob = file.read()
    return blob

  def preprocess(self, data):
    """ preprocess a video frame
    input - in the format specified by rawinputformat() method
    output - in the format required by the graph
    """
    (w,h,f) = self.rawinputformat()
    dt = numpy.dtype(numpy.uint8)
    nb = numpy.frombuffer(data,dt,-1,0)
    nb = nb.reshape((w,h,3))
    img = nb.astype('float32')
    #Preprocess image
    for i in range(3):
        img[:,:,i] = (img[:,:,i] - self.mean[i]) * self.std[i]
    return img.astype(numpy.float16)

  def postprocess(self,output):
    """ postprocess an inference result
    input - in the format produced by the graph
    output - in a human readable format
    """
    order = output.argsort()
    last = len(self.categories)-1
    text = ''
    for i in range(min(5, last+1)):
        text += self.categories[order[last-i]] + ' (' + '{0:.2f}'.format(output[order[last-i]]*100) + '%) '
    return text
