import numpy

class FathomNetwork:
  """ Class representing a graph
  """
  def rawinputformat(self):
    """ returns a tuple of (width, height, format)
    describing the input format before preprocessing
    """
    return (832, 720,"RGB")

  def get_graph_binary(self):
    """ returns the graph binary
    """
    with open("Fathom.blob", mode='rb') as file:
      blob = file.read()
    return blob

  def preprocess(self, data):
    """ preprocess a video frame
    input - in the format specified by rawinputformat() method
    output - in the format required by the graph
    """
    (w,h,f) = self.rawinputformat()
    dt = numpy.dtype(numpy.uint8)
    nb = numpy.frombuffer(data,dt,-1,0)
    nb = nb.reshape((w,h,3))
    nb = nb.astype('float16')
    return nb

  def postprocess(self,out):
    """ postprocess an inference result
    input - in the format produced by the graph
    output - in a human readable format
    """
    return out
