from gi.repository import Gtk

class GtkPreviewSink(Gtk.DrawingArea):
  """ GTK DrawingArea with Gstreamer sink
  """
  def __init__(self,name):
    """ name - name of the gstreamer element
    """
    super().__init__()
    self.set_double_buffered(True)
    self.name = name

  def get_launch(self):
    """ get Gstreamer launch string fragment for the sink
    """
    return "\
    queue max-size-buffers=2 leaky=downstream ! \
    xvimagesink name=%s" % self.name

  def set_pipeline(self,pipeline):
    """ set associated Gstreamer pipeline
    """
    self.pipeline = pipeline

  def realize(self):      # TODO: implement proper widget subclassing or 'prepare-window-handle' signal handler
    self.pipeline.get_by_name(self.name).set_window_handle(self.get_window().get_xid())

class OutputWidget(Gtk.Label):
  """ a GtkLabel which displays results from Fathom Inference
  """
  def __init__(self):
    super().__init__()
    self.set_text("-")

  def put_output(self, userobj, out):
    """ Method for receiving the (postprocessed) results
    userobj - user object passed to the FathomExpress
    out - output
    """
    self.set_text("%s: %s\n" % (userobj, out) )

class CountingOutputWidget(Gtk.Label):
  """ a GtkLabel which displays results from Fathom Inference
  and terminates the app after a number of frames processed
  """
  def __init__(self, stop_at_frames):
    super().__init__()
    self.set_text("-")
    self.stop_at_frames = stop_at_frames
    self.frames = 0

  def put_output(self, userobj, out):
    self.frames = self.frames + 1
    if self.frames < self.stop_at_frames:
      print("output: %s: %s\n" % (userobj, out) )
      self.set_text("%s: %s\n" % (userobj, out) )
    else:
      Gtk.main_quit ()
