import os

class VideoSource:
  """ base class for video sources
  """
  def get_launch(self):
    """ get launch string fragment for this video source
    """
    pass

class TestSource(VideoSource):
  def get_launch(self):
    return "videotestsrc"

class BillSource(VideoSource):
  def get_launch(self):
    return 'multifilesrc location="/usr/share/mvnc/pictures/bill224.jpg" index=0 caps="image/jpeg,framerate=(fraction)12/1" ! jpegdec '

class UsbSource(VideoSource):
  def get_launch(self):
    return "v4l2src"

class UsbSource45(VideoSource):
  def get_launch(self):
    return "v4l2src device=/dev/video45"

class UsbSourceAuto(VideoSource):
  def get_launch(self):
    return "v4l2src device=%s" % os.popen("for a in /sys/class/video4linux/video*; do readlink -e $a/device/subsystem/ | grep -q /sys/bus/usb && udevadm info -rq name $a; done").read().strip()

class MipiSource5MP(VideoSource):
  def get_launch(self):
    return "icamerasrc device-name=1 io-mode=1 ! \
    video/x-raw,format=NV12,width=640,height=480 ! \
    videoconvert"

class MipiSource13MP(VideoSource):
  def get_launch(self):
    return "icamerasrc device-name=0 io-mode=1 ! \
    video/x-raw,format=NV12,width=640,height=480 ! \
    videoconvert"
