SUMMARY = "Intel ISH Calibration tools"
LICENSE = "Proprietary"
LIC_FILES_CHKSUM = "file://${COMMON_LICENSE_DIR}/Proprietary;md5=0557f9d92cf58f2ccdd50f62f8ac0b28"

SRC_URI = "file://${RPM_PATH}/${PV}.zip"

ALLOW_EMPTY_${PN} = "1"
PACKAGES += "${PN}-tracetools ${PN}-updatepdttool ${PN}-issu ${PN}-calibration"

do_patch[noexec] = "1"
do_configure[noexec] = "1"
do_compile[noexec] = "1"

addtask unpack2 after do_unpack before do_install
do_unpack2() {
        unzip ${WORKDIR}/SW.zip
}

do_install() {
        install -d ${D}${bindir}
        install -m 755 ${S}/TraceTools/ISSTraceCollector/Linux/ISSTraceCollector ${D}${bindir}
        install -m 755 ${S}/TraceTools/ISSTraceCollector/TraceCatalog.xml ${D}${bindir}
        install -m 755 ${S}/TraceTools/ISSTraceCollector/TraceComponents.xml ${D}${bindir}
        install -m 755 ${S}/TraceTools/TraceConfigTool/Linux/TraceConfigTool ${D}${bindir}
        install -m 755 ${S}/TraceTools/TraceConfigTool/config.xml ${D}${bindir}
        install -m 755 ${S}/UpdatePDTTool/Linux/UpdatePDTTool ${D}${bindir}
        install -m 755 ${S}/ISSU/Linux/ISSU ${D}${bindir}
        install -m 755 ${S}/Calibration/Linux/LinuxCalibrationTool ${D}${bindir}
        install -m 755 ${S}/Calibration/Linux/TestingConfig.xml ${D}${bindir}
}

FILES_${PN} = ""
FILES_${PN}-tracetools = " \
                           ${bindir}/ISSTraceCollector \
                           ${bindir}/TraceConfigTool \
                           "

FILES_${PN}-updatepdttool = "${bindir}/UpdatePDTTool"

FILES_${PN}-issu = "${bindir}/ISSU"

FILES_${PN}-calibration = " \
                            ${bindir}/LinuxCalibrationTool \
                            ${bindir}/*.xml \
                            "
