/******************************************************************************
 *
 *                   INTEL CORPORATION PROPRIETARY INFORMATION
 *       This software is supplied under the terms of a license agreement or
 *       nondisclosure agreement with Intel Corporation and may not be copied
 *       or disclosed except in accordance with the terms of that agreement.
 *
 *            Copyright (c) 2008-2009 Intel Corporation. All Rights Reserved.
 *
 *       All rights reserved.  No part of this program or publication may be
 *       reproduced, transmitted, transcribed, stored in a retrieval system,
 *       or translated into any language or computer language, in any form or
 *       by any means, electronic, mechanical, magnetic, optical, chemical,
 *       manual, or otherwise, without the prior written permission of Intel
 *       Corporation.
 *
 *
 *******************************************************************************/
#ifndef __UPDATECALLBACKBASE_H_
#define __UPDATECALLBACKBASE_H_

#include <os/include/cr_osal.h>

namespace Module
{
namespace Update
{
typedef enum UpdateCallBackType
{
    UPDATE_CALLBACK_BEGIN = 0,
    UPDATE_CALLBACK_DISPLAY_MSG,
    UPDATE_CALLBACK_DISPLAY_ERROR,
    UPDATE_CALLBACK_DISPLAY_PERCENT,
    //To display the SDR or FRU Record number
    UPDATE_CALLBACK_DISPLAY_RECORD,
    UPDATE_CALLBACK_DISPLAY_MENU,
    UPDATE_CALLBACK_GET_INPUT,
    UPDATE_CALLBACK_DISPLAY_PROMPT,
    UPDATE_CALLBACK_SELECT_PROMPT,
    UPDATE_CALLBACK_GET_FRUFIELD,
    //To display status of BIOS & BMC update in parallel
    UPDATE_CALLBACK_INIT_DISPLAY_BOX,
    UPDATE_CALLBACK_DEINIT_DISPLAY_BOX,
    UPDATE_CALLBACK_REFRESH_DISPLAY_BOX,
    UPDATE_CALLBACK_END
} UpdateCallBackType;

//Structure to store the MenuTitle and Menu Options from CFG File
#define MAX_MENU_LENGTH 1024
#define MAX_NUMBER_OF_MENU_OPTIONS 50

typedef struct _CFG_MENU_TAG
{
    char Menu_Title[MAX_MENU_LENGTH];
    char MenuOptions[MAX_NUMBER_OF_MENU_OPTIONS][MAX_MENU_LENGTH];
    int MaxMenu;
#ifdef CR_EFI
    /* default constructor */
    _CFG_MENU_TAG()
    {
        memset(Menu_Title, 0, MAX_MENU_LENGTH);
        for(int i = 0; i < MAX_NUMBER_OF_MENU_OPTIONS; i++)
        {
            memset(MenuOptions[i], 0, MAX_MENU_LENGTH);
        }
    }
#endif
}CFG_MENU_TAG;

/*
    Display Sample of callback like as below.

    Area 1 Title  |Area 2 Title  |Area 3 Title
    Area 1 Msg    |Area 2 Msg    |Area 3 Msg

*/
#define MAX_LINE_STRING_LEN 80
#define DIPSLAY_AREA_SEPARATOR L" | "
typedef struct _DISPLAY_BOX_AREA
{
    UINT8 id;       // The index of area
    UINT8 start;    // The message start offset within the line
    UINT8 end;      // The message end offset within the line
    WSTRING msg;    // The message string of area

    _DISPLAY_BOX_AREA()
    {
        id = 0;
        start = 0;
        end = 0;
    }
}DISPLAY_BOX_AREA;
TYPEDEF_VECTOROF(DISPLAY_BOX_AREA, DISPLAY_BOX_AREA_ARRAY);
typedef class _UPDATE_CALLBACK_DISPLAY_BOX
{
public:
    _UPDATE_CALLBACK_DISPLAY_BOX(){};
    ~_UPDATE_CALLBACK_DISPLAY_BOX(){};

    /*
        Add an area in display box
        Args:
            title - The title string of area, will be showed in the first line
            areaSize - The length of message string what will be showed in the area
        Ret:
            The index of new area in the box
    */
    UINT8 AddArea(WSTRING title, UINT8 areaSize)
    {
        UINT8 curEnd = 0;
        DISPLAY_BOX_AREA area;

        if (m_areas.size() > 0)
        {
            area.id = m_areas.size();
            area.start = m_areas[m_areas.size()-1].end + wcslen(DIPSLAY_AREA_SEPARATOR);
            if (area.start >= MAX_LINE_STRING_LEN)
            {
                area.start = m_areas[m_areas.size()-1].end;
                area.end = area.start;
                m_areas.push_back(area);
                return area.id;
            }
            if (areaSize > MAX_LINE_STRING_LEN-area.start)
               areaSize = MAX_LINE_STRING_LEN - area.start;
            area.end = area.start + areaSize;
            m_areas.push_back(area);
            if (title.length() > areaSize)
            {
                title = title.substr(0, areaSize);
            }
            m_title += WSTRING(DIPSLAY_AREA_SEPARATOR);
            m_title += title;
            m_title.resize(area.end, ' ');
        }
        else
        {
            area.id = 0;
            area.start = 0;
            if (areaSize > MAX_LINE_STRING_LEN)
               areaSize = MAX_LINE_STRING_LEN;
            area.end = areaSize;
            m_areas.push_back(area);
            if (title.length() > areaSize)
            {
                title = title.substr(0, areaSize);
            }
            m_title = title;
            m_title.resize(areaSize, ' ');
        }
        return area.id;
    }

    /* 
        Set the message string of area by its index
        Args:
            id - The index of area in the box
            msg - The message string will be showed
        Ret:
            Be successful or not
    */  
    bool SetAreaMessage(UINT8 id, WSTRING msg)
    {
        UINT8 size = 0;

        if (id >= m_areas.size())
            return false;

        size = m_areas[id].end - m_areas[id].start;
        if (msg.length() > size)
            msg = msg.substr(0, size);
        m_areas[id].msg = msg;

        return true;
    }

    /* 
        Get the title string what combine all the title of areas
        Args:
        Ret:
            The string of title
    */ 
    WSTRING GetBoxTitle(void)
    {
        return WSTRING(L"\n") + m_title + WSTRING(L"\n");
    }

    /* 
        Get the message string what combine all the message of areas
        Args:
        Ret:
            The string of message
    */ 
    WSTRING GetBoxMessage(void)
    {
        WSTRING msg = L"";
        UINT8 i = 0;

        if (m_areas.size() < 1)
            return msg;
        msg += m_areas[0].msg;
        msg.resize(m_areas[0].end, ' ');
        for (i=1; i<m_areas.size(); i++)
        {
            msg += WSTRING(DIPSLAY_AREA_SEPARATOR);
            msg += m_areas[i].msg;
            msg.resize(m_areas[i].end, ' ');
        }
        return WSTRING(L"\r") + msg;
    }
private:
    DISPLAY_BOX_AREA_ARRAY m_areas;
    WSTRING m_title;
}UPDATE_CALLBACK_DISPLAY_BOX;

typedef struct _CFG_CALLBACK_CONTAINER
{
    // bug fix: CFG_MENU_TAG is too large to be in stack, change it to heap.
    //CFG_MENU_TAG sCfgMenu;
    CFG_MENU_TAG *pCfgMenu;
    WCHAR *wcDisplayMsg;
    bool bExitUpdate;
    WCHAR *wcUserInput;
    size_t iUserInputLength;

    _CFG_CALLBACK_CONTAINER()
    {
        pCfgMenu = new CFG_MENU_TAG;
        memset(pCfgMenu, 0, sizeof(CFG_MENU_TAG));
        wcDisplayMsg = NULL;
        wcUserInput = NULL;
        bExitUpdate = false;
        iUserInputLength = 0;
    };
    ~_CFG_CALLBACK_CONTAINER()
    {
        delete pCfgMenu;
    }
}CFG_CALLBACK_CONTAINER;


typedef class UpdateCallBackBase {
public:
    UpdateCallBackBase ()
    {
    }
//implement this virtual function to get the progress update of FW and BIOS update
    virtual void updateCallBack(UpdateCallBackType cbType, const WCHAR*, const UINTN, const UINTN)
    {
    }

//implement this virtual function to add the callback function to parse CFG file
    virtual void updateCallBack(UpdateCallBackType cbType, CFG_CALLBACK_CONTAINER *sCfgCallbackData)
    {
    }

//implement this virtual function to add the callback function to update BIOS & BMC in parallel
    virtual void updateCallBack(UpdateCallBackType cbType, UPDATE_CALLBACK_DISPLAY_BOX *sBoxCallbackData) {
    }

private:
} UpdateCallBackBase;
}    /* end of namespace Update */
} /* end of namespace Module */
#endif /* __UPDATECALLBACKBASE_H_ */
