/******************************************************************************
 *
 *                   INTEL CORPORATION PROPRIETARY INFORMATION
 *       This software is supplied under the terms of a license agreement or
 *       nondisclosure agreement with Intel Corporation and may not be copied
 *       or disclosed except in accordance with the terms of that agreement.
 *
 *            Copyright (c) 2008-2009 Intel Corporation. All Rights Reserved.
 *
 *       All rights reserved.  No part of this program or publication may be
 *       reproduced, transmitted, transcribed, stored in a retrieval system,
 *       or translated into any language or computer language, in any form or
 *       by any means, electronic, mechanical, magnetic, optical, chemical,
 *       manual, or otherwise, without the prior written permission of Intel
 *       Corporation.
 *
 *
 *******************************************************************************/
#ifndef __CR_OSAL_TYPES_H_
#define __CR_OSAL_TYPES_H_

#ifdef CR_WINDOWS

//Header Files
//#include <iostream> //removing iostream as we will use FILE * for file access.
#include <windows.h>
#include <direct.h>
#include <os/include/cr_malloc.h>
#include <stdio.h>
#include <time.h>


#ifndef SNPRINTF
#define SNPRINTF sprintf_s
#endif


#define cr_memcpy(dest, dest_size, source, count)              memcpy_s(dest, dest_size, source, count)
#define cr_wcscpy(dest, dest_size, source)                    wcscpy_s(dest, dest_size, source)
#define cr_strcpy(dest, dest_size, source)                    strncpy(dest, source, dest_size)
#define cr_vsnprintf(dest, dest_size, count, format, argptr)    vsnprintf_s(dest, dest_size, count, format, argptr)
#define cr_swprintf(_String, _Count, _Format, ...)          swprintf(_String, _Count, _Format, __VA_ARGS__)
#define cr_strncpy(_Dst, _DstSize, _Src, _MaxCount)     strncpy_s(_Dst, _DstSize, _Src, _MaxCount)
#define cr_mbstowcs(pReturnValue, wcstr, sizeInBytes, mbstr, count) mbstowcs_s(pReturnValue, wcstr, sizeInBytes, mbstr, count)

#ifndef SIZE_T_LONG
#define SIZE_T_LONG size_t
#endif

#ifndef ssize_t
#define ssize_t long
#endif

#ifndef snprintf
#define snprintf _snprintf
#endif

typedef unsigned long UINTN;


#ifdef _CLASSINDLL
#define CLASSINDLL_CLASS_DECL __declspec(dllexport)
#else
#define CLASSINDLL_CLASS_DECL __declspec(dllimport)
#endif


#define SNWPRINTF               _snwprintf
#define strcasecmp              _stricmp
#define strncasecmp             _strnicmp
#define wcscasecmp              _wcsicmp
#define wcsncasecmp             _wcsnicmp

#ifndef STRICMP
#define STRICMP _stricmp
#endif

#ifndef DllExport
#define DllExport __declspec(dllexport)
#endif

#ifndef CR_LOG_FILE
#define CR_LOG_FILE "%s\\root\\crlog\\CacheRiver-%d-%d-%d-%d-%d-%d-%d-%d.log"
#endif

static inline void makeCacheRiverLogDir(LPSECURITY_ATTRIBUTES lpSecAttrForCacheRiverLogs)
{
    //First get the systemdrive name.
    char *sysdrivevar;
    char logfiledir[500];
    WCHAR* wlogfiledir = new WCHAR[500];
    size_t len;

    // Get the value of the SystemDrive environment variable.
    errno_t err = _dupenv_s(&sysdrivevar, &len, "SystemDrive");

    _snprintf(logfiledir, 500, "%s\\\\root", sysdrivevar);
    //std::cout << logfiledir<<std::endl;

    mbstowcs(wlogfiledir, logfiledir, 500);
    CreateDirectoryW(wlogfiledir, lpSecAttrForCacheRiverLogs);

    _snprintf(logfiledir, 500, "%s\\\\root\\\\crlog", sysdrivevar);
    //std::cout << logfiledir<<std::endl;
    //_mkdir(logfiledir);
    mbstowcs(wlogfiledir, logfiledir, 500);
    CreateDirectoryW(wlogfiledir, lpSecAttrForCacheRiverLogs);
    delete [] wlogfiledir;
} //end of makeCacheRiverLogDir()
#endif //#ifdef CR_WINDOWS
#endif //ifndef __CR_OSAL_TYPES_H_
