#!/bin/sh

# snmpsubagentinstall.sh

if [ -f ../../../License.txt ]; then

   cat ../../../License.txt | more

elif [ -f ./license.txt ]; then

   cat ./license.txt | more

else

    echo -n "License not found.."

fi

reply=
while [[ $reply != "Y" && $reply != "y" && $reply != "N" && $reply != "n" ]]; do
    echo "Accept? (Y/N)"
    read reply
done
if [[ $reply = "N" || $reply = "n" ]]; then
  exit
fi

function addcronjob
{
         # start crond service - in case its not up by default
         if [ -e "/etc/SuSE-release" ]; then
            /etc/init.d/cron start 2> /dev/null 1 > /dev/null
         else
            /etc/init.d/crond start 2>&1 > /dev/null
         fi;
 
         crontab -l | grep -v "^#" |grep -v "snmpsa_watchdog.sh" > /tmp/__snmpsacronjoblist__
         echo "* * * * * /usr/local/snmpsa/snmpsa_watchdog.sh 2>&1 >/dev/null" >> /tmp/__snmpsacronjoblist__  
         crontab /tmp/__snmpsacronjoblist__
         rm -f /tmp/__snmpsacronjoblist__
}


# unalias following commands from any previous one

unalias echo 2>/dev/null
unalias grep 2>/dev/null
unalias chmod 2>/dev/null
unalias rpm 2>/dev/null
unalias uname 2>/dev/null

UNINSTALL_SNMP="NO"
INSTALL_SNMP="NO"

SNMP_SA=`rpm -q snmpsa-8*`
if [ $? -eq 0 ]; then
	echo "Another version of Intel(R) SNMP Subagent "${SNMP_SA}" already installed. Please uninstall it first by executing snmpsubagent_uninstall.sh "
	exit 1
fi

SNMP_SA=`rpm -q snmpsa-7*`
if [ $? -eq 0 ]; then
	echo "Another version of Intel(R) SNMP Subagent "${SNMP_SA}" already installed. Please uninstall it first by executing snmpsubagent_uninstall.sh "
	exit 1
fi

SNMP_SA=`rpm -q snmpsa-6*`
if [ $? -eq 0 ]; then
	echo "Another version of Intel(R) SNMP Subagent "${SNMP_SA}" already installed. Please uninstall it first by executing snmpsubagent_uninstall.sh "
	exit 1
fi

SNMP_SA=`rpm -q snmpsa-5*`
if [ $? -eq 0 ]; then
	echo "Another version of Intel(R) SNMP Subagent "${SNMP_SA}" already installed. Please uninstall it first by executing snmpsubagent_uninstall.sh "
	exit 1
fi

SNMP_SA=`rpm -q snmpsa-4.0-1`
if [ $? -eq 0 ]; then
	echo "Another version of Intel(R) SNMP Subagent "${SNMP_SA}" already installed. Please uninstall it first by executing snmpsubagent_uninstall.sh "
	exit 1
fi

SNMP_SA=`rpm -q snmpsa-2.0-1`
if [ $? -eq 0 ]; then
	echo "Another version of Intel(R) SNMP Subagent "${SNMP_SA}" already installed. Please uninstall it first by executing snmpsubagent_uninstall.sh "
	exit 1
fi

SNMP_SA=`rpm -q snmpsa-1.5-2`
if [ $? -eq 0 ]; then
	echo "Another version of Intel(R) SNMP Subagent "${SNMP_SA}" already installed. Please uninstall it first by executing snmpsubagent_uninstall.sh "
	exit 1
 fi

SNMP_SA=`rpm -q snmpsa-1.0-1`
if [ $? -eq 0 ]; then
	echo "Another version of Intel(R) SNMP Subagent "${SNMP_SA}" already installed. Please uninstall it first by executing snmpsubagent_uninstall.sh "
	exit 1
fi

echo "Installing Intel(R) SNMP Subagent..."
#checking OpenIPMI 
if [ -f "/etc/redhat-release" ]  
	then
	OSVER1=$(sed -n '/6.4/p' /etc/redhat-release)
	OSVER2=$(sed -n '/6.5/p' /etc/redhat-release)
	OSVER3=$(sed -n '/7.0/p' /etc/redhat-release)
	OSVER4=$(sed -n '/7.1/p' /etc/redhat-release)
        OSVER5=$(sed -n '/7.2/p' /etc/redhat-release)
        OSVER6=$(sed -n '/7.3/p' /etc/redhat-release)
	if [ "$OSVER1" == "Red Hat Enterprise Linux Server release 6.4 (Santiago)" ] || [ "$OSVER2" == "Red Hat Enterprise Linux Server release 6.5 (Santiago)" ] || [ "$OSVER3" == "Red Hat Enterprise Linux Server release 7.0 (Maipo)" ] || [ "$OSVER4" == "Red Hat Enterprise Linux Server release 7.1 (Maipo)" ] || [ "$OSVER5" == "Red Hat Enterprise Linux Server release 7.2 (Maipo)" ] || [ "$OSVER6" == "Red Hat Enterprise Linux Server release 7.3 Beta (Maipo)" ] || [ "$OSVER6" == "Red Hat Enterprise Linux Server release 7.3 (Maipo)" ];then
		echo "This is either linux Redhat 6.4 or linux Redhat 6.5 or Linux Redhat 7.0 or Linux Redhat 7.1 or Linux Redhat 7.2 or Linux Redhat 7.3"
		
	if [[ -e "/dev/ipmi0" ]]; then
		echo "SNMP-SA detected Linux IPMI driver in kernal already enable."
		break;
	else
		echo -e "Intel(R) SNMP-SA detected \033[31mLinux IPMI driver in kernel\033[0m not enable."
		echo -e "Enable \033[31mLinux IPMI driver\033[0m just type either \033[31m'modprobe ipmi_devintf or modprobe ipmi_si and modprobe ipmi_msghandler'\033[0m in Linux shell."
		echo -e "Installation will be terminate..."
		exit;
	fi
#else
#  echo "not Redhat 6.4"
	fi
fi

if [ -f "/etc/SuSE-release" ];  then
#	echo "This is SuSE UEFI aware OS"
        if [ -e "/proc/efi" ] || [ -e "/sys/firmware/efi" ]; then
		if [[ -e "/dev/ipmi0" ]]; then
			echo "SNMP-SA detected Linux IPMI driver in kernal already enable."
			break;
		else
			echo -e "Intel(R) SNMP-SA detected \033[31mLinux IPMI driver in kernel\033[0m not enable."
			echo -e "Enable \033[31mLinux IPMI driver\033[0m just type \033[31m'/etc/init.d/ipmi start'\033[0m in Linux shell."
			echo -e "Installation will be terminate..."
			exit;
		fi
        fi
fi

if [ -f "/etc/SuSE-release" ] ; then 
	## Check for SLES 10
	OSVer_10=$(grep "VERSION *= *10" /etc/SuSE-release)
	OSVer_11=$(grep "VERSION *= *11" /etc/SuSE-release)
	OSVer_12=$(grep "VERSION *= *12" /etc/SuSE-release)
	grep "VERSION *= *10" /etc/SuSE-release > /dev/null 2>&1
	if [ $? -eq 0 ]; then
		## Check whether OS net-snmp is installed.

		NET_SNMP=`rpm -q net-snmp`
		if [ $? -eq 1 ]; then
			echo "Intel(R) SNMP Subagent requires net-snmp package to be installed on the system."
			echo "Aborting installation of Intel(R) SNMP Subagent."
			exit 1		
		fi
	else
		## Check whether net-snmp is installed

		NET_SNMP=`rpm -q net-snmp`
		if [ $? -eq 1 ]; then
			echo "Intel(R) SNMP Subagent requires net-snmp package to be installed on the system."
			echo "Aborting installation of Intel(R) SNMP Subagent."
			exit 1		
		elif [[ $NET_SNMP != *isms* ]]; then
			## Get the first version numbers ex. 5.1.4
			NET_SNMP_VER=${NET_SNMP##net-snmp-}
			NET_SNMP_VER=${NET_SNMP_VER%%-*}
			NET_SNMP_VER_REL=${NET_SNMP_VER#5.1.}
			NET_SNMP_VER_REL=${NET_SNMP_VER_REL%.*}
		
			if [[ "${NET_SNMP_VER%.*}" == 5.1* ]] && [ "${NET_SNMP_VER_REL}" -le 4 ] || [ "${NET_SNMP_VER%.*}" = "5.0" ] ; then
				echo "Found net-snmp version "${NET_SNMP_VER}" on this system."
				echo "Intel(R) SNMP Subagent requires ISMS net-snmp version 5.1.4."
				echo -n "Would you like to uninstall the default net-snmp packages and install ISMS net-snmp 5.1.4 available with the Subagent? (Enter 'y' to continue or any other key to abort the installation of the Intel(R) SNMP Sub-Agent.) "

				read answer
				answer=`echo ${answer} | tr a-z A-Z `
				if [ "${answer}" = "Y" ]; then
					UNINSTALL_SNMP="YES"
					INSTALL_SNMP="YES"
				else
					echo "ISMS net-snmp 5.1.4 required for Intel(R) SNMP Subagent."
					echo "Aborting installation of Intel(R) SNMP Subagent."
					exit 1
				fi
			fi
		fi

		if [ "${UNINSTALL_SNMP}" = "YES" ]; then
			echo "Uninstalling, please wait..."
			INSTALL_SNMP="YES"
			if [ -f "/etc/SuSE-release" ]; then
				NET_SNMP_PERL=`rpm -q perl-SNMP`
				if [ $? -eq 0 ]; then
					rpm -e --nodeps ${NET_SNMP_PERL}
					echo "Uninstalled "${NET_SNMP_PERL}
				fi
			else
				NET_SNMP_PERL=`rpm -q net-snmp-perl`
				if [ $? -eq 0 ]; then
					rpm -e --nodeps ${NET_SNMP_PERL}
					echo "Uninstalled "${NET_SNMP_PERL}
				fi
			fi

			NET_SNMP_DEVEL=`rpm -q net-snmp-devel`
			if [ $? -eq 0 ]; then
				rpm -e --nodeps ${NET_SNMP_DEVEL}
				echo "Uninstalled "${NET_SNMP_DEVEL}
			fi
	
			NET_SNMP_UTILS=`rpm -q net-snmp-utils`
			if [ $? -eq 0 ]; then
				rpm -e --nodeps ${NET_SNMP_UTILS}
				echo "Uninstalled "${NET_SNMP_UTILS}
			fi

			NET_SNMP=`rpm -q net-snmp`
			if [ $? -eq 0 ]; then
				rpm -e --nodeps ${NET_SNMP}
				echo "Uninstalled "${NET_SNMP}
			fi

			NET_SNMP_LIBS=`rpm -q net-snmp-libs | sort -u`
			echo ${NET_SNMP_LIBS} | grep "not installed" > /dev/null 2>&1
			if [ $? -eq 1 ]; then
				rpm -e --nodeps --allmatches ${NET_SNMP_LIBS}
				echo "Uninstalled "${NET_SNMP_LIBS}
			fi
			echo
		fi

		if [ "${INSTALL_SNMP}" = "YES" ]; then
			echo "Installing ISMS net-snmp 5.1.4"
		
			uname -m | grep x86_64 > /dev/null 2>&1
			if [ $? -eq 0 ]; then
			
				rpm -ivh ./suse/x86_64/9.0/net-snmp/net-snmp-5.1.4-0.1.isms.sles9.x86_64.rpm
				rpm -ivh ./suse/x86_64/9.0/net-snmp/net-snmp-devel-5.1.4-0.1.isms.sles9.x86_64.rpm
				rpm -ivh ./suse/x86_64/9.0/net-snmp/perl-SNMP-5.1.4-0.1.isms.sles9.x86_64.rpm
			else
				rpm -ivh ./suse/ia32/9.0/net-snmp/net-snmp-5.1.4-0.1.isms.sles9.i586.rpm
				rpm -ivh ./suse/ia32/9.0/net-snmp/net-snmp-devel-5.1.4-0.1.isms.sles9.i586.rpm
				rpm -ivh ./suse/ia32/9.0/net-snmp/perl-SNMP-5.1.4-0.1.isms.sles9.i586.rpm
			fi
		
		fi

	# End of SLES 10 check's else condition
	fi 
	

else
	# OS is not SuSE. ISMS net-snmp is not required.
	
	## Check whether OS net-snmp is installed.

	NET_SNMP=`rpm -q net-snmp`
	if [ $? -eq 1 ]; then
		echo "Intel(R) SNMP Subagent requires net-snmp package to be installed on the system."
		echo "Aborting installation of Intel(R) SNMP Subagent."
		exit 1		
	fi
	
fi

SNMP_PID=`pidof snmpd`
if [ -z "${SNMP_PID}" ]; then
	echo "Starting snmpd service ..."
	if [ "$OSVER3" == "Red Hat Enterprise Linux Server release 7.0 (Maipo)" ] || [ "$OSVER4" == "Red Hat Enterprise Linux Server release 7.1 (Maipo)" ] || [ "$OSVER5" == "Red Hat Enterprise Linux Server release 7.2 (Maipo)" ] || [ "$OSVER6" == "Red Hat Enterprise Linux Server release 7.3 Beta (Maipo)" ] || [ "$OSVER6" == "Red Hat Enterprise Linux Server release 7.3 (Maipo)" ]; then
		systemctl enable snmpd
		systemctl start snmpd
	elif [[ $OSVer_12 ]]; then
		systemctl enable snmpd
		systemctl start snmpd
	else
		/etc/init.d/snmpd start
	fi
	SNMPD_STAT=$?
	if [ "${SNMPD_STAT}" -ne 0 ]; then
		echo "Couldn't start snmpd service, exiting install"
		## Exit and return the obtained error code.
		exit ${SNMPD_STAT}
	fi
fi


#Check if RedHat  / SUSE

if [ -f "/etc/SuSE-release" ]  
	then
	## Check for SLES 10
	#grep "VERSION *= *10" /etc/SuSE-release > /dev/null 2>&1
	#OSVER_1=$(sed -n '/Version/p' /etc/SuSE-release)
	#if [ $? -eq 0 ]; then
	if [[ $OSVer_10 ]]; then
		echo "this is version 10 installation....... "
		## Check for 32 / x64
		uname -m|grep x86_64 > /dev/null 2>&1
		if [ $? -eq 0 ]; then
			## Create symlinks and install without checking dependencies.
			if [ ! -e "/usr/lib64/librpm-4.1.so" ]
				then
				ln -s /usr/lib64/librpm-4.4.so /usr/lib64/librpm-4.1.so
				ln -s /usr/lib64/librpmdb-4.4.so /usr/lib64/librpmdb-4.1.so
				ln -s /usr/lib64/librpmio-4.4.so /usr/lib64/librpmio-4.1.so
			fi
			if [ ! -e "/usr/lib64/libnetsnmpagent.so.5" ]; then
				ln -s  /usr/lib64/libnetsnmpagent.so.10 /usr/lib64/libnetsnmpagent.so.5
				ln -s /usr/lib64/libnetsnmphelpers.so.10 /usr/lib64/libnetsnmphelpers.so.5
				ln -s /usr/lib64/libnetsnmpmibs.so.10 /usr/lib64/libnetsnmpmibs.so.5
				ln -s /usr/lib64/libnetsnmp.so.10 /usr/lib64/libnetsnmp.so.5				
				ln -s /usr/lib64/libsnmp.so.10 /usr/lib64/libsnmp.so.5
				ln -s /usr/lib64/libnetsnmptrapd.so.10 /usr/lib64/libnetsnmptrapd.so.5
			fi
			# CacheRiver is statically linked but needed for hrs files
                        rpm -ivh --nodeps ./suse/x86_64/10/CacheRiver*.x86_64.rpm
			rpm -ihv --nodeps ./suse/x86_64/10/snmpsa*.x86_64.rpm
                        chkconfig --level 35 snmpd on
                        chkconfig --level 35 snmpsa on
		else
			## Create symlinks and install without checking dependencies.
			if [ ! -e "/usr/lib/librpm-4.1.so" ]
				then
				ln -s /usr/lib/librpm-4.4.so /usr/lib/librpm-4.1.so
				ln -s /usr/lib/librpmdb-4.4.so /usr/lib/librpmdb-4.1.so
				ln -s /usr/lib/librpmio-4.4.so /usr/lib/librpmio-4.1.so
			fi
			if [ ! -e "/usr/lib/libnetsnmpagent.so.5" ]; then
				ln -s  /usr/lib/libnetsnmpagent.so.10 /usr/lib/libnetsnmpagent.so.5
				ln -s /usr/lib/libnetsnmphelpers.so.10 /usr/lib/libnetsnmphelpers.so.5
				ln -s /usr/lib/libnetsnmpmibs.so.10 /usr/lib/libnetsnmpmibs.so.5
				ln -s /usr/lib/libnetsnmp.so.10 /usr/lib/libnetsnmp.so.5				
				ln -s /usr/lib/libsnmp.so.10 /usr/lib/libsnmp.so.5
				ln -s /usr/lib/libnetsnmptrapd.so.10 /usr/lib/libnetsnmptrapd.so.5
			fi
			# CacheRiver is statically linked, but needed for hrs files
                        rpm -ivh --nodeps ./suse/ia32/10/CacheRiver*.rpm
			rpm -ihv --nodeps ./suse/ia32/10/snmpsa*.i586.rpm
		        chkconfig --level 35 snmpd on
                        chkconfig --level 35 snmpsa on
		fi
	elif [[ $OSVer_11 ]]; then
		## Check for 32 / x64
		echo "This is version 11 installation..... "
		ARCH=`uname -m|grep x86_64 > /dev/null 2>&1`
		if [ $? = 0 ]
			then
			if [ ! -e "/usr/lib64/libnetsnmpagent.so.5" ]; then
				ln -s  /usr/lib64/libnetsnmpagent.so.8 /usr/lib64/libnetsnmpagent.so.5
				ln -s /usr/lib64/libnetsnmphelpers.so.8 /usr/lib64/libnetsnmphelpers.so.5
				ln -s /usr/lib64/libnetsnmpmibs.so.8 /usr/lib64/libnetsnmpmibs.so.5
				ln -s /usr/lib64/libnetsnmp.so.8 /usr/lib64/libnetsnmp.so.5				
				ln -s /usr/lib64/libsnmp.so.8 /usr/lib64/libsnmp.so.5
				ln -s /usr/lib64/libnetsnmptrapd.so.8 /usr/lib64/libnetsnmptrapd.so.5
			fi
			# CacheRiver is statically linked 
			# but needed for hrs files
			rpm -ivh --nodeps ./suse/x86_64/11/CacheRiver*.x86_64.rpm 
			rpm -ihv --nodeps ./suse/x86_64/11/snmpsa*.x86_64.rpm
                        chkconfig --level 35 snmpd on
                        chkconfig --level 35 snmpsa on
                      
		else
			if [ ! -e "/usr/lib/libnetsnmpagent.so.5" ]; then
				ln -s  /usr/lib/libnetsnmpagent.so.8 /usr/lib/libnetsnmpagent.so.5
				ln -s /usr/lib/libnetsnmphelpers.so.8 /usr/lib/libnetsnmphelpers.so.5
				ln -s /usr/lib/libnetsnmpmibs.so.8 /usr/lib/libnetsnmpmibs.so.5
				ln -s /usr/lib/libnetsnmp.so.8 /usr/lib/libnetsnmp.so.5				
				ln -s /usr/lib/libsnmp.so.8 /usr/lib/libsnmp.so.5
				ln -s /usr/lib/libnetsnmptrapd.so.8 /usr/lib/libnetsnmptrapd.so.5
			fi
			# CacheRiver is statically linked 
			# but needed for hrs files
			rpm -ivh --nodeps ./suse/ia32/11/CacheRiver*.rpm
			rpm -ihv --nodeps ./suse/ia32/11/snmpsa*.i586.rpm
			chkconfig --level 35 snmpd on
                        chkconfig --level 35 snmpsa on		
                 fi
	
	else
		echo "This is version 12 installation..... "
		rpm -ivh --nodeps ./suse/x86_64/12/CacheRiver*.x86_64.rpm 
		rpm -ihv --nodeps ./suse/x86_64/12/snmpsa*.x86_64.rpm
		cp snmpsa.service /usr/lib/systemd/system/
                    chkconfig --level 35 snmpd on
                    chkconfig --level 35 snmpsa on
		
	fi
else
	#Check RHEL Version
	RH_RELEASE=`rpm -q redhat-release` 
	RH6_RELEASE=`rpm -q --whatprovides redhat-release` #Added for RHEL6
	if [[ $RH6_RELEASE == redhat-release-server-7* ]]
		then
		rpm -ivh --nodeps ./rhlinux/x86_64/el7.0/CacheRiver*.x86_64.rpm
		rpm -ihv --nodeps ./rhlinux/x86_64/el7.0/snmpsa*.x86_64.rpm
		cp snmpsa.service /usr/lib/systemd/system/
                chkconfig --level 35 snmpd on
                chkconfig --level 35 snmpsa on

	elif [[ $RH6_RELEASE == redhat-release-server-6Server* ]]
		then
		#Check if EM64
		ARCH=`uname -m|grep x86_64 > /dev/null 2>&1`
		if [ $? = 0 ]
			then
			# CacheRiver is statically linked 
			# but needed for hrs files
			rpm -ivh --nodeps ./rhlinux/x86_64/el6.0/CacheRiver*.x86_64.rpm
			rpm -ihv --nodeps ./rhlinux/x86_64/el6.0/snmpsa*.x86_64.rpm
                        chkconfig --level 35 snmpd on
                        chkconfig --level 35 snmpsa on 
		else
			# CacheRiver is statically linked 
			# but needed for hrs files
			rpm -ivh --nodeps ./rhlinux/ia32/el6.0/CacheRiver*.rpm
			rpm -ihv --nodeps ./rhlinux/ia32/el6.0/snmpsa*.i386.rpm
	                chkconfig --level 35 snmpd on
                      chkconfig --level 35 snmpsa on
        	fi
	elif [[ $RH_RELEASE == redhat-release-5Server* ]]
		then
		#Check if EM64
		ARCH=`uname -m|grep x86_64 > /dev/null 2>&1`
		if [ $? = 0 ]
			then
			#Create softlinks for librpm-4.2(64) and do a force installation
			if [ ! -e "/usr/lib64/librpm-4.2.so" ]
				then
				ln -s /usr/lib64/librpm.so /usr/lib64/librpm-4.2.so
				ln -s /usr/lib64/librpmdb.so /usr/lib64/librpmdb-4.2.so
				ln -s /usr/lib64/librpmio.so /usr/lib64/librpmio-4.2.so
			fi
			if [ ! -e "/lib64/libcrypto.so.4" ]
				then
				ln -s /lib64/libcrypto.so.6 /lib64/libcrypto.so.4
			fi
			if [ ! -e "/usr/lib64/libnetsnmpagent.so.5" ]; then
				ln -s  /usr/lib64/libnetsnmpagent.so.10 /usr/lib64/libnetsnmpagent.so.5
				ln -s /usr/lib64/libnetsnmphelpers.so.10 /usr/lib64/libnetsnmphelpers.so.5
				ln -s /usr/lib64/libnetsnmpmibs.so.10 /usr/lib64/libnetsnmpmibs.so.5
				ln -s /usr/lib64/libnetsnmp.so.10 /usr/lib64/libnetsnmp.so.5				
				ln -s /usr/lib64/libsnmp.so.10 /usr/lib64/libsnmp.so.5
				ln -s /usr/lib64/libnetsnmptrapd.so.10 /usr/lib64/libnetsnmptrapd.so.5

				#Attempt to create links for 32 bit as well
				ln -s  /usr/lib/libnetsnmpagent.so.10 /usr/lib/libnetsnmpagent.so.5
				ln -s /usr/lib/libnetsnmphelpers.so.10 /usr/lib/libnetsnmphelpers.so.5
				ln -s /usr/lib/libnetsnmpmibs.so.10 /usr/lib/libnetsnmpmibs.so.5
				ln -s /usr/lib/libnetsnmp.so.10 /usr/lib/libnetsnmp.so.5				
				ln -s /usr/lib/libsnmp.so.10 /usr/lib/libsnmp.so.5
				ln -s /usr/lib/libnetsnmptrapd.so.10 /usr/lib/libnetsnmptrapd.so.5
			fi
			# CacheRiver is statically linked 
			# but needed for hrs files
			rpm -ivh --nodeps ./rhlinux/x86_64/el5.0/CacheRiver*.x86_64.rpm
			rpm -ihv --nodeps ./rhlinux/x86_64/el5.0/snmpsa*.x86_64.rpm
		        chkconfig --level 35 snmpd on
                        chkconfig --level 35 snmpsa on  
                  else
			#Create softlinks for librpm-4.2(32) and do a force installation
			if [ ! -e "/usr/lib/librpm-4.2.so" ]
				then
				ln -s /usr/lib/librpm.so /usr/lib/librpm-4.2.so
				ln -s /usr/lib/librpmdb.so /usr/lib/librpmdb-4.2.so
				ln -s /usr/lib/librpmio.so /usr/lib/librpmio-4.2.so
			fi
			if [ ! -e "/lib/libcrypto.so.4" ]
				then
				ln -s /lib/libcrypto.so.6 /lib/libcrypto.so.4
			fi
			if [ ! -e "/usr/lib/libnetsnmpagent.so.5" ]; then
				ln -s  /usr/lib/libnetsnmpagent.so.10 /usr/lib/libnetsnmpagent.so.5
				ln -s /usr/lib/libnetsnmphelpers.so.10 /usr/lib/libnetsnmphelpers.so.5
				ln -s /usr/lib/libnetsnmpmibs.so.10 /usr/lib/libnetsnmpmibs.so.5
				ln -s /usr/lib/libnetsnmp.so.10 /usr/lib/libnetsnmp.so.5				
				ln -s /usr/lib/libsnmp.so.10 /usr/lib/libsnmp.so.5
				ln -s /usr/lib/libnetsnmptrapd.so.10 /usr/lib/libnetsnmptrapd.so.5			
			fi
			# CacheRiver is statically linked 
			# but needed for hrs files
			rpm -ivh --nodeps ./rhlinux/ia32/el5.0/CacheRiver*.rpm
			rpm -ihv --nodeps ./rhlinux/ia32/el5.0/snmpsa*.i386.rpm
                        chkconfig --level 35 snmpd on
                        chkconfig --level 35 snmpsa on
		fi
	elif [[ $RH_RELEASE == redhat-release-4AS* ]]
		then
		#Check if EM64
		ARCH=`uname -m|grep x86_64 > /dev/null 2>&1`
		if [ $? = 0 ]
			then
			#Create softlinks for librpm-4.2(64) and do a force installation
			if [ ! -e "/usr/lib64/librpm-4.2.so" ]
				then
				ln -s /usr/lib64/librpm.so /usr/lib64/librpm-4.2.so
				ln -s /usr/lib64/librpmdb.so /usr/lib64/librpmdb-4.2.so
				ln -s /usr/lib64/librpmio.so /usr/lib64/librpmio-4.2.so
			fi
			# CacheRiver is statically linked 
			# but needed for hrs files
			rpm -ivh --nodeps ./rhlinux/x86_64/el5.0/CacheRiver*.x86_64.rpm
			rpm -ihv --nodeps ./rhlinux/x86_64/el3.0/snmpsa*.x86_64.rpm
                        chkconfig --level 35 snmpd on
                        chkconfig --level 35 snmpsa on 
		else
			#Create softlinks for librpm-4.2(32) and do a force installation
			if [ ! -e "/usr/lib/librpm-4.2.so" ]
				then
				ln -s /usr/lib/librpm.so /usr/lib/librpm-4.2.so
				ln -s /usr/lib/librpmdb.so /usr/lib/librpmdb-4.2.so
				ln -s /usr/lib/librpmio.so /usr/lib/librpmio-4.2.so
			fi
			# CacheRiver is statically linked 
			# but needed for hrs files
			rpm -ivh --nodeps ./rhlinux/ia32/el5.0/CacheRiver*.rpm
			rpm -ihv --nodeps ./rhlinux/ia32/el3.0/snmpsa*.i386.rpm
	                chkconfig --level 35 snmpd on
                        chkconfig --level 35 snmpsa on
        	fi
	else
		#Check if EM64
		ARCH=`uname -m|grep x86_64 > /dev/null 2>&1`
		if [ $? = 0 ]
			then
			# CacheRiver is statically linked 
			# but needed for hrs files
			rpm -ivh --nodeps ./rhlinux/x86_64/el5.0/CacheRiver*.x86_64.rpm
			rpm -ihv --nodeps ./rhlinux/x86_64/el3.0/snmpsa*.x86_64.rpm
                        		chkconfig --level 35 snmpd on
                        		chkconfig --level 35 snmpsa on 
		else    
			# CacheRiver is statically linked 
			# but needed for hrs files
                   rpm -ivh --nodeps ./rhlinux/ia32/el5.0/CacheRiver*.rpm
	           rpm -ihv --nodeps ./rhlinux/ia32/el5.0/snmpsa*.i386.rpm

                        chkconfig --level 35 snmpd on
                        chkconfig --level 35 snmpsa on  
		fi
	fi
fi
cp -R ./docs  /usr/local/snmpsa/
cp -R ./mibs  /usr/local/snmpsa/
cp ./snmpsubagent_uninstall.sh  /usr/local/snmpsa/bin/uninstall.sh
chmod +x /usr/local/snmpsa/bin/uninstall.sh

#start service monitor
#addcronjob

echo "Intel(R) SNMP Subagent installed successfully!"
exit 0

