/******************************************************************************
*
*                   INTEL CORPORATION PROPRIETARY INFORMATION
*       This software is supplied under the terms of a license agreement or
*       nondisclosure agreement with Intel Corporation and may not be copied
*       or disclosed except in accordance with the terms of that agreement.
*
*            Copyright (c) 2008-2009 Intel Corporation. All Rights Reserved.
*
*       All rights reserved.  No part of this program or publication may be
*       reproduced, transmitted, transcribed, stored in a retrieval system,
*       or translated into any language or computer language, in any form or
*       by any means, electronic, mechanical, magnetic, optical, chemical,
*       manual, or otherwise, without the prior written permission of Intel
*       Corporation.
*
*
*******************************************************************************/

#ifndef _CACHERIVER_SYSFWUPDATE_PARAM_H_
#define _CACHERIVER_SYSFWUPDATE_PARAM_H_

#include <os/include/cr_osal.h>
#include <modules/bmc/update/UpdateCallBackBase.h>

namespace Module
{
    namespace Update
    {
        typedef enum {
            UPDATE_UNKNOW = 0,
            UPDATE_ACTIVE,
            UPDATE_RECOVERY,
            UPDATE_TYPES
        }SysFwUpdateType_e;

        typedef enum {
            FILE_UNKNOW = 0,    // Cannot parse file type
            FILE_BIOS,
            FILE_ME,
            FILE_BMC,
            FILE_IFWI,
            FILE_DUPLICATE,     // There are more than one file for a same type
            FILE_TYPES
        }SysFwUpdateFileType_e;

        class CLASSINDLL_CLASS_DECL SysFwUpdateParam
        {
        public:
            SysFwUpdateParam();
            ~SysFwUpdateParam();

        public:
            bool SetUpdateType(SysFwUpdateType_e type);
            SysFwUpdateType_e GetUpdateType(void) {return m_updateType;};
            SysFwUpdateFileType_e SetUpdateFile(STRING fileName);
            STRING GetUpdateFile(SysFwUpdateFileType_e fileType);

            // Set/Get the switches string for BIOS&ME update process
            void SetBiosUpdateSwitches(STRING switchs) {m_biosUpdateSwitches = switchs;};
            void SetMeUpdateSwitches(STRING switchs) {m_meUpdateSwitches = switchs;};
            STRING GetBiosUpdateSwitches(void) {return m_biosUpdateSwitches;};
            STRING GetMeUpdateSwitches(void) {return m_meUpdateSwitches;};

            // Set/Get the opting flags of BMC&BIOS update, the falgs are defined in CapsuleFileInt.h and IntelHexFile.h
            void SetBiosUpdateOptions(UINT32 options) {m_biosUpdateOptions = options;};
            void SetMeUpdateOptions(UINT32 options) {m_meUpdateOptions = options;};
            void SetBmcUpdateOptions(UINT32 options) {m_bmcUpdateOptions = options;};
            UINT32 GetBiosUpdateOptions(void) {return m_biosUpdateOptions;};
            UINT32 GetMeUpdateOptions(void) {return m_meUpdateOptions;};
            UINT32 GetBmcUpdateOptions(void) {return m_bmcUpdateOptions;};

            // Set/Get the size of buffer that used for BMC update
            void SetBmcUpdateBufSize(UINT16 bufSize) {m_bmcUpdateBufSize = bufSize;};
            UINT16 GetBmcUpdateBufSize(void) {return m_bmcUpdateBufSize;};

            // Set/Get the update regions in IFWI file
            void SetIFWIUpdateRegions(UINT32 regions) {m_ifwiUpdateRegions = regions;};
            UINT32 GetIFWIUpdateRegions(void) {return m_ifwiUpdateRegions;};

            void SetCallBackClass(Module::Update::UpdateCallBackBase* ptrCallBackBase) {m_ptrCallBackBase = ptrCallBackBase;}
            Module::Update::UpdateCallBackBase* GetCallBackClass(void) {return m_ptrCallBackBase;};

        private:
            bool IsBmcImageFile(STRING fileName);
            bool IsIFWIFile(STRING fileName);

        private:
            Module::Update::UpdateCallBackBase* m_ptrCallBackBase;
            SysFwUpdateType_e m_updateType;
            STRING m_biosUpdateSwitches;
            STRING m_meUpdateSwitches;
            STRING m_biosName;
            STRING m_meName;
            STRING m_bmcName;
            STRING m_ifwiName;
            UINT32 m_ifwiUpdateRegions;
            UINT32 m_biosUpdateOptions;
            UINT32 m_meUpdateOptions;
            UINT32 m_bmcUpdateOptions;
            UINT16 m_bmcUpdateBufSize;
        };
    }
}

#endif