#ifndef _CFG_FILE_DATA_H_
#define _CFG_FILE_DATA_H_

#include <modules/bmc/update/UpdateCallBackBase.h>

#ifdef CR_EFI
TYPEDEF_VECTOROF(VECTOROF_STRING, VecStringArrayType);
#endif

#define MAX_SUPPORTED_PROC 10

struct CFG_var
{
    WCHAR *CfgFilename;
    int proc_no;
    VECTOROF_STRING product;
#ifndef CR_EFI
    VECTOROF_STRING proc_info[MAX_SUPPORTED_PROC+1]; // change size from 10 to 11 to fix KW ABV.GENERAL issue
    VECTOROF_STRING proc_cores[MAX_SUPPORTED_PROC+1]; // change size from 10 to 11 to fix KW ABV.GENERAL issue
    VECTOROF_STRING proc_family[MAX_SUPPORTED_PROC+1]; // change size from 10 to 11 to fix KW ABV.GENERAL issue
    VECTOROF_STRING cpuid[MAX_SUPPORTED_PROC+1]; // change size from 10 to 11 to fix KW ABV.GENERAL issue
#else
    VecStringArrayType proc_info;
    VecStringArrayType proc_cores;
    VecStringArrayType proc_family;
    VecStringArrayType cpuid;
#endif
    UINT32 hsc_primary_product_id;
    UINT32 hsc_secondary_product_id;
    Module::Update::UpdateCallBackBase *callBackPtr;

    bool is_sdr_auto_config;
    bool is_openipmi_check;

#ifdef CR_EFI
    void Initialize(void)
    {
        callBackPtr = NULL;
        CfgFilename = NULL;
        proc_info.resize(MAX_SUPPORTED_PROC+1); // change size from 10 to 11 to fix KW ABV.GENERAL issue
        proc_cores.resize(MAX_SUPPORTED_PROC+1); // change size from 10 to 11 to fix KW ABV.GENERAL issue
        cpuid.resize(MAX_SUPPORTED_PROC+1); // change size from 10 to 11 to fix KW ABV.GENERAL issue
        proc_family.resize(MAX_SUPPORTED_PROC+1); // change size from 10 to 11 to fix KW ABV.GENERAL issue
    }
#endif

    //Constructor
    CFG_var()
    {
        callBackPtr = NULL;
        CfgFilename = NULL;
        is_sdr_auto_config = false;
        is_openipmi_check = false;
    }
};
#endif

