DESCRIPTION = "Native Border Router for IPv6"
SECTION = "applications"
LICENSE = "BSD"
LIC_FILES_CHKSUM = "file://${COMMON_LICENSE_DIR}/BSD;md5=3775480a712fc46a69647678acb234cb"

# Source-dir is in the git directory.
S = "${WORKDIR}/git"

#FILESEXTRAPATHS_prepend := "${THISDIR}/${PN}:"

SRC_URI = "gitsm://${AT_WORKSPACE}/sparrow;protocol=file;branch=master \
	file://startBorderRouter.sh \
	file://99-br.rules \
	file://0001-wsdemoserver.py-Modified-import-path-for-python-libr.patch \
	"

SRCREV = "${AUTOREV}"

RDEPENDS_${PN} = "bash python"

INHIBIT_PACKAGE_DEBUG_SPLIT = '1'

APPLICATION="border-router.native"
INSTALL_ROOT="/opt/6lowpan"
SBINDIR="${INSTALL_ROOT}/sbin"
TOOLDIR = "/tools"
DEMODIR = "/examples"
# TESTDIR = "/examples/galileo/tests"
NBRDIR = "/products/sparrow-border-router"
OLDNBRDIR = "/examples/ipv6/native-border-router"

FILES_${PN} = "${SBINDIR} \
	       ${SBINDIR}/${APPLICATION} \
	       ${SBINDIR}/startBorderRouter.sh \
	      "

CFLAGS += "-fno-strict-aliasing"

EXTRA_OEMAKE = "'EXTRA_CFLAGS = "-D_FORTIFY_SOURCE=2 -Wformat -O2 -Wformat-security -fstack-protector-strong -fPIE -fPIC -pie"' \
                'EXTRA_LDFLAGS = "-z relro -z now -z noexecstack"' \
               "

do_compile() {
	cd ${S}${NBRDIR}
	sed -i \
	-e 's@/usr/local/include@../usr/local/include/non-existant@' \
	../../contiki/cpu/native/Makefile.native
	sed -i  \
	-e 's@CFLAGS+=@CFLAGS+= -I../../../core -D__UCLIBC_HAS_CONTEXT_FUNCS__  -D__LITTLE_ENDIAN__@' \
	-e 's/CC=/CC\?=/' \
	-e 's/LD=/LD\?=/' \
	Makefile

# To build NBR for USB SLIP radio, use this line
	make CC="$CC" LD="$CC"

}

# CC="$CC" LD="$CC"

do_patch(){
	cd ${WORKDIR}/git
	git am ${WORKDIR}/0001-wsdemoserver.py-Modified-import-path-for-python-libr.patch
}

do_install() {
	install -m 0755 -d	${D}${INSTALL_ROOT} \
				${D}${SBINDIR} \
				${D}${SBINDIR}${TOOLDIR}/instance-defs \
				${D}${SBINDIR}${DEMODIR}/www \

# Installation of border router binary and platform shell scripts
	install -m 0755 ${S}${NBRDIR}/border-router.native-sparrow	${D}${SBINDIR}

# Installation of 6LoWPAN web layout files for NBR console
#install -m 0664 ${S}${NBRDIR}/www/*			${D}${SBINDIR}/www

# Installation of node and serial radio OTA Upgrade tool.
	install -m 0664 ${S}${TOOLDIR}/sparrow/instance-defs/*			${D}${SBINDIR}${TOOLDIR}/instance-defs
	install -m 0664 ${S}${TOOLDIR}/sparrow/*.py		${D}${SBINDIR}${TOOLDIR}
	install -m 0664 ${S}${TOOLDIR}/sparrow/*.sh		${D}${SBINDIR}${TOOLDIR}
	install -m 0664 ${S}${TOOLDIR}/sparrow/Makefile.include		${D}${SBINDIR}${TOOLDIR}


# Installation of Webdemo Tool.
	install -m 0664 ${S}${DEMODIR}/sparrow/*.py			${D}${SBINDIR}${DEMODIR}
	install -m 0664 ${S}${DEMODIR}/sparrow/www/*			${D}${SBINDIR}${DEMODIR}/www

}
