DESCRIPTION = "LWM2M Bootstrap Server"
SECTION = "applications"
LICENSE = "CLOSED"

SRC_URI = "gitsm://${AT_WORKSPACE}/sparrow-wakaama;protocol=file;branch=sparrow-lwm2m"
SRCREV = "${AUTOREV}"

PACKAGES = "${PN}"
INHIBIT_PACKAGE_DEBUG_SPLIT = '1'

APPLICATION="bootstrap_server"
INSTALL_ROOT="/opt/6lowpan"
SBINDIR="${INSTALL_ROOT}/sbin"

FILES_${PN} = "${SBINDIR} \
               ${SBINDIR}/${APPLICATION} \
              "

S = "${WORKDIR}/git/examples/bootstrap_server"

inherit cmake

EXTRA_OEMAKE = "'EXTRA_CFLAGS = "-D_FORTIFY_SOURCE=2 -Wformat -O2 -Wformat-security -fstack-protector-strong -fPIE -fPIC -pie"' \
                'EXTRA_LDFLAGS = "-z relro -z now -z noexecstack"' \
               "

do_install() {
    install -d 0755 ${D}/${INSTALL_ROOT}
    install -d 0755 ${D}/${SBINDIR}
#    install -m 0755 ${S}/${APPLICATION} ${D}/${SBINDIR}/${APPLICATION}
    install -m 0755 ${WORKDIR}/build/${APPLICATION} ${D}/${SBINDIR}/${APPLICATION}
#    install -m 0755 ${WORKDIR}/bootstrap_server.ini ${D}/${SBINDIR}/
    install -m 0755 ${S}/bootstrap_server.ini ${D}/${SBINDIR}/
}

