DESCRIPTION = "LWM2M Server"
SECTION = "applications"
LICENSE = "CLOSED"

SRC_URI = "gitsm://${AT_WORKSPACE}/sparrow-wakaama;protocol=file;branch=sparrow-lwm2m"
SRCREV = "${AUTOREV}"
NDIR="$(pwd)"
PACKAGES = "${PN}"
INHIBIT_PACKAGE_DEBUG_SPLIT = '1'

APP_BUILD_NAME="lwm2mserver"
APPLICATION="lwm2mserver-dtls"
INSTALL_ROOT="/opt/6lowpan"
SBINDIR="${INSTALL_ROOT}/sbin"

FILES_${PN} = "${SBINDIR} \
               ${SBINDIR}/${APPLICATION} \
              "

S = "${WORKDIR}/git/examples/server"

inherit cmake

EXTRA_OEMAKE = "'EXTRA_CFLAGS = "-D_FORTIFY_SOURCE=2 -Wformat -O2 -Wformat-security -fstack-protector-strong -fPIE -fPIC -pie"' \
                'EXTRA_LDFLAGS = "-z relro -z now -z noexecstack"' \
               "

do_configure() {
    cmake -DDTLS=1 ${S}
}

do_install() {
    install -d 0755 ${D}/${INSTALL_ROOT}
    install -d 0755 ${D}/${SBINDIR}
#    install -m 0755 ${S}/${APP_BUILD_NAME} ${D}/${SBINDIR}/${APPLICATION}
    install -m 0755 ${WORKDIR}/build/${APP_BUILD_NAME} ${D}/${SBINDIR}/${APPLICATION}
}

