#!/bin/sh
# This script is to install LSIStorageAuthority RPM's
#

((setupstate--))
./deleteOldVersion.sh
retval=$?
if [ $retval == 1 ]; then
  exit
fi

if [ "$setuptype" = "" ]; then
	setuptype="g"
fi

IsPortAvailable()
{
    port=$1
    output=`netstat -na | grep LISTEN | grep :${port} | cut -d: -f2 | awk '{print $1}' | head -1`
    if [[ $output = "" ]]; then
        return 0
    fi

    if [ ${port} = ${output} ]; then
        return 1
    else
        return 0
    fi
}

IsStringContainingSpaces()
{
    string="$1"
    if [[ "$string" =~ \ + ]]; then
        return 1
    else
        return 0
    fi
}

IsPortInrange()
{
    port=$1

    validateStringLength $port 15
    if [ $? != 0 ]; then
        return 1
    fi
    if [ ${port} -lt 1 ] || [ ${port} -gt 65535 ]; then
        return 1
    else
        return 0
    fi
}

IsNumericValue()
{
    Value="$1"

    if [[ "$Value" =~ [^0-9]+ ]] ; then
        return 1
    else
        return 0
    fi
}

validateStringLength()
{
    string="$1"
    validLength=$2

    length=`echo "${string}" | awk '{ print length }'`
    if [ ${length} -gt ${validLength} ]; then
        return 1
    else
        return 0
    fi
}

getUserInput()
{
###########################################################################################
################ Read Webserver Port ######################################################
###########################################################################################

    while (true)
    do
	if [ "$setupmode" = "SILENT" ]; then
        	nginxPort=$nginx_port
        	if [[ $nginxPort = "" ]]; then
            	nginxPort="2463"
        	fi
	else
        	read -p 'Enter Web Server port [2463] : ' nginxPort
        	if [[ $nginxPort = "" ]]; then
            	nginxPort="2463"
        	fi
	fi

        IsNumericValue $nginxPort
        if [ $? != 0 ]; then
            echo "Invalid Port number, try another one."
            continue
        fi

        IsPortInrange $nginxPort
        if [ $? != 0 ]; then
            echo "The given Port Number is out of valid range[1-65535], try another one."
            continue
        fi

        IsPortAvailable $nginxPort
        if [ $? = 0 ]; then
            break
        else
            #echo "The given Port is in use, try another one."
            while(true)
            do
                nginxPort=$(( $nginxPort + 1 ))
                IsPortAvailable $nginxPort
                if [ $? = 0 ]; then
                    break
                fi
            done
            echo "The given port is in use, the next available port is $nginxPort"
            echo ""
            read -p 'Would you like to continue with this available port [y/n]: ' config
            if [ "${config}" = "y" ] || [ "${config}" = "Y" ]; then
                break
            fi
        fi
    done

###########################################################################################
################ Read LSIStorageAuthority Port ############################################
###########################################################################################
    while (true)
    do
	if [ "$setupmode" = "SILENT" ]; then
		LSAappPort=$LSA_port
        	if [[ $LSAappPort = "" ]]; then
            	LSAappPort="9000"
        	fi
  	else
	        read -p 'Enter LSA port [9000] : ' LSAappPort
        	if [[ $LSAappPort = "" ]]; then
            	LSAappPort="9000"
        	fi
	fi

        if [[ $LSAappPort = $nginxPort ]]; then
            echo "Ports used for webserver and LSI Storage Authority cannot be the same, try another one."
            continue
        fi
        IsNumericValue $LSAappPort
        if [ $? != 0 ]; then
            echo "Invalid Port number, try another one."
            continue
        fi

        IsPortInrange $LSAappPort
        if [ $? != 0 ]; then
            echo "The given Port Number is out of valid range[1-65535], try another one."
            continue
        fi

        IsPortAvailable $LSAappPort
        if [ $? = 0 ]; then
            break
        else
            #echo "The given Port is in use, try another one."
            while(true)
            do
                LSAappPort=$(( $LSAappPort + 1 ))
                IsPortAvailable $LSAappPort
                if [ $? = 0 ]; then
                    break
                fi
            done
            echo "The given port is in use, the next available port is $LSAappPort"
            echo ""
            read -p 'Would you like to continue with this available port [y/n]: ' config
            if [ "${config}" = "y" ] || [ "${config}" = "Y" ]; then
                break
            fi
        fi
    done
}

install_rpms ()
{
#3rd party library installation
utils_rpm=`rpm -qa | grep LSA_lib_utils- | wc -l`
if [ $utils_rpm = 0 ]; then
	echo "Installing  LSA_lib_utils-1.00-00"
        rpm -ivh LSA_lib_utils-1.00-00.x86_64.rpm 
else
        lib_newdate=1445928562
        lib_olddate=`rpm -q --queryformat "%{BUILDTIME}" LSA_lib_utils`
                if [ $lib_newdate -gt $lib_olddate ]; then
			echo "Installing  LSA_lib_utils-1.00-00"
                        rpm -ivh LSA_lib_utils-1.00-00.x86_64.rpm --force
                fi
                if [ $lib_newdate -eq $lib_olddate ]; then
                        echo "Latest LSA_lib_utils RPM is already installed"
                fi
fi

utils2_rpm=`rpm -qa | grep LSA_lib_utils2- | wc -l`
if [ $utils2_rpm = 0 ]; then
	slpFound=0

        if [ -x /usr/sbin/slpd ]; then
		slpFound=1
                echo "openSLP server RPM is installed"
        
        elif [ -x /usr/local/sbin/slpd ]; then
                slpFound=1
                echo "openSLP server RPM is installed from source"
        
        else
                echo "openSLP server RPM is not installed"
                slpFound=0
        fi

	if [ $slpFound = 0 ]; then
        	echo "Installing the above package(s) from your installation source is highly recommended"
        	echo "However proceeding further installs SLP package bundled with LSA from openslp.org."
        	echo "Continue (Y/N)? "
        	read proceed

        	if [ ${proceed} = "y" ] || [ ${proceed} = "Y" ]; then
			if ! [ -d /usr/local/var/log ]; then
                             mkdir -p /usr/local/var/log
                        fi
			echo "Installing  LSA_lib_utils2-1.00-00"
                	rpm -ivh LSA_lib_utils2-1.00-00.x86_64.rpm
			if ! [ $? = 0 ]; then
				echo "SLP Installation failed due to unresolved dependencies ! Proceeding with LSA installation now. Please try install SLP from installation source beforr starting LSA to have functionalities work as expected..."
			fi
        	else
			echo "Installation exited...Please install SLP from installation source and return to install LSA. See you soon with the SLP installation..."
			exit
		fi
	fi
else
        lib_newdate=1464676826
        lib_olddate=`rpm -q --queryformat "%{BUILDTIME}" LSA_lib_utils2`
                if [ $lib_newdate -gt $lib_olddate ]; then
			slpFound=0

                        if [ -x /usr/sbin/slpd ]; then
                            slpFound=1
                            echo "openSLP server RPM is installed"

                        elif [ -x /usr/local/sbin/slpd ]; then
                            slpFound=1
                            echo "openSLP server RPM is installed from source"

                        else
                            echo "openSLP server RPM is not installed"
                            slpFound=0
                        fi

			if [ $slpFound = 0 ]; then
        			echo "Installing the above package(s) from your installation source is highly recommended"
        			echo "However proceeding further installs SLP package bundled with LSA from openslp.org."
        			echo "Continue (Y/N)? "
        			read proceed

        			if [ ${proceed} = "y" ] || [ ${proceed} = "Y" ]; then
					if ! [ -d /usr/local/var/log ]; then
                                            mkdir -p /usr/local/var/log
                                        fi
					echo "Installing  LSA_lib_utils2-1.00-00"
                			rpm -ivh LSA_lib_utils2-1.00-00.x86_64.rpm
					if [ $? = 0 ]; then
                                		echo "SLP Installation failed due to unresolved dependencies ! Proceeding with LSA installation now. Please try install SLP from installation source beforr starting LSA to have functionalities work as expected..."
                        		fi
        			else
                			echo "Installation exited...Please install SLP from installation source and return to install LSA. See you soon with the SLP installation..."
					exit
        			fi
			fi
                fi
                if [ $lib_newdate -eq $lib_olddate ]; then
                        echo "Latest LSA_lib_utils2 RPM is already installed"
                fi
fi

# Complete Installation
step1status_LSA=0
step1status_monitor=0
#if [ "$setuptype" = "c" ]; then
uninst="/opt/lsi/LSIStorageAuthority/.__uninst.sh"
	rpm -i --test LSIStorageAuthority-002.222.000.000-00.x86_64.rpm
	status=$?
	if [ $status = 0 ]; then
  		echo "Installing  LSIStorageAuthority-002.222.000.000-00"
  		rpm -ivh LSIStorageAuthority-002.222.000.000-00.x86_64.rpm
	else
		step1status_LSA=1
  		echo "LSIStorageAuthority RPM Installation Failed"
  		exit 1
	fi
	
	if [ $step1status_LSA = 0 ]; then
		echo "echo \"Uninstalling LSIStorageAuthority-002.222.000.000-00\"" >> $uninst
		echo "rpm -e LSIStorageAuthority-002.222.000.000-00 > /tmp/LSIStorageAuthority_uninstall.txt 2>&1" >> $uninst
		echo "status=\$?" >>$uninst
		echo "if [ \$status -ne 0 ]; then" >> $uninst
		echo "     exit 1" >> $uninst
		echo "fi" >> $uninst

        if [ -d "/opt/lsi/LSA/libs2" ]; then
                        echo "echo \"Uninstalling LSA_lib_utils2-1.00-00\"" >> $uninst
                        echo "rpm -e LSA_lib_utils2-1.00-00 > /tmp/LSIStorageAuthority_uninstall.txt 2>&1" >> $uninst
                        echo "status=\$?" >>$uninst
                        echo "if [ \$status -ne 0 ]; then" >> $uninst
                        echo "     exit 1" >> $uninst
                        echo "fi" >> $uninst
                fi
 
                echo "echo \"Uninstalling LSA_lib_utils-1.00-00\"" >> $uninst
                echo "rpm -e LSA_lib_utils-1.00-00 > /tmp/LSIStorageAuthority_uninstall.txt 2>&1" >> $uninst
                echo "status=\$?" >>$uninst
                echo "if [ \$status -ne 0 ]; then" >> $uninst
                echo "     exit 1" >> $uninst
                echo "fi" >> $uninst

		chmod +x $uninst
	fi
#fi

}

update_conf ()
{
	LSA_home="/opt/lsi/LSIStorageAuthority"
	new_nginx_port=$nginxPort
	new_LSA_port=$LSAappPort
	install_type="installation_type = "
	#echo $old_nginx_port
	#echo $old_LSA_port
	#echo $new_nginx_port
	#echo $new_LSA_port

	var=`cat /opt/lsi/LSIStorageAuthority/installtype`
	act_str="retrieve_range_of_events_since = 0"
	rep_str="retrieve_range_of_events_since = $setupstate"

	if [ "$var" == "gateway" ]; then
	new_installation_type="0"
	old_nginx_port=`grep "default_server" $LSA_home/server/conf/nginx.conf | cut -b 22-34 | head -n 1`
	old_LSA_port=`grep "listening_port = " $LSA_home/conf/LSA.conf |  cut -b 18-21`
	temp=`echo $old_LSA_port | sed 's/[^0-9]*//g'`
        old_LSA_port="LSA_Default"
	old_installation_type=`grep "installation_type = " $LSA_home/conf/LSA.conf |  cut -b 21-23`
	old_LSA_client_port=`grep "client_listening_port" $LSA_home//conf/LSA.conf | cut -b 25-28 | head -n 1`
	sed -e s/"$install_type$old_installation_type"/"$install_type$new_installation_type"/g "$LSA_home/conf/LSA.conf" > "$LSA_home/conf/LSA.conf_new"
	cp "$LSA_home/conf/LSA.conf_new" "$LSA_home/conf/LSA.conf"
	rm -rf "$LSA_home/conf/LSA.conf_new"	
	sed -e s/$old_nginx_port/$new_nginx_port/g "$LSA_home/server/conf/nginx.conf" > "$LSA_home/server/conf/nginx.conf_new"
	cp "$LSA_home/server/conf/nginx.conf_new" "$LSA_home/server/conf/nginx.conf"
	rm -rf "$LSA_home/server/conf/nginx.conf_new"
        #sed -e s/$old_nginx_port/$new_nginx_port/g "$LSA_home/server/conf/Sample_SSL_https/nginx.conf" > "$LSA_home/server/conf/Sample_SSL_https/nginx.conf_new"
        #cp "$LSA_home/server/conf/Sample_SSL_https/nginx.conf_new" "$LSA_home/server/conf/Sample_SSL_https/nginx.conf"
        #rm -rf "$LSA_home/server/conf/Sample_SSL_https/nginx.conf_new"
	sed -e s/$old_LSA_port/$new_LSA_port/g "$LSA_home/conf/LSA.conf" > "$LSA_home/conf/LSA.conf_new"
	cp "$LSA_home/conf/LSA.conf_new" "$LSA_home/conf/LSA.conf"
	rm -rf "$LSA_home/conf/LSA.conf_new"
        sed -e s/$old_LSA_client_port/$new_nginx_port/g "$LSA_home/conf/LSA.conf" > "$LSA_home/conf/LSA.conf_new"
        cp "$LSA_home/conf/LSA.conf_new" "$LSA_home/conf/LSA.conf"
        rm -rf "$LSA_home/conf/LSA.conf_new"
	sed -e s/$old_LSA_port/$new_LSA_port/g "$LSA_home/server/conf/nginx.conf" > "$LSA_home/server/conf/nginx.conf_new"
	cp "$LSA_home/server/conf/nginx.conf_new" "$LSA_home/server/conf/nginx.conf"
	rm -rf "$LSA_home/server/conf/nginx.conf_new"
	#sed -e s/$old_LSA_port/$new_LSA_port/g "$LSA_home/server/conf/Sample_SSL_https/nginx.conf" > "$LSA_home/server/conf/Sample_SSL_https/nginx.conf_new"
	#cp "$LSA_home/server/conf/Sample_SSL_https/nginx.conf_new" "$LSA_home/server/conf/Sample_SSL_https/nginx.conf"
	#rm -rf "$LSA_home/server/conf/Sample_SSL_https/nginx.conf_new"

	elif [ "$var" == "standalone" ]; then
	new_installation_type="1"
	old_nginx_port=`grep "default_server" $LSA_home/server/conf/nginx.conf | cut -b 22-34 | head -n 1`
	old_LSA_port=`grep "listening_port = " $LSA_home/conf/LSA.conf |  cut -b 18-21`
        temp=`echo $old_LSA_port | sed 's/[^0-9]*//g'`    
        old_LSA_port="LSA_Default"
	old_installation_type=`grep "installation_type = " $LSA_home/conf/LSA.conf |  cut -b 21-23`
	old_LSA_client_port=`grep "client_listening_port" $LSA_home//conf/LSA.conf | cut -b 25-28 | head -n 1`
	sed -e s/$old_nginx_port/$new_nginx_port/g "$LSA_home/server/conf/nginx.conf" > "$LSA_home/server/conf/nginx.conf_new"
	cp "$LSA_home/server/conf/nginx.conf_new" "$LSA_home/server/conf/nginx.conf"
	rm -rf "$LSA_home/server/conf/nginx.conf_new"
        #sed -e s/$old_nginx_port/$new_nginx_port/g "$LSA_home/server/conf/Sample_SSL_https/nginx.conf" > "$LSA_home/server/conf/Sample_SSL_https/nginx.conf_new"
        #cp "$LSA_home/server/conf/Sample_SSL_https/nginx.conf_new" "$LSA_home/server/conf/Sample_SSL_https/nginx.conf"
        #rm -rf "$LSA_home/server/conf/Sample_SSL_https/nginx.conf_new"
	sed -e s/$old_LSA_port/$new_LSA_port/g "$LSA_home/conf/LSA.conf" > "$LSA_home/conf/LSA.conf_new"
	cp "$LSA_home/conf/LSA.conf_new" "$LSA_home/conf/LSA.conf"
	rm -rf "$LSA_home/conf/LSA.conf_new"
	sed -e s/"$install_type$old_installation_type"/"$install_type$new_installation_type"/g "$LSA_home/conf/LSA.conf" > "$LSA_home/conf/LSA.conf_new"
	cp "$LSA_home/conf/LSA.conf_new" "$LSA_home/conf/LSA.conf"
	rm -rf "$LSA_home/conf/LSA.conf_new"
        sed -e s/$old_LSA_client_port/$new_nginx_port/g "$LSA_home/conf/LSA.conf" > "$LSA_home/conf/LSA.conf_new"
        cp "$LSA_home/conf/LSA.conf_new" "$LSA_home/conf/LSA.conf"
        rm -rf "$LSA_home/conf/LSA.conf_new"
	sed -e s/$old_LSA_port/$new_LSA_port/g "$LSA_home/server/conf/nginx.conf" > "$LSA_home/server/conf/nginx.conf_new"
	cp "$LSA_home/server/conf/nginx.conf_new" "$LSA_home/server/conf/nginx.conf"
	rm -rf "$LSA_home/server/conf/nginx.conf_new"
	#sed -e s/$old_LSA_port/$new_LSA_port/g "$LSA_home/server/conf/Sample_SSL_https/nginx.conf" > "$LSA_home/server/conf/Sample_SSL_https/nginx.conf_new"
	#cp "$LSA_home/server/conf/Sample_SSL_https/nginx.conf_new" "$LSA_home/server/conf/Sample_SSL_https/nginx.conf"
	#rm -rf "$LSA_home/server/conf/Sample_SSL_https/nginx.conf_new"
	
	elif [ "$var" == "directagent" ]; then
	new_installation_type="2"
	old_nginx_port=`grep "default_server" $LSA_home/server/conf/nginx.conf | cut -b 22-34 | head -n 1`
	old_LSA_port=`grep "listening_port = " $LSA_home/conf/LSA.conf |  cut -b 18-21`
        temp=`echo $old_LSA_port | sed 's/[^0-9]*//g'`    
        old_LSA_port="LSA_Default"
	old_installation_type=`grep "installation_type = " $LSA_home/conf/LSA.conf |  cut -b 21-23`
	old_LSA_client_port=`grep "client_listening_port" $LSA_home//conf/LSA.conf | cut -b 25-28 | head -n 1`
	sed -e s/$old_nginx_port/$new_nginx_port/g "$LSA_home/server/conf/nginx.conf" > "$LSA_home/server/conf/nginx.conf_new"
	cp "$LSA_home/server/conf/nginx.conf_new" "$LSA_home/server/conf/nginx.conf"
	rm -rf "$LSA_home/server/conf/nginx.conf_new"
        #sed -e s/$old_nginx_port/$new_nginx_port/g "$LSA_home/server/conf/Sample_SSL_https/nginx.conf" > "$LSA_home/server/conf/Sample_SSL_https/nginx.conf_new"
        #cp "$LSA_home/server/conf/Sample_SSL_https/nginx.conf_new" "$LSA_home/server/conf/Sample_SSL_https/nginx.conf"
        #rm -rf "$LSA_home/server/conf/Sample_SSL_https/nginx.conf_new"
	sed -e s/$old_LSA_port/$new_LSA_port/g "$LSA_home/conf/LSA.conf" > "$LSA_home/conf/LSA.conf_new"
	cp "$LSA_home/conf/LSA.conf_new" "$LSA_home/conf/LSA.conf"
	rm -rf "$LSA_home/conf/LSA.conf_new"
	sed -e s/"$install_type$old_installation_type"/"$install_type$new_installation_type"/g "$LSA_home/conf/LSA.conf" > "$LSA_home/conf/LSA.conf_new"
	cp "$LSA_home/conf/LSA.conf_new" "$LSA_home/conf/LSA.conf"
	rm -rf "$LSA_home/conf/LSA.conf_new"
        sed -e s/$old_LSA_client_port/$new_nginx_port/g "$LSA_home/conf/LSA.conf" > "$LSA_home/conf/LSA.conf_new"
        cp "$LSA_home/conf/LSA.conf_new" "$LSA_home/conf/LSA.conf"
        rm -rf "$LSA_home/conf/LSA.conf_new"
	sed -e s/$old_LSA_port/$new_LSA_port/g "$LSA_home/server/conf/nginx.conf" > "$LSA_home/server/conf/nginx.conf_new"
	cp "$LSA_home/server/conf/nginx.conf_new" "$LSA_home/server/conf/nginx.conf"
	rm -rf "$LSA_home/server/conf/nginx.conf_new"
	#sed -e s/$old_LSA_port/$new_LSA_port/g "$LSA_home/server/conf/Sample_SSL_https/nginx.conf" > "$LSA_home/server/conf/Sample_SSL_https/nginx.conf_new"
	#cp "$LSA_home/server/conf/Sample_SSL_https/nginx.conf_new" "$LSA_home/server/conf/Sample_SSL_https/nginx.conf"
	#rm -rf "$LSA_home/server/conf/Sample_SSL_https/nginx.conf_new"

	elif [ "$var" == "lightweightmonitor" ]; then
	new_installation_type="129"
	old_installation_type=`grep "installation_type = " $LSA_home/conf/LSA.conf |  cut -b 21-23`
	sed -e s/"$install_type$old_installation_type"/"$install_type$new_installation_type"/g "$LSA_home/conf/LSA.conf" > "$LSA_home/conf/LSA.conf_new"
	cp "$LSA_home/conf/LSA.conf_new" "$LSA_home/conf/LSA.conf"
	rm -rf "$LSA_home/conf/LSA.conf_new"	
	fi

	sed -e s/"$act_str"/"$rep_str"/g "$LSA_home/conf/LSA.conf" > "$LSA_home/conf/LSA.conf_new"
	mv "$LSA_home/conf/LSA.conf_new" "$LSA_home/conf/LSA.conf"
}

service_restart ()
{
        ln -sf /opt/lsi/LSA/libs/libcrypto.so.1.0.0 /opt/lsi/LSIStorageAuthority/bin/libcrypto.so.1.0.0
        ln -sf /opt/lsi/LSA/libs/libssl.so.1.0.0 /opt/lsi/LSIStorageAuthority/bin/libssl.so.1.0.0

	if [ -d /opt/lsi/LSA/libs2 ]; then
		ln -sf /opt/lsi/LSA/libs2/libslp.so.1.0.0 /opt/lsi/LSIStorageAuthority/plugins/libslp.so.1
	fi
	
	/etc/init.d/LsiSASH restart
}

#######################################
############ Main #####################
#######################################
	getUserInput
	install_rpms
	update_conf
	service_restart
