##############################################
# PATH
##############################################
MAKE_DIR          = $(CURDIR)
TOOLS_DIR         = $(MAKE_DIR)/tools
SCRIPTS_DIR       = $(MAKE_DIR)/scripts

BL_FLS_DIR       = $(MAKE_DIR)/Bootloader
BL_SCRIPTS_DIR   = $(BL_FLS_DIR)/scripts
BL_KEYS_DIR      = $(BL_FLS_DIR)/keys

BSP_FLS_DIR       = $(MAKE_DIR)/BSP
BSP_SCRIPTS_DIR   = $(BSP_FLS_DIR)/scripts
BSP_KEYS_DIR      = $(BSP_FLS_DIR)/keys

##############################################
# OPTION
##############################################
PSI_FORMAT ?= PKCS


##############################################
# TOOLS
##############################################
FLSTOOL ?= $(TOOLS_DIR)/flstool/FlsTool
FWPGEN  ?= $(TOOLS_DIR)/fwpgen/fwpgen
SIGNAPK ?= $(TOOLS_DIR)/signapk/signapk.jar  ## from out/host/linux-x86/framework/signapk.jar

##############################################
# SCRIPTS
##############################################
ifeq ($(PSI_FORMAT), Legacy)
	BOOTLOADER_SCRIPT_BL         ?= $(BL_SCRIPTS_DIR)/bootloader.bl_signing_script.txt
	FLASHLOADER_SCRIPT_BL        ?= $(BL_SCRIPTS_DIR)/flashloader.bl_signing_script.txt
	BOOTLOADER_SCRIPT_BSP        ?= $(BSP_SCRIPTS_DIR)/bootloader.bsp_signing_script.txt
	FLASHLOADER_SCRIPT_BSP       ?= $(BSP_SCRIPTS_DIR)/flashloader.bsp_signing_script.txt
else
	BOOTLOADER_SCRIPT_BL         ?= $(BL_SCRIPTS_DIR)/bootloader.bl_signing_script_pkcs.txt
	FLASHLOADER_SCRIPT_BL        ?= $(BL_SCRIPTS_DIR)/flashloader.bl_signing_script_pkcs.txt
	BOOTLOADER_SCRIPT_BSP        ?= $(BSP_SCRIPTS_DIR)/bootloader.bsp_signing_script_pkcs.txt
	FLASHLOADER_SCRIPT_BSP       ?= $(BSP_SCRIPTS_DIR)/flashloader.bsp_signing_script_pkcs.txt
endif
SYSTEM_SIGN_SCRIPT           ?= $(BSP_SCRIPTS_DIR)/system.signing_script.txt
ZIP_CERTIFICATE              ?= $(BL_SCRIPTS_DIR)/sofia3gr_ini.zip
BINARY_SIGN_SCRIPT           ?= $(BSP_SCRIPTS_DIR)/binary_signing_script.txt
VRL_SIGN_SCRIPT              ?= $(BSP_SCRIPTS_DIR)/vrl_signing_script.txt

##############################################
# Bootloader KEYS
##############################################
PRI_KEYS_BL       ?= $(BL_KEYS_DIR)/Gprk.key
GPUK              ?= $(BL_KEYS_DIR)/GpukCert.bin
PUBLIC_KEYS_BL    ?= $(BL_KEYS_DIR)/ProdPubKeys.bin

##############################################
# BSP KEYS
##############################################
PRI_KEYS_BSP       ?= $(BSP_KEYS_DIR)/Mprk.key $(BSP_KEYS_DIR)/Sprk.key
PUBLIC_KEYS_BSP    ?= $(BSP_KEYS_DIR)/ProdPubKeys.bin

##############################################
# OTHERS
##############################################
SHELL = /bin/bash
ECHO_GREEN_COLOR   = \033[32m\033[1m
ECHO_RED_COLOR     = \033[31m\033[1m
ECHO_YELLOW_COLOR     = \033[33m\033[1m
ECHO_COLOR_NONE = \033[0m
