#/bin/sh
#set -x
UNINSTALL_SDPTool="NO"
INSTALL_SDPTool="NO"
SDPTool_INSTALL_DIR="/usr/local/SDPTool"
SUPPORTED_OS="NO"

if [ -f License.txt ]; then
    cat License.txt | more
elif [ -f license.txt ]; then
    cat license.txt | more
else
    echo -n "License not found"
fi

reply=
while [[ $reply != "Y" && $reply != "y" && $reply != "N" && $reply != "n" ]]; do
    echo "Accept? (Y/N)"
    read reply
done
if [[ $reply = "N" || $reply = "n" ]]; then
  exit
fi

if [ -d "${SDPTool_INSTALL_DIR}" ] && [ -n "$(ls -A ${SDPTool_INSTALL_DIR})" ];
then
        echo -e "\e[1;33mAnother version of SDPTool already installed. Use uninstall scripts sdptool_uninstall.sh before proceed New installation.\e[0m"
        exit
fi

## Check if RedHat  / SUSE
if [ -f "/etc/SuSE-release" ]
    then
    ## Check for SLES 11 & 12
    OSVer_11=$(grep "VERSION *= *11" /etc/SuSE-release)
    OSVer_12=$(grep "VERSION *= *12" /etc/SuSE-release)

    if [[ $OSVer_11 ]]; then
        ## Check for 32 / x64
        ARCH=`uname -m|grep x86_64 > /dev/null 2>&1`
        if [ $? = 0 ]
            then
            # x86_64
            # installing...
            echo "This is SuSE version 11(64bit) installation..... "
            mkdir -p ${SDPTool_INSTALL_DIR}
            echo "Installing Intel(R) SDPTool..."
            SUPPORTED_OS="YES"
            tar -xzf ./sles11/SDPTool_*-x86_64.tar.gz -C ${SDPTool_INSTALL_DIR}
        #else
            # installing...
        #    echo "Installing Intel(R) SDPTool..."
        #    tar -xzf ./sles11/SDPTool_*i*.tar.gz -C ${SDPTool_INSTALL_DIR}
        fi
    elif [[ $OSVer_12 ]]; then
        echo "This is SuSE version 12 installation..... "
        mkdir -p ${SDPTool_INSTALL_DIR}
        # installing...
        echo "Installing Intel(R) SDPTool..."
        SUPPORTED_OS="YES"
        tar -xzf ./rhel7_sles12/SDPTool_*-x86_64.tar.gz -C ${SDPTool_INSTALL_DIR}
    fi
elif [ -f /etc/redhat-release ] || [ -f /etc/centos-release ]; then
    RH6_RELEASE=""
    RH7_RELEASE=""
    CENTOS6_RELEASE=""
    CENTOS7_RELEASE=""
    #Check RHEL Version
    if [ -f /etc/redhat-release ]; then
        RH6_RELEASE=`grep -i "red hat .* release 6.*" /etc/redhat-release` #Added for RHEL6
        RH7_RELEASE=`grep -i "red hat .* release 7.*" /etc/redhat-release` #Added for RHEL7
    fi

    if [ -f /etc/centos-release ]; then
        CENTOS6_RELEASE=`grep -i "centos .* release 6.*" /etc/centos-release` #Added for CentOS6
        CENTOS7_RELEASE=`grep -i "centos .* release 7.*" /etc/centos-release` #Added for CentOS7
    fi

    if [[ $RH7_RELEASE ]] || [[ $CENTOS7_RELEASE ]]
        then
        echo "This is Red Hat or CentOS version 7(64bit) installation..... "
        # installing...
        mkdir -p ${SDPTool_INSTALL_DIR}
        echo "Installing Intel(R) SDPTool..."
        SUPPORTED_OS="YES"
        tar -xzf ./rhel7_sles12/SDPTool_*-x86_64.tar.gz -C ${SDPTool_INSTALL_DIR}
    elif [[ $RH6_RELEASE ]] || [[ $CENTOS6_RELEASE ]]
        then
        #Check if EM64
        ARCH=`uname -m|grep x86_64 > /dev/null 2>&1`
        if [ $? = 0 ]
            then
            # x86_64
            # installing...
            echo "This is Red Hat or CentOS version 6(64bit) installation..... "
            mkdir -p ${SDPTool_INSTALL_DIR}
            echo "Installing Intel(R) SDPTool..."
            SUPPORTED_OS="YES"
            tar -xzf ./rhel6/SDPTool_*-x86_64.tar.gz -C ${SDPTool_INSTALL_DIR}
        fi
        #else
            # installing...
        #    echo "Installing Intel(R) SDPTool..."
        #    tar -xzf ./rhel6/SDPTool_*i*.tar.gz -C ${SDPTool_INSTALL_DIR}
        #fi
    fi
fi


if [ $? != 0 ]
then
    echo "Failed to install the SDPTool in ${SDPTool_INSTALL_DIR}. Exiting."
    exit 1
fi

if [ "$SUPPORTED_OS" == "NO" ]
then
    echo "Unsupported OS found. Supported OS is Red Hat/CentOS version 6 or above(64bit) and SuSE version 11 or above(64bit)."
    echo "Aborting installation of Intel(R) SDPTool."
    exit 1
fi

echo "Intel(R) SDPTool installed successfully in ${SDPTool_INSTALL_DIR}"
cp sdptool_uninstall.sh ${SDPTool_INSTALL_DIR}
exit 0
