SUMMARY = "Intel® Integrated Performance Primitives (Intel IPP)"
LICENSE = "Proprietary"
LIC_FILES_CHKSUM = "file://${COMMON_LICENSE_DIR}/Proprietary;md5=0557f9d92cf58f2ccdd50f62f8ac0b28"

SRC_URI = "file://${RPM_PATH}/system_studio_*/rpm/intel-comp-l-all-vars-*.noarch.rpm \
           file://${RPM_PATH}/system_studio_*/rpm/intel-ipp-l-common-*.noarch.rpm \
           file://${RPM_PATH}/system_studio_*/rpm/intel-ipp-l-doc-*.noarch.rpm \
           file://${RPM_PATH}/system_studio_*/rpm/intel-ipp-l-st-*.x86_64.rpm \
           file://${RPM_PATH}/system_studio_*/rpm/intel-ipp-l-st-devel-*.x86_64.rpm \
           file://${RPM_PATH}/system_studio_*/rpm/intel-ipp-ss-common-*.noarch.rpm \
           file://${RPM_PATH}/system_studio_*/rpm/intel-ipp-ss-st-devel-*.x86_64.rpm; \
           file://${RPM_PATH}/system_studio_*/rpm/intel-ipp-sta-ss-common-*.noarch.rpm \
           file://${RPM_PATH}/system_studio_*/rpm/intel-openmp-l-all-*.x86_64.rpm"

RDEPENDS_${PN} = "glib-2.0 tcsh"
INSANE_SKIP_${PN} += "already-stripped dev-so staticdev ldflags"

FILES_${PN} = "/"

INHIBIT_PACKAGE_DEBUG_SPLIT = "1"
INHIBIT_PACKAGE_STRIP = "1"

do_configure[noexec] = "1"
do_compile[noexec] = "1"

do_install() {

    rm -rf ${WORKDIR}/opt/intel/compilers_and_libraries_*/linux/ipp/tools
    rm -rf ${WORKDIR}/opt/intel/compilers_and_libraries_*/linux/ipp/lib/intel64_lin/nonpic
    rm ${WORKDIR}/opt/intel/compilers_and_libraries_*/linux/ipp/lib/intel64_lin/libipp*e9.so
    rm ${WORKDIR}/opt/intel/compilers_and_libraries_*/linux/ipp/lib/intel64_lin/libipp*l9.so
    rm ${WORKDIR}/opt/intel/compilers_and_libraries_*/linux/ipp/lib/intel64_lin/libipp*n8.so
    rm ${WORKDIR}/opt/intel/compilers_and_libraries_*/linux/ipp/lib/intel64_lin/libipp*k0.so
    rm ${WORKDIR}/opt/intel/compilers_and_libraries_*/linux/ipp/lib/intel64_lin/libipp*m7.so
    rm ${WORKDIR}/opt/intel/compilers_and_libraries_*/linux/ipp/lib/intel64_lin/libipp*n0.so
    rm ${WORKDIR}/opt/intel/compilers_and_libraries_*/linux/ipp/lib/intel64_lin/libipp*mx.so

    install -m 0644 -d  ${D}/opt/intel/ipp \
                        ${D}/opt/intel/ipp/compiler \
                        ${D}/opt/intel/ipp/documentation_2017 \

    # Installation of Intel IPP tools
    cp -r ${WORKDIR}/opt/intel/compilers_and_libraries_*/linux/ipp/*       ${D}/opt/intel/ipp
    cp -r ${WORKDIR}/opt/intel/compilers_and_libraries_*/linux/compiler/*  ${D}/opt/intel/ipp/compiler
    cp -r ${WORKDIR}/opt/intel/documentation_*/* ${D}/opt/intel/ipp/documentation_2017
}
