SUMMARY = "Intel(R) VTune(TM) for Systems standalone SoC Watch collector target package"
DESCRIPTION = "Intel(R) VTune(TM) for Systems standalone SoC Watch collector target package"

inherit module-base
addtask make_scripts after do_patch before do_compile

do_make_scripts[lockfiles] = "${TMPDIR}/kernel-scripts.lock"
do_make_scripts[deptask] = "do_populate_sysroot"

HOMEPAGE = "http://www.intel.com/software/products"
LICENSE = "BSD-2-Clause"
SECTION = "devel"
ISS_PRODUCT_NAME="Intel(R) System Studio 2017"
LIC_FILES_CHKSUM = "${ISS_LICENSE_FILE}"
PR = "r0"
PACKAGES="${PN}"

# kernel must be built first, in order to build kernel modules
DEPENDS += "virtual/kernel"

# Disabling automatic scanning for shared libraries
# to avoid providing them for other packages
EXCLUDE_FROM_SHLIBS="1"

# tell bitbake to skip binary files stripping
INHIBIT_PACKAGE_STRIP = "1"
INHIBIT_PACKAGE_DEBUG_SPLIT = "1"

# tell bitbake to include all files, even outside of default dirs
FILES_${PN} = "/*"

# Directly copy the 'source' dir to the install dir
FILES_${PN} += "/opt/intel/vtune_amplifier*"

# Remove all files from RPM "Provides:"
SKIP_FILEDEPS = "1"

## Fix QA warnings
INSANE_SKIP_${PN} = "ldflags"
INSANE_SKIP_${PN} += "textrel"
INSANE_SKIP_${PN} += "dev-so"

VTUNE_IN_ISS_DIR="vtune_amplifier_for_systems"
VTUNE_SUPPORTED_ARCH = "i386 i586 i686 x86_64 amd64"

python () {
    karch = d.getVar("TARGET_ARCH", True)

    if karch not in d.getVar("VTUNE_SUPPORTED_ARCH", True).split():
        bb.error("'%s' does not support '%s' architecture" % (d.getVar("SUMMARY", True), karch))

    target_arch = "x86_64" if karch == "x86_64" or karch == "amd64" else "x86"
    d.setVar("SOCWATCH_TARGET_ARCH", target_arch)
}

# VTune features provided: SoC Watch standalone collector
PROVIDES += "virtual/intel-iss-socwatch-target"

ISS_SOCWATCH_TARGET_DIR="socwatch*linux*_v*_${SOCWATCH_TARGET_ARCH}"
ISS_SOCWATCH_TARGET_FILE="${ISS_SOCWATCH_TARGET_DIR}.tar.gz"

do_unpack() {

    set -xv

    [ -d "${S}" ] && rm -rf "${S}"
    mkdir -p ${S}
    cd ${S}

    vtune_target_file_real=`echo "${ISS_SOCWATCH_TARGET_FILE}" | sed -e "s/#ARCH#/${ISS_SOCWATCH_TARGET_FILE}/g"`

    # Trying to access the socwatch package from the specified location in RPM_PATH
    socwatch_archive="${RPM_PATH}/${vtune_target_file_real}"
    socwatch_archive=`echo ${socwatch_archive}`
    if [ -f "${socwatch_archive}" -a -r "${socwatch_archive}" ]
    then
        tar xzf "${socwatch_archive=}"
        echo "SoC Watch package ${socwatch_archive} found in directory ${RPM_PATH} specified in variable RPM_PATH"
        return
    fi
}

do_compile() {

    set -xv

    # Compiling SoC Watch drivers
    local current_dir target_dir

    current_dir="$PWD"
    target_dir="${S}/${ISS_SOCWATCH_TARGET_DIR}"
    target_dir=`echo ${target_dir}`
	cd "${target_dir}"

    fixedcc=`echo ${KERNEL_CC} |cut -d " " -f 1`
    bash -x ./build_drivers.sh -l -k ${STAGING_KERNEL_BUILDDIR} -c $fixedcc

    if [ $? -ne 0]
    then
        bbfatal "Failed to build the SoC Watch drivers"
    fi

    cd "$current_dir"

}

do_install() {

    set -xv

    compile_socwatch_target_dir="${S}/${ISS_SOCWATCH_TARGET_DIR}"
    compile_socwatch_target_dir=`echo ${compile_socwatch_target_dir}`
	cd "${compile_socwatch_target_dir}"

    #or use basename `pwd` to get current folder name
    install_socwatch_target_dir=${D}/opt/intel/socwatch
    mkdir -p "${install_socwatch_target_dir}"

    dirs_tocopy=`ls -1`

    cp -r ${dirs_tocopy} "${install_socwatch_target_dir}"

    # denverton_soc folder is missing in some versions of SoC Watch.
    # causing bandwidth data collections to fail on denverton based platforms
    # workaround is to create it here
    if ! [ -d "${install_socwatch_target_dir}/denverton_soc" ]
    then
        if [ -d "${install_socwatch_target_dir}/broxton_soc" ]
        then
            cp -r "${install_socwatch_target_dir}/broxton_soc" "${install_socwatch_target_dir}/denverton_soc"
        fi
    fi

    # create a symbolic link to the default socwatch installation location in /home/socwatch

    install_socwatch_target_link=${D}/home
    mkdir -p "${install_socwatch_target_link}"
    ln -s ${install_socwatch_target_dir} ${install_socwatch_target_link}/socwatch

    if [ ${SOCWATCH_TARGET_ARCH} = "x86_64" ]
    then
       # creating symbolic link lib64 to lib because socwatch binaries are compiled
       # with the interpreter expected in /lib64
       if ! [ -d ${D}/lib64 ]
       then
           ln -s /lib ${D}/lib64
       fi
    else
       # creating symbolic link lib32 to lib because socwatch binaries are compiled
       # with the interpreter expected in /lib32
       if ! [ -d ${D}/lib32 ]
       then
           ln -s /lib ${D}/lib32
       fi
    fi

    # libfgnustl_share.so is not used on Yocto.
    # it causes a QA bitbake error when building a 64 bit image since it is 32bit.
    libgnustl_so=${install_socwatch_target_dir}/libs/libgnustl_shared.so
    if [ -f ${libgnustl_so} ]
    then
        rm ${libgnustl_so}
    fi
}
