
# Part of module.bbclass but not module.bbclass itself because
# it also doing some unnecessary install and packaging things


inherit module-base
addtask make_scripts after do_patch before do_compile
do_make_scripts[lockfiles] = "${TMPDIR}/kernel-scripts.lock"
do_make_scripts[deptask] = "do_populate_sysroot"


HOMEPAGE = "http://www.intel.com/software/products"
LICENSE = "BSD-2-Clause"
SECTION = "devel"
ISS_PRODUCT_NAME="Intel(R) System Studio 2017"

PR = "r0"

LIC_FILES_CHKSUM = "${ISS_LICENSE_FILE}"

# kernel must be built first, in order to build kernel modules
DEPENDS += "virtual/kernel"

PACKAGES="${PN}"

# Disabling automatic scanning for shared libraries
# to avoid providing them for other packages
EXCLUDE_FROM_SHLIBS="1"

# tell bitbake to skip binary files stripping
INHIBIT_PACKAGE_STRIP = "1"
INHIBIT_PACKAGE_DEBUG_SPLIT = "1"

# tell bitbake to include all files, even outside of default dirs
FILES_${PN} = "/*"

# Directly copy the 'source' dir to the install dir
FILES_${PN} += "/opt/intel/vtune_amplifier*"

# Remove all files from RPM "Provides:"
SKIP_FILEDEPS = "1"

## Fix QA warnings
INSANE_SKIP_${PN} = "ldflags"
INSANE_SKIP_${PN} += "textrel"
INSANE_SKIP_${PN} += "dev-so"

#vtune_kernel_arch="${TARGET_ARCH}"

VTUNE_ISS_TARGET_DIR="vtune_amplifier*for_systems*"

VTUNE_ISS_INSTALLBUILD_DIR="${S}/frombuild"

VTUNE_IN_ISS_DIR="vtune_amplifier_for_systems"

VTUNE_SUPPORTED_ARCH = "i386 i586 i686 x86_64 amd64"


python () {
    karch = d.getVar("TARGET_ARCH", True)

    if karch not in d.getVar("VTUNE_SUPPORTED_ARCH", True).split():
        bb.error("'%s' does not support '%s' architecture" % (d.getVar("SUMMARY", True), karch))

    target_suff = "x86_64" if karch == "x86_64" or karch == "amd64" else "x86"

#    vtune_target_arch_dir = "linux64" if karch == "x86_64" or karch == "amd64" else "linux32"

    build_suff  = "x32_64" if karch == "x86_64" or karch == "amd64" else "x32"

    d.setVar("VTUNE_ISS_TARGETFILE_SUFF", target_suff)

    d.setVar("VTUNE_ISS_DRIVER_ARCH", build_suff)

#    d.setVar("VTUNE_ISS_TARGET_ARCH_DIR", vtune_target_arch_dir)
}

do_unpack() {

	set -xv

	[ -d "${S}" ] && rm -rf "${S}"
	mkdir -p ${S}
	cd ${S}
	vtune_target_file_real=`echo "${VTUNE_ISS_TARGET_FILE}" | sed -e "s/#ARCH#/${VTUNE_ISS_TARGETFILE_SUFF}/g"`

        # Trying to access the VTune target package from the specified location in RPM_PATH
        vtune_target_archive="${RPM_PATH}/${vtune_target_file_real}"
        vtune_target_archive=`echo ${vtune_target_archive}`
        if [ -f "${vtune_target_archive}" -a -r "${vtune_target_archive}" ]
        then
            tar xzf "${vtune_target_archive=}"
            echo "VTune target package ${vtune_target_archive} found in directory ${RPM_PATH} specified in variable RPM_PATH"
            return
        fi
}

run_build_driver() {

	config_file=""
	if [ -e "${STAGING_KERNEL_BUILDDIR}/.config" ]
	then
	    config_file="${STAGING_KERNEL_BUILDDIR}/.config"
	else
	    bbwarn "STAGING_KERNEL_BUILDDIR/.config missed. Trying KBUILD_OUTPUT environment variable..."

	    if [ -e "$KBUILD_OUTPUT/.config" ]
	    then
		config_file="$KBUILD_OUTPUT/.config"
	    else
		bbwarn "KBUILD_OUTPUT/.config missed"
	    fi
	fi

	if [ -z "$config_file" ]
	then
	    bbfatal "Cannot find kernel .config file"
	fi

	kernel_arity=$(grep "^CONFIG_SMP=y" $config_file | sed -e "s/.\+/smp/g")
	local driver_dir current_dir kernel_src_dir installto per_user
	driver_dir="$1"
	install_dir="$2"

	current_dir="$PWD"
	# prepare build flags

	# Compiling drivers
	if [ -n "${install_dir}" ]
	then
	    installto="--install-dir=${install_dir}"
	fi
	cd "$driver_dir"

	# Per-user drivers option
	if [ -n "${VTUNE_ISS_DRIVERS_PER_USER}" ]
	then
	    per_user="--per-user"
	fi

	# As it done it standard module.bbclas
	unset CFLAGS CPPFLAGS CXXFLAGS LDFLAGS
	#workaround for case when KERNEL_CC in addtition to compiler excutable contains options
	fixedcc=`echo ${KERNEL_CC} | cut -d " " -f 1`
	sh -x ./build-driver -ni \
	    --c-compiler=$fixedcc \
	    --kernel-src-dir=${STAGING_KERNEL_BUILDDIR} \
	    --kernel-version=${KERNEL_VERSION} \
	    --make-args="PLATFORM=${VTUNE_ISS_DRIVER_ARCH} \
			ARITY=$kernel_arity \
			LD=${KERNEL_LD} \
			AR=${KERNEL_AR}" \
	    "${installto}" \
	    ${per_user}


	bd_ret_code=$?
	cd "$current_dir"
	return $bd_ret_code
}

do_install() {

	# bbdebug does not work on Ubuntu because of [[
	#bbdebug 2 "Detected target architecture: ${TARGET_ARCH}"

	cd ${S}/${VTUNE_ISS_TARGET_DIR}

	#or use basename `pwd` to get current folder name
	install_vtune_target_dir=${D}/opt/intel/`echo ${PWD##*/}`
	mkdir -p "${install_vtune_target_dir}"

	dirs_tocopy=`ls -1 | grep -v sepdk | grep -v powerdk`
	cp -r ${dirs_tocopy} "${install_vtune_target_dir}"

#	[ -d "${VTUNE_ISS_INSTALLBUILD_DIR}/${install_vtune_target_dir}"

	cp -r ${VTUNE_ISS_INSTALLBUILD_DIR}/* "${install_vtune_target_dir}"


    if [ ${VTUNE_ISS_TARGETFILE_SUFF} = "x86_64" ]
    then
        # creating symbolic link lib64 to lib because sep binaries are compiled
        # with the interpreter expected in /lib64
        if ! [ -d ${D}/lib64 ]
        then
            ln -s /lib ${D}/lib64
        fi
    else
        # creating symbolic link lib32 to lib because vtune binaries are compiled
        # with the interpreter expected in /lib32
        if ! [ -d ${D}/lib32 ]
        then
            ln -s /lib ${D}/lib32
        fi
    fi

}
